/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.preferences.profile;

import com.aptana.core.logging.IdeLog;
import com.aptana.formatter.IContributedExtension;
import com.aptana.formatter.IScriptFormatterFactory;
import com.aptana.formatter.ScriptFormatterManager;
import com.aptana.formatter.epl.FormatterPlugin;
import com.aptana.formatter.preferences.PreferenceKey;
import com.aptana.formatter.preferences.profile.BuiltInProfile;
import com.aptana.formatter.preferences.profile.CustomProfile;
import com.aptana.formatter.preferences.profile.GeneralProfileVersioner;
import com.aptana.formatter.preferences.profile.IProfile;
import com.aptana.formatter.preferences.profile.IProfileManager;
import com.aptana.formatter.preferences.profile.IProfileStore;
import com.aptana.formatter.preferences.profile.IProfileVersioner;
import com.aptana.formatter.preferences.profile.ProfileKind;
import com.aptana.formatter.preferences.profile.ProfileStore;
import com.aptana.formatter.ui.FormatterMessages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileManager
implements IProfileManager {
    private static final String APTANA_CODE_FORMATTER_ID = "aptana.code.formatter";
    private static final String DEFAULT_PROFILE_ID = "com.aptana.formatter.profiles.default";
    private static final String ACTIVE_PROFILE_ID = "com.aptana.formatter.profiles.active";
    private static ProfileManager instance;
    private final Map<String, IProfile> fProfiles;
    private final List<IProfile> fProfilesByName;
    private ListenerList listeners;
    private Map<IProject, IProfile> fSelected;
    private boolean fDirty = false;
    private IProfileVersioner versioner;
    private PreferenceKey[] preferenceKeys;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProfileManager getInstance() {
        if (instance != null) return instance;
        Class<ProfileManager> clazz = ProfileManager.class;
        synchronized (ProfileManager.class) {
            if (instance != null) return instance;
            instance = new ProfileManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose() {
        Class<ProfileManager> clazz = ProfileManager.class;
        synchronized (ProfileManager.class) {
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private ProfileManager() {
        ArrayList<IProfile> profiles = new ArrayList<IProfile>();
        List<IProfile> builtInProfiles = this.getBuiltInProfiles();
        if (builtInProfiles != null && builtInProfiles.size() > 0) {
            profiles.addAll(builtInProfiles);
        } else {
            IdeLog.logError((Plugin)FormatterPlugin.getDefault(), (String)NLS.bind((String)FormatterMessages.AbstractFormatterSelectionBlock_noBuiltInProfiles, (Object)APTANA_CODE_FORMATTER_ID), (String)"com.aptana.formatter.epl/debug");
        }
        profiles.addAll(this.getCustomProfiles());
        this.fProfiles = new HashMap<String, IProfile>();
        this.fSelected = new HashMap<IProject, IProfile>();
        this.fProfilesByName = new ArrayList<IProfile>();
        for (IProfile profile : profiles) {
            this.fProfiles.put(profile.getID(), profile);
            this.fProfilesByName.add(profile);
        }
        Collections.sort(this.fProfilesByName);
        if (!this.fProfilesByName.isEmpty()) {
            String storedActiveProfile = this.getActiveProfileKey().getStoredValue(InstanceScope.INSTANCE);
            IProfile workspaceSelectedProfile = this.fProfiles.get(storedActiveProfile);
            if (workspaceSelectedProfile == null) {
                workspaceSelectedProfile = this.fProfilesByName.get(0);
            }
            this.fSelected.put(null, workspaceSelectedProfile);
        }
        this.listeners = new ListenerList();
    }

    private Map<String, String> loadDefaultSettings() {
        HashMap<String, String> settings = new HashMap<String, String>();
        PreferenceKey[] keys = this.getPreferenceKeys();
        if (keys != null) {
            IScopeContext scope = DefaultScope.INSTANCE;
            PreferenceKey[] preferenceKeyArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                PreferenceKey key = preferenceKeyArray[n2];
                String name = key.getName();
                IEclipsePreferences preferences = scope.getNode(key.getQualifier());
                String value = preferences.get(name, null);
                if (value != null) {
                    settings.put(name, value);
                }
                ++n2;
            }
        }
        return settings;
    }

    @Override
    public List<IProfile> getBuiltInProfiles() {
        ArrayList<IProfile> profiles = new ArrayList<IProfile>();
        IProfileVersioner versioner = this.getProfileVersioner();
        BuiltInProfile profile = new BuiltInProfile(this.getDefaultProfileID(), this.getDefaultProfileName(), this.loadDefaultSettings(), 1, APTANA_CODE_FORMATTER_ID, versioner.getCurrentVersion());
        profiles.add(profile);
        return profiles;
    }

    @Override
    public List<IProfile> getCustomProfiles() {
        String profilesSource;
        PreferenceKey profilesKey = this.getProfilesKey();
        if (profilesKey != null && (profilesSource = profilesKey.getStoredValue(InstanceScope.INSTANCE)) != null && profilesSource.length() > 0) {
            IProfileStore store = this.getProfileStore();
            try {
                return ((ProfileStore)store).readProfilesFromString(profilesSource);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)FormatterPlugin.getDefault(), (Throwable)e, (String)"com.aptana.formatter.epl/debug");
            }
        }
        return Collections.emptyList();
    }

    @Override
    public PreferenceKey getProfilesKey() {
        return new PreferenceKey("com.aptana.formatter.epl", APTANA_CODE_FORMATTER_ID);
    }

    private PreferenceKey[] getPreferenceKeys() {
        if (this.preferenceKeys == null) {
            this.preferenceKeys = ProfileManager.collectPreferenceKeys(new ArrayList<IScriptFormatterFactory>(), false);
        }
        return this.preferenceKeys;
    }

    @Override
    public IProfileStore getProfileStore() {
        return new ProfileStore(this.getProfileVersioner(), this.loadDefaultSettings());
    }

    public static PreferenceKey[] collectPreferenceKeys(List<IScriptFormatterFactory> factories, boolean forceBundleLoading) {
        ArrayList<PreferenceKey> result = new ArrayList<PreferenceKey>();
        IContributedExtension[] extensions = ScriptFormatterManager.getInstance().getAllContributions(forceBundleLoading);
        HashSet factoriesClasses = new HashSet();
        IContributedExtension[] iContributedExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IContributedExtension extension = iContributedExtensionArray[n2];
            IScriptFormatterFactory factory = (IScriptFormatterFactory)extension;
            if (factory.isContributingToUI() && !factoriesClasses.contains(factory.getClass())) {
                factoriesClasses.add(factory.getClass());
                factories.add(factory);
                PreferenceKey[] keys = factory.getPreferenceKeys();
                if (keys != null) {
                    int j = 0;
                    while (j < keys.length) {
                        PreferenceKey prefKey = keys[j];
                        result.add(prefKey);
                        ++j;
                    }
                }
            }
            ++n2;
        }
        return result.toArray(new PreferenceKey[result.size()]);
    }

    @Override
    public PreferenceKey getActiveProfileKey() {
        return new PreferenceKey("com.aptana.formatter.epl", ACTIVE_PROFILE_ID);
    }

    @Override
    public List<IProfile> getSortedProfiles() {
        return Collections.unmodifiableList(this.fProfilesByName);
    }

    @Override
    public String[] getSortedDisplayNames() {
        String[] sortedNames = new String[this.fProfilesByName.size()];
        int i = 0;
        for (IProfile curr : this.fProfilesByName) {
            sortedNames[i++] = curr.getName();
        }
        return sortedNames;
    }

    @Override
    public IProfile getSelected(IProject project) {
        IProfile selected = this.fSelected.get(project);
        if (selected == null && project != null) {
            ProjectScope scope;
            PreferenceKey activeProfileKey = this.getActiveProfileKey();
            IProfile profile = this.findProfile(activeProfileKey.getStoredValue((IScopeContext)(scope = new ProjectScope(project))));
            if (profile != null) {
                this.fSelected.put(project, profile);
                selected = profile;
            } else {
                selected = this.fSelected.get(null);
            }
        }
        return selected;
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void setSelected(IProject project, IProfile profile) {
        IProfile newSelected = this.fProfiles.get(profile.getID());
        IProfile prevSelected = this.getSelected(project);
        if (newSelected != null && !newSelected.equals(prevSelected)) {
            Object[] allListeners;
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "profile.selected", (Object)prevSelected, (Object)newSelected);
            this.fSelected.put(project, newSelected);
            Object[] objectArray = allListeners = this.listeners.getListeners();
            int n = allListeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IPropertyChangeListener)listener).propertyChange(event);
                ++n2;
            }
        }
    }

    @Override
    public boolean containsName(String name) {
        for (IProfile curr : this.fProfilesByName) {
            if (!name.equals(curr.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public IProfile findProfile(String profileId) {
        return this.fProfiles.get(profileId);
    }

    @Override
    public void addProfile(IProject project, IProfile profile) {
        if (profile instanceof CustomProfile) {
            CustomProfile newProfile = (CustomProfile)profile;
            CustomProfile oldProfile = (CustomProfile)this.fProfiles.get(profile.getID());
            if (oldProfile != null) {
                this.fProfiles.remove(oldProfile.getID());
                this.fProfilesByName.remove(oldProfile);
            }
            this.fProfiles.put(profile.getID(), profile);
            this.fProfilesByName.add(profile);
            Collections.sort(this.fProfilesByName);
            this.fSelected.put(project, newProfile);
            this.fDirty = true;
        }
    }

    @Override
    public boolean deleteProfile(IProfile profile) {
        if (profile instanceof CustomProfile) {
            IProject[] projects;
            CustomProfile oldProfile = (CustomProfile)profile;
            int index = this.fProfilesByName.indexOf(profile);
            this.fProfiles.remove(oldProfile.getID());
            this.fProfilesByName.remove(oldProfile);
            if (index >= this.fProfilesByName.size()) {
                --index;
            }
            IProject[] iProjectArray = projects = this.fSelected.keySet().toArray(new IProject[this.fSelected.size()]);
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject key = iProjectArray[n2];
                if (profile.equals(this.fSelected.get(key))) {
                    this.fSelected.remove(key);
                    break;
                }
                ++n2;
            }
            this.fDirty = true;
            return true;
        }
        return false;
    }

    @Override
    public IProfile rename(IProject project, IProfile profile, String newName) {
        String trimmed = newName.trim();
        if (trimmed.equals(profile.getName())) {
            return profile;
        }
        if (profile.isBuiltInProfile()) {
            CustomProfile newProfile = new CustomProfile(trimmed, profile.getSettings(), profile.getVersion());
            this.addProfile(project, newProfile);
            this.fDirty = true;
            return newProfile;
        }
        CustomProfile cProfile = (CustomProfile)profile;
        String oldID = profile.getID();
        cProfile.fName = trimmed;
        this.fProfiles.remove(oldID);
        this.fProfiles.put(profile.getID(), profile);
        Collections.sort(this.fProfilesByName);
        this.fDirty = true;
        return cProfile;
    }

    @Override
    public IProfile create(IProject project, ProfileKind kind, String profileName, Map<String, String> settings, int version) {
        CustomProfile profile = new CustomProfile(profileName, settings, version);
        if (kind != ProfileKind.TEMPORARY) {
            this.addProfile(project, profile);
        }
        return profile;
    }

    @Override
    public boolean isDirty() {
        return this.fDirty;
    }

    @Override
    public void markDirty() {
        this.fDirty = true;
    }

    @Override
    public void clearDirty() {
        this.fDirty = false;
    }

    @Override
    public IProfileVersioner getProfileVersioner() {
        if (this.versioner == null) {
            this.versioner = this.createProfileVersioner();
        }
        return this.versioner;
    }

    private IProfileVersioner createProfileVersioner() {
        return new GeneralProfileVersioner(APTANA_CODE_FORMATTER_ID);
    }

    @Override
    public String getDefaultProfileID() {
        return DEFAULT_PROFILE_ID;
    }

    @Override
    public String getDefaultProfileName() {
        return FormatterMessages.AbstractScriptFormatterFactory_defaultProfileName;
    }
}

