/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.internal.text.rules;

import com.aptana.editor.common.text.rules.ExtendedWordRule;
import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;

public class CSSImportantRule
extends ExtendedWordRule {
    private Pattern pattern;

    public CSSImportantRule(IToken token) {
        super((IWordDetector)new ImportantWordDetector(), token, true);
    }

    protected boolean wordOK(String word, ICharacterScanner scanner) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile("!\\s*important", 2);
        }
        return this.pattern.matcher(word).matches();
    }

    private static class ImportantWordDetector
    implements IWordDetector {
        private ImportantWordDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '!';
        }

        public boolean isWordPart(char c) {
            return this.isWordStart(c) || Character.isLetterOrDigit(c) || Character.isWhitespace(c);
        }
    }
}

