/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.text;

import com.aptana.core.util.StringUtil;
import com.aptana.css.core.CSSColors;
import com.aptana.css.core.index.CSSIndexQueryHelper;
import com.aptana.css.core.model.BaseElement;
import com.aptana.css.core.model.ICSSMetadataElement;
import com.aptana.css.core.model.PropertyElement;
import com.aptana.css.core.model.PseudoClassElement;
import com.aptana.css.core.model.PseudoElementElement;
import com.aptana.css.core.parsing.ast.CSSAttributeSelectorNode;
import com.aptana.css.core.parsing.ast.CSSDeclarationNode;
import com.aptana.css.core.parsing.ast.CSSFunctionNode;
import com.aptana.css.core.parsing.ast.CSSNode;
import com.aptana.css.core.parsing.ast.CSSTermListNode;
import com.aptana.editor.common.contentassist.CommonTextHover;
import com.aptana.editor.common.hover.CustomBrowserInformationControl;
import com.aptana.editor.css.CSSColorsUI;
import com.aptana.editor.css.internal.text.CSSModelFormatter;
import com.aptana.editor.css.text.Messages;
import com.aptana.parsing.ast.IParseNode;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorPart;

public class CSSTextHover
extends CommonTextHover
implements ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private static final String COLORED_TABLE = "<table style=\"background-color:{0}; width:100%; height:100%;\"><tr><td> </td></tr></table>";
    private static final Pattern RGB_CHANNELS = Pattern.compile("rgb\\(\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*\\)");
    private Object info;

    public String getHeader(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        if (element instanceof RGB) {
            return Messages.CSSTextHover_cssColorHeaderText;
        }
        if (element instanceof ICSSMetadataElement) {
            return CSSModelFormatter.TEXT_HOVER.getHeader((ICSSMetadataElement)element);
        }
        return null;
    }

    public String getDocumentation(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof RGB) {
            return MessageFormat.format(COLORED_TABLE, CSSTextHover.getHexColor((RGB)((RGB)element)));
        }
        if (element instanceof ICSSMetadataElement) {
            return CSSModelFormatter.TEXT_HOVER.getDocumentation((ICSSMetadataElement)element);
        }
        return null;
    }

    public void populateToolbarActions(ToolBarManager tbm, CustomBrowserInformationControl iControl) {
    }

    private RegionInfo getFunctionRegionInfo(CSSFunctionNode node) {
        RegionInfo result = null;
        Matcher m = RGB_CHANNELS.matcher(node.toString());
        if (m.matches()) {
            int red = Integer.parseInt(m.group(1));
            int green = Integer.parseInt(m.group(2));
            int blue = Integer.parseInt(m.group(3));
            result = new RegionInfo((IRegion)new Region(node.getStartingOffset(), node.getLength()), new RGB(red, green, blue));
        }
        return result;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        return this.getHoverInfo(this.info, this.isBrowserControlAvailable(textViewer), null, this.getEditor(), hoverRegion);
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        this.info = null;
        IParseNode node = this.getActiveNode(textViewer, offset);
        if (!(node instanceof CSSNode)) {
            return null;
        }
        RegionInfo ri = null;
        CSSNode cssNode = (CSSNode)node;
        switch (cssNode.getNodeType()) {
            case 12: {
                ri = this.getTermRegionInfo(cssNode);
                break;
            }
            case 4: {
                ri = this.getPropertyNameRegionInfo((CSSDeclarationNode)cssNode, offset);
                break;
            }
            case 2: {
                String functionName;
                BaseElement matching;
                CSSFunctionNode functionNode = (CSSFunctionNode)cssNode;
                ri = this.getFunctionRegionInfo(functionNode);
                if (ri != null || (matching = this.getPsuedoClass(functionName = functionNode.getName())) == null) break;
                ri = new RegionInfo((IRegion)new Region(cssNode.getStartingOffset(), functionName.length()), matching);
                break;
            }
            case 1: {
                ri = this.getPseudoSelector((CSSAttributeSelectorNode)cssNode);
            }
        }
        if (ri != null) {
            this.info = ri.info;
            return ri.region;
        }
        return null;
    }

    private RegionInfo getPropertyNameRegionInfo(CSSDeclarationNode decl, int offset) {
        PropertyElement property;
        String propertyName = decl.getIdentifier();
        int startingOffset = decl.getStartingOffset();
        if (propertyName != null && startingOffset <= offset && offset < startingOffset + propertyName.length() && (property = this.getQueryHelper().getProperty(propertyName)) != null) {
            return new RegionInfo((IRegion)new Region(decl.getStartingOffset(), propertyName.length()), property);
        }
        return null;
    }

    private RegionInfo getTermRegionInfo(CSSNode cssNode) {
        IParseNode parent = this.getOwningStatement(cssNode.getParent());
        if (parent instanceof CSSDeclarationNode) {
            return this.getColorRegionInfo(cssNode);
        }
        if (parent instanceof CSSFunctionNode) {
            return this.getFunctionRegionInfo((CSSFunctionNode)parent);
        }
        return null;
    }

    private RegionInfo getPseudoSelector(CSSAttributeSelectorNode selectorNode) {
        BaseElement matching;
        String rawAttribute = selectorNode.toString();
        if (StringUtil.isEmpty((String)rawAttribute) || rawAttribute.charAt(0) != ':') {
            return null;
        }
        String psuedoSomething = rawAttribute.substring(1);
        boolean isPsuedoElement = false;
        if (!StringUtil.isEmpty((String)psuedoSomething) && psuedoSomething.charAt(0) == ':') {
            psuedoSomething = psuedoSomething.substring(1);
            isPsuedoElement = true;
        }
        if ((matching = this.getPsuedoElement(psuedoSomething)) == null && !isPsuedoElement) {
            matching = this.getPsuedoClass(psuedoSomething);
        }
        if (matching != null) {
            return new RegionInfo((IRegion)new Region(selectorNode.getStartingOffset(), rawAttribute.length()), matching);
        }
        return null;
    }

    private RegionInfo getColorRegionInfo(CSSNode cssNode) {
        if (cssNode == null) {
            return null;
        }
        String text = cssNode.getText();
        if (StringUtil.isEmpty((String)text)) {
            return null;
        }
        Region region = new Region(cssNode.getStartingOffset(), cssNode.getLength());
        if (text.charAt(0) == '#') {
            return new RegionInfo((IRegion)region, CSSColorsUI.hexToRGB(text));
        }
        if (CSSColors.namedColorExists((String)text)) {
            return new RegionInfo((IRegion)region, CSSColorsUI.namedColorToRGB(text));
        }
        return new RegionInfo((IRegion)region, text);
    }

    private IParseNode getOwningStatement(IParseNode parent) {
        if (parent instanceof CSSTermListNode) {
            while (parent instanceof CSSTermListNode) {
                parent = parent.getParent();
            }
        }
        return parent;
    }

    protected BaseElement getPsuedoElement(String psuedoSomething) {
        for (PseudoElementElement pee : this.getQueryHelper().getPseudoElements()) {
            if (!pee.getName().equals(psuedoSomething)) continue;
            return pee;
        }
        return null;
    }

    protected BaseElement getPsuedoClass(String functionName) {
        for (PseudoClassElement pce : this.getQueryHelper().getPseudoClasses()) {
            if (!pce.getName().equals(functionName)) continue;
            return pce;
        }
        return null;
    }

    protected CSSIndexQueryHelper getQueryHelper() {
        return new CSSIndexQueryHelper();
    }

    private static class RegionInfo {
        public final IRegion region;
        public final Object info;

        RegionInfo(IRegion region, Object info) {
            this.region = region;
            this.info = info;
        }
    }
}

