/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.text.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.text.hyperlink.EditorSearchHyperlink;
import com.aptana.editor.common.text.hyperlink.IndexQueryingHyperlinkDetector;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.index.core.Index;
import com.aptana.index.core.QueryResult;
import com.aptana.scope.ScopeSelector;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public class HTMLIDHyperlinkDetector
extends IndexQueryingHyperlinkDetector {
    private static final Pattern HTML_ID = Pattern.compile("#[_a-zA-Z0-9-]+");

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        List results;
        String htmlId;
        Matcher m;
        IRegion lineRegion;
        ArrayList<EditorSearchHyperlink> hyperlinks;
        block12: {
            Index index;
            block11: {
                block10: {
                    IDocument doc;
                    block9: {
                        hyperlinks = new ArrayList<EditorSearchHyperlink>();
                        doc = textViewer.getDocument();
                        String scope = CommonEditorPlugin.getDefault().getDocumentScopeManager().getScopeAtOffset(textViewer, region.getOffset());
                        ScopeSelector selector = new ScopeSelector("source.css");
                        if (selector.matches(scope)) break block9;
                        return null;
                    }
                    lineRegion = doc.getLineInformationOfOffset(region.getOffset());
                    String line = doc.get(lineRegion.getOffset(), lineRegion.getLength());
                    m = HTML_ID.matcher(line);
                    if (m.find()) break block10;
                    return null;
                }
                index = this.getIndex();
                if (index != null) break block11;
                return null;
            }
            htmlId = m.group().substring(1);
            results = index.query(new String[]{"css.identifier"}, htmlId, 8);
            if (results != null && !results.isEmpty()) break block12;
            return null;
        }
        try {
            int start = m.start() + lineRegion.getOffset();
            int length = m.end() - m.start();
            Region linkRegion = new Region(start, length);
            for (QueryResult result : results) {
                Set documents = result.getDocuments();
                if (documents == null || documents.isEmpty()) continue;
                for (String filepath : documents) {
                    hyperlinks.add(new EditorSearchHyperlink((IRegion)linkRegion, htmlId, new URI(filepath)));
                    if (canShowMultipleHyperlinks) continue;
                    return new IHyperlink[]{(IHyperlink)hyperlinks.get(0)};
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
        }
        if (hyperlinks.isEmpty()) {
            return null;
        }
        return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }
}

