/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.textcanvas;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PipedInputStream
extends InputStream {
    protected final OutputStream fOutputStream = new PipedOutputStream();
    private final BoundedByteBuffer fQueue;

    public PipedInputStream(int bufferSize) {
        this.fQueue = new BoundedByteBuffer(bufferSize);
    }

    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAvailable(long millis) throws InterruptedException {
        BoundedByteBuffer boundedByteBuffer = this.fQueue;
        synchronized (boundedByteBuffer) {
            if (this.fQueue.available() == 0) {
                this.fQueue.wait(millis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        BoundedByteBuffer boundedByteBuffer = this.fQueue;
        synchronized (boundedByteBuffer) {
            return this.fQueue.available();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        try {
            BoundedByteBuffer boundedByteBuffer = this.fQueue;
            synchronized (boundedByteBuffer) {
                return this.fQueue.read();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return -1;
        }
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] cbuf, int off, int len) throws IOException {
        int n = 0;
        if (len == 0) {
            return 0;
        }
        try {
            BoundedByteBuffer boundedByteBuffer = this.fQueue;
            synchronized (boundedByteBuffer) {
                if (this.fQueue.available() == 0) {
                    int c = this.fQueue.read();
                    if (c == -1) {
                        return -1;
                    }
                    cbuf[off] = (byte)c;
                    ++n;
                }
                if (n >= len) return n;
                if (this.fQueue.available() <= 0) return n;
                int nn = Math.min(this.fQueue.available(), len - n);
                if (nn == 0 && this.fQueue.isClosed()) {
                    if (n != 0) return n;
                    return -1;
                }
                this.fQueue.read(cbuf, off + n, nn);
                n += nn;
                return n;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return n;
    }

    private class BoundedByteBuffer {
        protected final byte[] fBuffer;
        protected int fPutPos = 0;
        protected int fTakePos = 0;
        protected int fUsedSlots = 0;
        private boolean fClosed;

        public BoundedByteBuffer(int capacity) throws IllegalArgumentException {
            if (capacity <= 0) {
                throw new IllegalArgumentException();
            }
            this.fBuffer = new byte[capacity];
        }

        public int available() {
            return this.fUsedSlots;
        }

        public void write(byte b) throws InterruptedException {
            while (this.fUsedSlots == this.fBuffer.length) {
                this.wait();
            }
            this.fBuffer[this.fPutPos] = b;
            this.fPutPos = (this.fPutPos + 1) % this.fBuffer.length;
            if (this.fUsedSlots++ == 0) {
                this.notifyAll();
            }
        }

        public int getFreeSlots() {
            return this.fBuffer.length - this.fUsedSlots;
        }

        /*
         * Unable to fully structure code
         */
        public void write(byte[] b, int off, int len) throws InterruptedException {
            if (BoundedByteBuffer.$assertionsDisabled || len <= this.getFreeSlots()) ** GOTO lbl4
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                this.wait();
lbl4:
                // 2 sources

                ** while (this.fUsedSlots == this.fBuffer.length)
            }
lbl5:
            // 1 sources

            n = Math.min(len, this.fBuffer.length - this.fPutPos);
            System.arraycopy(b, off, this.fBuffer, this.fPutPos, n);
            if (this.fPutPos + len > this.fBuffer.length) {
                System.arraycopy(b, off + n, this.fBuffer, 0, len - n);
            }
            this.fPutPos = (this.fPutPos + len) % this.fBuffer.length;
            wasEmpty = this.fUsedSlots == 0;
            this.fUsedSlots += len;
            if (wasEmpty) {
                this.notifyAll();
            }
        }

        public int read() throws InterruptedException {
            while (this.fUsedSlots == 0) {
                if (this.fClosed) {
                    return -1;
                }
                this.wait();
            }
            byte b = this.fBuffer[this.fTakePos];
            this.fTakePos = (this.fTakePos + 1) % this.fBuffer.length;
            if (this.fUsedSlots-- == this.fBuffer.length) {
                this.notifyAll();
            }
            return b;
        }

        /*
         * Unable to fully structure code
         */
        public int read(byte[] cbuf, int off, int len) throws InterruptedException {
            if (BoundedByteBuffer.$assertionsDisabled || len <= this.available()) ** GOTO lbl6
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                if (this.fClosed) {
                    return 0;
                }
                this.wait();
lbl6:
                // 2 sources

                ** while (this.fUsedSlots == 0)
            }
lbl7:
            // 1 sources

            n = Math.min(len, this.fBuffer.length - this.fTakePos);
            System.arraycopy(this.fBuffer, this.fTakePos, cbuf, off, n);
            if (this.fTakePos + len > n) {
                System.arraycopy(this.fBuffer, 0, cbuf, off + n, len - n);
            }
            this.fTakePos = (this.fTakePos + len) % this.fBuffer.length;
            wasFull = this.fUsedSlots == this.fBuffer.length;
            this.fUsedSlots -= len;
            if (wasFull) {
                this.notifyAll();
            }
            return len;
        }

        public void close() {
            this.fClosed = true;
            this.notifyAll();
        }

        public boolean isClosed() {
            return this.fClosed;
        }
    }

    class PipedOutputStream
    extends OutputStream {
        PipedOutputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                BoundedByteBuffer boundedByteBuffer = PipedInputStream.this.fQueue;
                synchronized (boundedByteBuffer) {
                    if (PipedInputStream.this.fQueue.isClosed()) {
                        throw new IOException("Stream is closed!");
                    }
                    int written = 0;
                    while (written < len) {
                        if (PipedInputStream.this.fQueue.getFreeSlots() == 0) {
                            PipedInputStream.this.fQueue.write(b[off + written]);
                            ++written;
                            continue;
                        }
                        int n = Math.min(PipedInputStream.this.fQueue.getFreeSlots(), len - written);
                        PipedInputStream.this.fQueue.write(b, off + written, n);
                        written += n;
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) throws IOException {
            try {
                BoundedByteBuffer boundedByteBuffer = PipedInputStream.this.fQueue;
                synchronized (boundedByteBuffer) {
                    if (PipedInputStream.this.fQueue.isClosed()) {
                        throw new IOException("Stream is closed!");
                    }
                    PipedInputStream.this.fQueue.write((byte)b);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            BoundedByteBuffer boundedByteBuffer = PipedInputStream.this.fQueue;
            synchronized (boundedByteBuffer) {
                PipedInputStream.this.fQueue.close();
            }
        }
    }
}

