/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.engineyard;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.PlatformUtil;
import com.aptana.deploy.engineyard.EngineYardPlugin;
import com.aptana.deploy.engineyard.Messages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class EngineYardAPI {
    private static final String ACCEPT_HEADER = "Accept";
    private static final String ACCEPT_CONTENT_TYPES = "application/json";
    private static final String EY_API_TOKEN_HEADER = "X-EY-Cloud-Token";
    private String apiToken = null;

    public static File getCredentialsFile() {
        return new File(PlatformUtil.expandEnvironmentStrings((String)"~/.eyrc"));
    }

    public IStatus authenticateFromCredentials() {
        File file = EngineYardAPI.getCredentialsFile();
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(file));
                reader.readLine();
                String token = reader.readLine();
                this.apiToken = token.split("api_token: ")[1];
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)EngineYardPlugin.getDefault(), (Throwable)e);
                Status status = new Status(4, EngineYardPlugin.getPluginIdentifier(), Messages.EngineYardAPI_CredentialsFile_Invalid);
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                return status;
            }
        }
        catch (Throwable throwable) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        HttpURLConnection connection = null;
        try {
            URL url = new URL("https://cloud.engineyard.com/api/v2/apps");
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty(ACCEPT_HEADER, ACCEPT_CONTENT_TYPES);
            connection.setRequestProperty(EY_API_TOKEN_HEADER, this.apiToken);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            int code = connection.getResponseCode();
            if (code == 200) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (code == 401 || code == 403) {
                Status status = new Status(4, EngineYardPlugin.getPluginIdentifier(), "");
                return status;
            }
            Status status = new Status(4, EngineYardPlugin.getPluginIdentifier(), "");
            return status;
        }
        catch (Exception e) {
            Status status = new Status(4, EngineYardPlugin.getPluginIdentifier(), e.getMessage(), (Throwable)e);
            return status;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private IStatus getAPIToken(String userId, String password) {
        HttpURLConnection connection = null;
        try {
            String line;
            DataOutputStream output = null;
            BufferedReader input = null;
            URL url = new URL("https://cloud.engineyard.com/api/v2/authenticate");
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty(ACCEPT_HEADER, ACCEPT_CONTENT_TYPES);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setDoOutput(true);
            output = new DataOutputStream(connection.getOutputStream());
            String postData = "email=" + userId + "&password=" + password;
            output.writeBytes(postData);
            output.flush();
            input = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuffer sb = new StringBuffer();
            while ((line = input.readLine()) != null) {
                sb.append(line);
            }
            this.apiToken = sb.toString().replace('}', ' ').split(":")[1].replace('\"', ' ').trim();
            int code = connection.getResponseCode();
            if (code == 200) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (code == 401 || code == 403) {
                Status status = new Status(4, EngineYardPlugin.getPluginIdentifier(), "");
                return status;
            }
            Status status = new Status(4, EngineYardPlugin.getPluginIdentifier(), "");
            return status;
        }
        catch (Exception e) {
            Status status = new Status(4, EngineYardPlugin.getPluginIdentifier(), e.getMessage(), (Throwable)e);
            return status;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean writeCredentials(String userId, String password) {
        if (this.getAPIToken(userId, password).isOK()) {
            File credentials = EngineYardAPI.getCredentialsFile();
            BufferedWriter writer = null;
            writer = new BufferedWriter(new FileWriter(credentials));
            writer.write("--- ");
            writer.newLine();
            writer.write("api_token: ");
            writer.write(this.apiToken);
            writer.newLine();
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
            return true;
            catch (IOException e) {
                try {
                    IdeLog.logError((Plugin)EngineYardPlugin.getDefault(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

