/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.engineyard.ui.wizard;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IOUtil;
import com.aptana.deploy.engineyard.EngineYardAPI;
import com.aptana.deploy.engineyard.EngineYardPlugin;
import com.aptana.deploy.engineyard.ui.wizard.EngineYardDeployWizardPage;
import com.aptana.deploy.engineyard.ui.wizard.EngineYardLoginWizardPage;
import com.aptana.deploy.engineyard.ui.wizard.EngineYardSignupPage;
import com.aptana.deploy.engineyard.ui.wizard.Messages;
import com.aptana.deploy.preferences.DeployPreferenceUtil;
import com.aptana.deploy.ui.wizard.AbstractDeployWizard;
import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.BundleEntry;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.CommandElement;
import com.aptana.usage.UsagePlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.browser.BrowserViewer;
import org.eclipse.ui.internal.browser.WebBrowserEditor;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;

public class EngineYardDeployWizard
extends AbstractDeployWizard {
    private static final String EY_IMG_PATH = "icons/ey_small_wizard.png";
    private static final String BUNDLE_ENGINEYARD = "Engine Yard";

    public void addPages() {
        super.addPages();
        EngineYardAPI api = new EngineYardAPI();
        File credentials = EngineYardAPI.getCredentialsFile();
        if (credentials.exists() && api.authenticateFromCredentials().isOK()) {
            this.addPage((IWizardPage)new EngineYardDeployWizardPage());
        } else {
            this.addPage((IWizardPage)new EngineYardLoginWizardPage());
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setDefaultPageImageDescriptor(EngineYardPlugin.getImageDescriptor(EY_IMG_PATH));
    }

    public boolean performFinish() {
        WizardPage page;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        String pageName = currentPage.getName();
        IRunnableWithProgress runnable = null;
        if ("EngineYardSignup".equals(pageName)) {
            page = (EngineYardSignupPage)currentPage;
            runnable = this.createEngineYardSignupRunnable((EngineYardSignupPage)page);
        } else if ("EngineYardDeploy".equals(pageName)) {
            page = (EngineYardDeployWizardPage)currentPage;
            runnable = this.createEngineYardDeployRunnable((EngineYardDeployWizardPage)page);
            DeployPreferenceUtil.setDeployType((IContainer)this.getProject(), (String)"com.aptana.deploy.engineyard.provider");
        }
        if (runnable != null) {
            try {
                this.getContainer().run(true, false, runnable);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)EngineYardPlugin.getDefault(), (Throwable)e);
            }
        }
        return true;
    }

    protected IRunnableWithProgress createEngineYardSignupRunnable(EngineYardSignupPage page) {
        final String userID = page.getUserID();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            private String sendPing(IProgressMonitor monitor) throws IOException {
                block5: {
                    HttpURLConnection connection = null;
                    try {
                        StringBuilder builder = new StringBuilder("http://toolbox.aptana.com");
                        builder.append("/webhook/engineyard?request_id=");
                        builder.append(URLEncoder.encode(UsagePlugin.getApplicationId(), "UTF-8"));
                        builder.append("&email=");
                        builder.append(URLEncoder.encode(userID, "UTF-8"));
                        builder.append("&type=signuphook");
                        builder.append("&version=");
                        builder.append(EclipseUtil.getPluginVersion((String)"com.aptana.core"));
                        URL url = new URL(builder.toString());
                        connection = (HttpURLConnection)url.openConnection();
                        connection.setUseCaches(false);
                        connection.setAllowUserInteraction(false);
                        int responseCode = connection.getResponseCode();
                        if (responseCode != 200) {
                            IdeLog.logError((Plugin)EngineYardPlugin.getDefault(), (String)MessageFormat.format(Messages.DeployWizard_FailureToGrabHerokuSignupJSError, builder.toString()));
                            break block5;
                        }
                        String string = IOUtil.read((InputStream)connection.getInputStream());
                        return string;
                    }
                    finally {
                        if (connection != null) {
                            connection.disconnect();
                        }
                    }
                }
                return "";
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    try {
                        String javascriptToInject = this.sendPing((IProgressMonitor)sub.newChild(40));
                        this.openSignup(javascriptToInject, (IProgressMonitor)sub.newChild(60));
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    sub.done();
                }
            }

            private void openSignup(final String javascript, IProgressMonitor monitor) throws Exception {
                final URL url = new URL("http://cloud.engineyard.com/ev?code=APTANA_REFERRAL");
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EngineYardDeployWizard.this.openSignupURLinEclipseBrowser(url, 14, "Engine-Yard-signup", javascript);
                    }
                });
            }
        };
        return runnable;
    }

    protected IRunnableWithProgress createEngineYardDeployRunnable(EngineYardDeployWizardPage page) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CommandElement command = EngineYardDeployWizard.this.getCommand(EngineYardDeployWizard.BUNDLE_ENGINEYARD, "Deploy App");
                        command.execute();
                    }
                });
            }
        };
        return runnable;
    }

    private CommandElement getCommand(String bundleName, String commandName) {
        BundleEntry entry = BundleManager.getInstance().getBundleEntry(bundleName);
        if (entry == null) {
            return null;
        }
        for (BundleElement bundle : entry.getContributingBundles()) {
            CommandElement command = bundle.getCommandByName(commandName);
            if (command == null) continue;
            return command;
        }
        return null;
    }

    private void openSignupURLinEclipseBrowser(URL url, int style, String browserId, final String javascript) {
        try {
            WebBrowserEditorInput input = new WebBrowserEditorInput(url, style, browserId);
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart editorPart = page.openEditor((IEditorInput)input, "org.eclipse.ui.browser.editor");
            WebBrowserEditor webBrowserEditor = (WebBrowserEditor)editorPart;
            Field f = WebBrowserEditor.class.getDeclaredField("webBrowser");
            f.setAccessible(true);
            BrowserViewer viewer = (BrowserViewer)f.get(webBrowserEditor);
            final Browser browser = viewer.getBrowser();
            browser.addProgressListener(new ProgressListener(){

                public void completed(ProgressEvent event) {
                    browser.removeProgressListener((ProgressListener)this);
                    browser.execute(javascript);
                }

                public void changed(ProgressEvent event) {
                }
            });
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)EngineYardPlugin.getDefault(), (Throwable)e);
        }
    }
}

