/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml.formatter;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.xml.XMLPlugin;
import com.aptana.editor.xml.XMLSourceConfiguration;
import com.aptana.editor.xml.XMLSourceViewerConfiguration;
import com.aptana.editor.xml.formatter.XMLFormatter;
import com.aptana.editor.xml.formatter.XMLFormatterPlugin;
import com.aptana.editor.xml.formatter.preferences.XMLFormatterModifyDialog;
import com.aptana.formatter.AbstractScriptFormatterFactory;
import com.aptana.formatter.IScriptFormatter;
import com.aptana.formatter.IScriptFormatterFactory;
import com.aptana.formatter.preferences.PreferenceKey;
import com.aptana.formatter.ui.IFormatterModifyDialog;
import com.aptana.formatter.ui.IFormatterModifyDialogOwner;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLFormatterFactory
extends AbstractScriptFormatterFactory {
    private static final PreferenceKey FORMATTER_PREF_KEY = new PreferenceKey("com.aptana.editor.xml.formatter", "xml.formatter");
    private static final String FORMATTER_PREVIEW_FILE = "formatterPreview.xml";
    private static final String[] KEYS = new String[]{"xml.formatter.formatter.indentation.size", "xml.formatter.formatter.tabulation.char", "xml.formatter.formatter.tabulation.size", "xml.formatter.wrap.comments", "xml.formatter.wrap.comments.length", "xml.formatter.indent.excluded", "xml.formatter.newline.excluded", "xml.formatter.newline.excluded.on.text.nodes", "xml.formatter.line.after.element", "xml.formatter.line.after.non.xml", "xml.formatter.line.before.non.xml", "xml.formatter.line.preserve", "xml.formatter.formatter.on.off.enabled", "xml.formatter.formatter.on", "xml.formatter.formatter.off"};

    public PreferenceKey[] getPreferenceKeys() {
        PreferenceKey[] result = new PreferenceKey[KEYS.length];
        int i = 0;
        while (i < KEYS.length) {
            String key = KEYS[i];
            result[i] = new PreferenceKey("com.aptana.editor.xml.formatter", key);
            ++i;
        }
        return result;
    }

    public IScriptFormatter createFormatter(String lineSeparator, Map<String, String> preferences) {
        return new XMLFormatter(lineSeparator, preferences, this.getMainContentType());
    }

    public URL getPreviewContent() {
        return ((Object)((Object)this)).getClass().getResource(FORMATTER_PREVIEW_FILE);
    }

    public IFormatterModifyDialog createDialog(IFormatterModifyDialogOwner dialogOwner) {
        return new XMLFormatterModifyDialog(dialogOwner, (IScriptFormatterFactory)this);
    }

    public SourceViewerConfiguration createSimpleSourceViewerConfiguration(ISharedTextColors colorManager, IPreferenceStore preferenceStore, ITextEditor editor, boolean configureFormatter) {
        return new XMLSourceViewerConfiguration(preferenceStore, (AbstractThemeableEditor)editor);
    }

    public PreferenceKey getFormatterPreferenceKey() {
        return FORMATTER_PREF_KEY;
    }

    public IPreferenceStore getPreferenceStore() {
        return XMLFormatterPlugin.getDefault().getPreferenceStore();
    }

    public Object getPartitioningConfiguration() {
        return XMLSourceConfiguration.getDefault();
    }

    protected IEclipsePreferences getEclipsePreferences() {
        return InstanceScope.INSTANCE.getNode("com.aptana.editor.xml");
    }

    protected String getFormatterTabPolicy(Map<String, String> preferences) {
        return preferences.get("xml.formatter.formatter.tabulation.char");
    }

    protected int getEditorTabSize() {
        return EditorUtil.getSpaceIndentSize((String)XMLPlugin.getDefault().getBundle().getSymbolicName());
    }

    protected int getDefaultEditorTabSize() {
        return EditorUtil.getDefaultSpaceIndentSize((String)XMLPlugin.getDefault().getBundle().getSymbolicName());
    }

    protected String getFormatterTabSizeKey() {
        return "xml.formatter.formatter.tabulation.size";
    }
}

