/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml.formatter.preferences;

import com.aptana.editor.xml.XMLPlugin;
import com.aptana.editor.xml.formatter.preferences.Messages;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.formatter.ui.IFormatterControlManager;
import com.aptana.formatter.ui.IFormatterModifyDialog;
import com.aptana.formatter.ui.preferences.FormatterModifyTabPage;
import com.aptana.formatter.ui.util.SWTFactory;
import java.net.URL;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class XMLFormatterIndentationPage
extends FormatterModifyTabPage {
    private static final String INDENTATION_PREVIEW_FILE = "preview.xml";
    private final String[] tabOptionItems = new String[]{"space", "tab", "mixed", "editor"};
    private final String[] tabOptionNames = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_MIXED, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_EDITOR};

    public XMLFormatterIndentationPage(IFormatterModifyDialog dialog) {
        super(dialog);
    }

    protected void createOptions(IFormatterControlManager manager, Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)Messages.XMLFormatterIndentationPage_generalGroupLabel, (int)2, (int)1, (int)768);
        final Combo tabOptions = manager.createCombo((Composite)group, (Object)"xml.formatter.formatter.tabulation.char", FormatterMessages.IndentationTabPage_general_group_option_tab_policy, this.tabOptionItems, this.tabOptionNames);
        final Text indentationSize = manager.createNumber((Composite)group, "xml.formatter.formatter.indentation.size", FormatterMessages.IndentationTabPage_general_group_option_indent_size, 1);
        final Text tabSize = manager.createNumber((Composite)group, "xml.formatter.formatter.tabulation.size", FormatterMessages.IndentationTabPage_general_group_option_tab_size, 1);
        tabSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean tabMode;
                int index = tabOptions.getSelectionIndex();
                if (index >= 0 && (tabMode = "tab".equals(XMLFormatterIndentationPage.this.tabOptionItems[index]))) {
                    indentationSize.setText(tabSize.getText());
                }
            }
        });
        new TabOptionHandler(manager, tabOptions, indentationSize, tabSize);
        group = SWTFactory.createGroup((Composite)parent, (String)Messages.XMLFormatterIndentationPage_exclusionsLabel, (int)1, (int)1, (int)1808);
        Label exclutionLabel = new Label((Composite)group, 64);
        exclutionLabel.setText(Messages.XMLFormatterIndentationPage_exclusionsMessageLabel);
        manager.createManagedList(group, (Object)"xml.formatter.indent.excluded");
    }

    protected URL getPreviewContent() {
        return ((Object)((Object)this)).getClass().getResource(INDENTATION_PREVIEW_FILE);
    }

    private class TabOptionHandler
    extends SelectionAdapter
    implements IFormatterControlManager.IInitializeListener {
        private IFormatterControlManager manager;
        private Combo tabOptions;
        private Text indentationSize;
        private final Text tabSize;

        public TabOptionHandler(IFormatterControlManager controlManager, Combo tabOptions, Text indentationSize, Text tabSize) {
            this.manager = controlManager;
            this.tabOptions = tabOptions;
            this.indentationSize = indentationSize;
            this.tabSize = tabSize;
            tabOptions.addSelectionListener((SelectionListener)this);
            this.manager.addInitializeListener((IFormatterControlManager.IInitializeListener)this);
        }

        public void widgetSelected(SelectionEvent e) {
            int index = this.tabOptions.getSelectionIndex();
            if (index >= 0) {
                boolean tabMode = "tab".equals(XMLFormatterIndentationPage.this.tabOptionItems[index]);
                boolean editorSettingsMode = "editor".equals(XMLFormatterIndentationPage.this.tabOptionItems[index]);
                this.manager.enableControl((Control)this.indentationSize, !tabMode && !editorSettingsMode);
                this.manager.enableControl((Control)this.tabSize, !editorSettingsMode);
                if (editorSettingsMode) {
                    XMLFormatterIndentationPage.this.setEditorTabWidth(XMLPlugin.getDefault().getBundle().getSymbolicName(), new Text[]{this.tabSize, this.indentationSize});
                }
            }
        }

        public void initialize() {
            boolean tabMode = "tab".equals(this.manager.getString((Object)"xml.formatter.formatter.tabulation.char"));
            boolean editorSettingsMode = "editor".equals(this.manager.getString((Object)"xml.formatter.formatter.tabulation.char"));
            this.manager.enableControl((Control)this.indentationSize, !tabMode && !editorSettingsMode);
            this.manager.enableControl((Control)this.tabSize, !editorSettingsMode);
            if (editorSettingsMode) {
                XMLFormatterIndentationPage.this.setEditorTabWidth(XMLPlugin.getDefault().getBundle().getSymbolicName(), new Text[]{this.tabSize, this.indentationSize});
            }
        }
    }
}

