/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.w3c.css.css.StyleReport;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.error.ErrorReportHTML;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssErrorToken;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.Errors;
import org.w3c.css.properties.PropertiesLoader;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Messages;
import org.w3c.css.util.Utf8Properties;
import org.w3c.css.util.Warnings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleSheetGenerator
extends StyleReport {
    private PrintWriter out;
    private Template template;
    private String template_file;
    private String default_lang = "en";
    private ApplContext ac;
    private StyleSheet style;
    private String title;
    private VelocityContext context;
    private Warnings warnings;
    private Errors errors;
    private Vector items;
    private static Utf8Properties availableFormat;
    private static Utf8Properties availablePropertiesURL;

    public StyleSheetGenerator(String title, StyleSheet style, String document, int warningLevel) {
        this(null, title, style, document, warningLevel);
    }

    public StyleSheetGenerator(ApplContext ac, String title, StyleSheet style, String document, int warningLevel) {
        String k;
        Iterator<Object> it;
        this.ac = ac;
        this.style = style;
        this.title = title;
        this.template_file = availableFormat.getProperty(document);
        this.context = new VelocityContext();
        this.context.put("file_title", (Object)title);
        this.warnings = style.getWarnings();
        this.errors = style.getErrors();
        this.items = style.newGetRules();
        ApplContext ac_default = new ApplContext(this.default_lang);
        if (ac.getLang() == null || ac.getLang().equals(this.default_lang)) {
            it = ac_default.getMsg().properties.keySet().iterator();
            while (it.hasNext()) {
                k = String.valueOf(it.next());
                this.context.put(k, (Object)ac.getMsg().getString(k));
            }
        } else {
            it = ac_default.getMsg().properties.keySet().iterator();
            while (it.hasNext()) {
                k = String.valueOf(it.next());
                if (ac.getMsg().getString(k) == null) {
                    this.context.put(k, (Object)ac_default.getMsg().getString(k));
                    continue;
                }
                this.context.put(k, (Object)ac.getMsg().getString(k));
            }
        }
        if (ac.getLink() != null) {
            HashMap[] languages = new HashMap[Messages.languages_name.size()];
            for (int i = 0; i < Messages.languages_name.size(); ++i) {
                String name = String.valueOf(Messages.languages_name.get(i));
                HashMap<String, String> l = new HashMap<String, String>();
                l.put("name", name);
                l.put("real", ((Utf8Properties)Messages.languages.get(name)).getProperty("language_name"));
                languages[i] = l;
            }
            this.context.put("languages", (Object)languages);
            String link = ac.getLink().replaceAll("&lang=.*&", "&");
            link = link.replaceAll("&lang=.*$", "");
            this.context.put("link", (Object)("?" + link.replaceAll("&", "&amp;")));
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.context.put("currentdate", (Object)formatter.format(new Date()));
        this.context.put("lang", (Object)ac.getContentLanguage());
        this.context.put("errors_count", (Object)new Integer(this.errors.getErrorCount()));
        this.context.put("warnings_count", (Object)new Integer(this.warnings.getWarningCount()));
        this.context.put("ignored-warnings_count", (Object)new Integer(this.warnings.getIgnoredWarningCount()));
        this.context.put("warning_level", (Object)new Integer(warningLevel));
        this.context.put("rules_count", (Object)new Integer(this.items.size()));
        this.context.put("no_errors_report", (Object)new Boolean(false));
        this.context.put("charset", (Object)ac.getContentEncoding());
        this.context.put("cssversion", (Object)ac.getCssVersion());
        this.context.put("css_profile", (Object)ac.getProfile());
        this.context.put("css", (Object)ac.getMsg().getString(ac.getCssVersion()));
        this.context.put("css_link", (Object)StyleSheetGenerator.getURLProperty("@url-base_" + ac.getCssVersion()));
        this.context.put("is_valid", (Object)(this.errors.getErrorCount() == 0 ? "true" : "false"));
        this.context.put("author", (Object)"www-validator-css");
        this.context.put("author-email", (Object)"Email.html");
        if (style.charset != null) {
            this.context.put("style_charset", (Object)style.charset);
        }
        this.produceError();
        this.produceWarning();
        this.produceStyleSheet();
        try {
            this.template = Velocity.getTemplate((String)("org/w3c/css/css/" + this.template_file));
        }
        catch (ResourceNotFoundException rnfe) {
            System.err.println(rnfe.getMessage());
            rnfe.printStackTrace();
        }
        catch (ParseErrorException pee) {
            System.err.println(pee.getMessage());
            pee.printStackTrace();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private static final String getURLProperty(String name) {
        return availablePropertiesURL.getProperty(name);
    }

    public static final void printAvailableFormat(PrintWriter out) {
        Enumeration<?> e = availableFormat.propertyNames();
        out.println(" -- listing available output format --");
        while (e.hasMoreElements()) {
            String key = ((String)e.nextElement()).toLowerCase();
            out.println("Format : " + key);
            out.println("   File : " + StyleSheetGenerator.getDocumentName(key));
        }
        out.flush();
    }

    public static boolean isAvailableFormat(String document) {
        return availableFormat.containsKey(document);
    }

    private static final String getDocumentName(String documentName) {
        String document = availableFormat.getProperty(documentName.toLowerCase());
        if (document == null) {
            System.err.println("Unable to find " + documentName.toLowerCase() + " output format");
            return documentName;
        }
        return document;
    }

    private void produceStyleSheet() {
        this.context.put("at_rules_list", (Object)this.style.newGetRules());
    }

    private void produceError() {
        Hashtable[] errors_content = new Hashtable[this.errors.getErrorCount()];
        try {
            if (this.errors.getErrorCount() != 0) {
                for (CssError csserror : this.errors.getErrors()) {
                    Hashtable<String, Object> h;
                    Throwable ex = csserror.getException();
                    errors_content[i] = h = new Hashtable<String, Object>();
                    h.put("Error", csserror);
                    h.put("CtxName", "nocontext");
                    h.put("CtxMsg", "");
                    h.put("ErrorMsg", ex.getMessage() == null ? "" : ex.getMessage());
                    h.put("ClassName", "unkownerror");
                    if (ex instanceof FileNotFoundException) {
                        h.put("ClassName", "notfound");
                        h.put("ErrorMsg", this.ac.getMsg().getGeneratorString("not-found") + ": " + ex.getMessage());
                        continue;
                    }
                    if (ex instanceof CssParseException) {
                        this.produceParseException((CssParseException)ex, h);
                        continue;
                    }
                    if (ex instanceof InvalidParamException) {
                        h.put("ClassName", "invalidparam");
                        continue;
                    }
                    if (ex instanceof IOException) {
                        String stringError = ex.toString();
                        h.put("CtxMsg", stringError);
                        h.put("ClassName", "io");
                        continue;
                    }
                    if (csserror instanceof CssErrorToken) {
                        CssErrorToken terror = (CssErrorToken)csserror;
                        h.put("ClassName", "errortoken");
                        h.put("ErrorMsg", terror.getErrorDescription() + " : " + terror.getSkippedString());
                        continue;
                    }
                    h.put("ClassName", "unkownerror");
                    h.put("ErrorMsg", this.ac.getMsg().getErrorString("unknown") + " " + ex);
                    if (!(ex instanceof NullPointerException)) continue;
                    ex.printStackTrace();
                }
            }
            this.context.put("errors_content", (Object)errors_content);
        }
        catch (Exception e) {
            this.context.put("errors_content", (Object)errors_content);
            this.context.put("request", (Object)this.ac.getMsg().getGeneratorString("request"));
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void produceWarning() {
        try {
            if (this.warnings.getWarningCount() != 0) {
                this.warnings.sort();
                this.context.put("warnings_list", (Object)this.warnings.getWarnings());
            }
        }
        catch (Exception e) {
            this.out.println(this.ac.getMsg().getGeneratorString("request"));
            e.printStackTrace();
        }
    }

    private void produceParseException(CssParseException error, Hashtable<String, Object> ht_error) {
        String ret;
        if (error.getContexts() != null && error.getContexts().size() != 0) {
            ht_error.put("CtxName", "codeContext");
            StringBuffer buf = new StringBuffer();
            Enumeration e = error.getContexts().elements();
            while (e.hasMoreElements()) {
                Object t = e.nextElement();
                if (t == null) continue;
                buf.append(t);
                if (!e.hasMoreElements()) continue;
                buf.append(", ");
            }
            if (buf.length() != 0) {
                ht_error.put("CtxMsg", String.valueOf(buf));
            }
        } else {
            ht_error.put("CtxName", "nocontext");
        }
        ht_error.put("ClassName", "parse-error");
        String name = error.getProperty();
        if (name != null && StyleSheetGenerator.getURLProperty(name) != null && PropertiesLoader.getProfile(this.ac.getCssVersion()).containsKey(name)) {
            ht_error.put("link_before_parse_error", this.ac.getMsg().getGeneratorString("property"));
            String lnk = this.ac.getCssVersion().equals("css3") ? StyleSheetGenerator.getURLProperty("@url-base_css2.1") : (this.ac.getCssVersion().equals("css1") ? StyleSheetGenerator.getURLProperty("@url-base_css2") : this.context.get("css_link").toString());
            ht_error.put("link_value_parse_error", lnk + StyleSheetGenerator.getURLProperty(name));
            ht_error.put("link_name_parse_error", name);
        }
        if (error.getException() != null && error.getMessage() != null) {
            Exception ex;
            ret = error.isParseException() ? this.queryReplace(error.getMessage()) : ((ex = error.getException()) instanceof NumberFormatException ? this.ac.getMsg().getGeneratorString("invalid-number") : this.queryReplace(ex.getMessage()));
            if (error.getSkippedString() != null) {
                ht_error.put("span_class_parse_error", "skippedString");
                ht_error.put("span_value_parse_error", this.queryReplace(error.getSkippedString()));
            } else if (error.getExp() != null) {
                ret = ret + " : " + this.queryReplace(error.getExp().toStringFromStart());
                ht_error.put("span_class_parse_error", "exp");
                ht_error.put("span_value_parse_error", this.queryReplace(error.getExp().toString()));
            }
        } else {
            ret = this.ac.getMsg().getGeneratorString("unrecognize");
            ht_error.put("span_class_parse_error", "unrecognized");
            ht_error.put("span_value_parse_error", this.queryReplace(error.getSkippedString()));
        }
        ht_error.put("ErrorMsg", ret);
    }

    private String queryReplace(String s) {
        if (s != null) {
            int len = s.length();
            StringBuilder ret = new StringBuilder(len + 16);
            block7: for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '&': {
                        ret.append("&amp;");
                        continue block7;
                    }
                    case '\'': {
                        ret.append("&#39;");
                        continue block7;
                    }
                    case '\"': {
                        ret.append("&quot;");
                        continue block7;
                    }
                    case '<': {
                        ret.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        ret.append("&gt;");
                        continue block7;
                    }
                    default: {
                        ret.append(c);
                    }
                }
            }
            return ret.toString();
        }
        return "[empty string]";
    }

    @Override
    public void print(PrintWriter out) {
        this.out = out;
        try {
            this.template.merge((Context)this.context, (Writer)out);
        }
        catch (Exception e) {
            new ErrorReportHTML(this.ac, this.title, "", e).print(out);
        }
        out.flush();
    }

    @Override
    public void desactivateError() {
        this.context.put("no_errors_report", (Object)new Boolean(true));
    }

    static {
        InputStream f;
        availableFormat = new Utf8Properties();
        try {
            f = StyleSheetGenerator.class.getResourceAsStream("format.properties");
            availableFormat.load(f);
            f.close();
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.css.StyleSheetGeneratorHTML: couldn't load format properties ");
            System.err.println("  " + e.toString());
        }
        availablePropertiesURL = new Utf8Properties();
        try {
            f = StyleSheetGenerator.class.getResourceAsStream("urls.properties");
            availablePropertiesURL.load(f);
            f.close();
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.css.StyleSheetGeneratorHTML: couldn't load URLs properties ");
            System.err.println("  " + e.toString());
        }
        try {
            Velocity.setProperty((String)"resource.loader", (Object)"file");
            Velocity.addProperty((String)"resource.loader", (Object)"jar");
            Velocity.setProperty((String)"jar.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.JarResourceLoader");
            URL path = StyleSheetGenerator.class.getResource("/");
            if (path != null) {
                Velocity.addProperty((String)"file.resource.loader.path", (Object)path.getFile());
                Velocity.setProperty((String)"jar.resource.loader.path", (Object)("jar:" + path + "css-validator.jar"));
            }
            Velocity.init();
        }
        catch (Exception e) {
            System.err.println("Failed to initialize Velocity. Validator might not work as expected.");
        }
    }
}

