/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.parser;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.velocity.io.UnicodeInputStream;
import org.w3c.css.parser.AtRule;
import org.w3c.css.parser.AtRuleMedia;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.CssPropertyFactory;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssValidatorListener;
import org.w3c.css.parser.Errors;
import org.w3c.css.parser.Frame;
import org.w3c.css.parser.analyzer.CssParser;
import org.w3c.css.parser.analyzer.CssParserTokenManager;
import org.w3c.css.parser.analyzer.ParseException;
import org.w3c.css.parser.analyzer.TokenMgrError;
import org.w3c.css.properties.PropertiesLoader;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.HTTPURL;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CssFouffa
extends CssParser {
    CssPropertyFactory properties = null;
    Vector<CssValidatorListener> listeners;
    Errors errors;
    int origin;
    Vector<String> visited = null;

    public CssFouffa(ApplContext ac, InputStream input, URL file, int beginLine) throws IOException {
        super((InputStream)new UnicodeInputStream(input));
        String classStyle;
        String profile;
        if (ac.getOrigin() == -1) {
            this.setOrigin(3);
        } else {
            this.setOrigin(ac.getOrigin());
        }
        ac.setFrame(new Frame(this, file.toString(), beginLine, ac.getWarningLevel()));
        this.setApplContext(ac);
        this.setURL(file);
        if (Util.onDebug) {
            System.err.println("[DEBUG] CSS version " + ac.getCssVersion() + " medium " + ac.getMedium() + " at-rule " + this.getAtRule() + " profile " + ac.getProfile());
        }
        if ((profile = ac.getProfile()) == null || profile.equals("") || profile.equals("none")) {
            profile = ac.getCssVersion();
        }
        if ((classStyle = PropertiesLoader.config.getProperty(profile)) == null) {
            classStyle = PropertiesLoader.config.getProperty("css2");
        }
        try {
            Class<?> style = Class.forName(classStyle);
            ac.setCssSelectorsStyle(style);
        }
        catch (ClassNotFoundException e) {
            System.err.println("org.w3c.css.parser.CssFouffa: couldn't load the style");
            e.printStackTrace();
        }
        this.properties = new CssPropertyFactory(profile);
        this.listeners = new Vector();
    }

    public CssFouffa(ApplContext ac, InputStream input, URL file) throws IOException {
        this(ac, input, file, 0);
    }

    public CssFouffa(ApplContext ac, URL file) throws IOException {
        this(ac, HTTPURL.getConnection(file, ac));
    }

    private CssFouffa(ApplContext ac, URLConnection uco) throws IOException {
        this(ac, HTTPURL.getInputStream(uco), uco.getURL(), 0);
        String httpCL = uco.getHeaderField("Content-Location");
        if (httpCL != null) {
            this.setURL(HTTPURL.getURL(this.getURL(), httpCL));
        }
    }

    private CssFouffa(ApplContext ac, InputStream in, URL url, Vector<CssValidatorListener> listeners, Vector<String> urlvisited, CssPropertyFactory cssfactory, boolean mode) throws IOException {
        this(ac, in, url, 0);
        this.visited = urlvisited;
        this.setURL(url);
        ac.setFrame(new Frame(this, url.toString(), ac.getWarningLevel()));
        this.setApplContext(ac);
        this.listeners = listeners;
        this.properties = cssfactory;
        this.mode = mode;
    }

    private void ReInit(ApplContext ac, InputStream input, URL file, Frame frame) {
        String classStyle;
        String profile;
        super.ReInitWithAc(input, ac);
        this.setURL(file);
        if (Util.onDebug) {
            System.err.println("[DEBUG] CSS version " + ac.getCssVersion() + " medium " + ac.getMedium() + " profile " + ac.getProfile());
        }
        if ((profile = ac.getProfile()) == null || profile.equals("") || profile.equals("none")) {
            profile = ac.getCssVersion();
        }
        if ((classStyle = PropertiesLoader.config.getProperty(profile)) == null) {
            classStyle = PropertiesLoader.config.getProperty("css2");
        }
        try {
            Class<?> style = Class.forName(classStyle);
            ac.setCssSelectorsStyle(style);
        }
        catch (ClassNotFoundException e) {
            System.err.println("org.w3c.css.parser.CssFouffa: couldn't load the style");
            e.printStackTrace();
        }
        this.properties = new CssPropertyFactory(profile);
    }

    public void ReInit(ApplContext ac, InputStream input, URL file, int beginLine) throws IOException {
        Frame f = new Frame(this, file.toString(), beginLine, ac.getWarningLevel());
        ac.setFrame(f);
        this.ReInit(ac, input, file, f);
    }

    public void ReInit(ApplContext ac, InputStream input, URL file) throws IOException {
        Frame f = new Frame(this, file.toString(), ac.getWarningLevel());
        ac.setFrame(f);
        this.ReInit(ac, input, file, f);
    }

    public void ReInit(ApplContext ac, URL file) throws IOException {
        Frame f = new Frame(this, file.toString(), ac.getWarningLevel());
        ac.setFrame(f);
        URLConnection urlC = HTTPURL.getConnection(file, ac);
        this.ReInit(ac, urlC.getInputStream(), urlC.getURL(), f);
    }

    private final void setOrigin(int origin) {
        this.origin = origin;
    }

    public final int getOrigin() {
        return this.origin;
    }

    public final void addListener(CssValidatorListener listener) {
        this.listeners.addElement(listener);
    }

    public final void removeListener(CssValidatorListener listener) {
        this.listeners.removeElement(listener);
    }

    public void parseStyle() {
        try {
            this.parserUnit();
        }
        catch (TokenMgrError e) {
            throw e;
        }
        catch (Throwable e) {
            if (Util.onDebug) {
                e.printStackTrace();
            }
            RuntimeException ne = new RuntimeException(e.getMessage());
            ne.fillInStackTrace();
            throw ne;
        }
        Enumeration<CssValidatorListener> e = this.listeners.elements();
        while (e.hasMoreElements()) {
            CssValidatorListener listener = e.nextElement();
            listener.notifyErrors(this.ac.getFrame().getErrors());
            listener.notifyWarnings(this.ac.getFrame().getWarnings());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleImport(URL url, String file, AtRuleMedia media) {
        block17: {
            if (url.getProtocol().equals("file")) {
                this.ac.getFrame().addWarning("unsupported-import");
                return;
            }
            try {
                URL importedURL = HTTPURL.getURL(url, file);
                String surl = importedURL.toString();
                if (this.visited == null) {
                    this.visited = new Vector(2);
                } else {
                    if (this.visited.contains(surl)) {
                        CssError cerr = new CssError(new Exception("Import loop detected in " + surl));
                        this.ac.getFrame().addError(cerr);
                        return;
                    }
                    if (this.visited.size() > 42) {
                        CssError cerr = new CssError(new Exception("Maximum number of imports reached"));
                        this.ac.getFrame().addError(cerr);
                        return;
                    }
                }
                Vector<String> newVisited = new Vector<String>(this.visited);
                newVisited.addElement(surl);
                if (Util.importSecurity) {
                    throw new FileNotFoundException("[SECURITY] You can't import URL sorry.");
                }
                URLConnection importURL = HTTPURL.getConnection(importedURL, this.ac);
                if (importURL instanceof HttpURLConnection) {
                    String mtype;
                    HttpURLConnection httpURL = (HttpURLConnection)importURL;
                    String httpCL = httpURL.getHeaderField("Content-Location");
                    if (httpCL != null) {
                        importedURL = HTTPURL.getURL(importedURL, httpCL);
                    }
                    if ((mtype = httpURL.getContentType()) == null) {
                        throw new FileNotFoundException(importURL.getURL() + "No Media Type defined");
                    }
                    if (mtype.toLowerCase().indexOf("text/html") != -1) {
                        throw new FileNotFoundException(importURL.getURL() + ": You can't import" + " an HTML document");
                    }
                }
                Frame f = this.ac.getFrame();
                try {
                    CssFouffa cssFouffa = new CssFouffa(this.ac, importURL.getInputStream(), importedURL, this.listeners, newVisited, this.properties, this.mode);
                    cssFouffa.setOrigin(this.getOrigin());
                    if (!media.isEmpty()) {
                        cssFouffa.setAtRule(media);
                    } else {
                        cssFouffa.setAtRule(this.getAtRule());
                    }
                    cssFouffa.parseStyle();
                }
                finally {
                    this.ac.setFrame(f);
                }
            }
            catch (Exception e) {
                if (Util.noErrorTrace) break block17;
                this.ac.getFrame().addError(new CssError(e));
            }
        }
    }

    @Override
    public void handleAtRule(String ident, String string) {
        if (this.mode) {
            Enumeration<CssValidatorListener> e = this.listeners.elements();
            while (e.hasMoreElements()) {
                CssValidatorListener listener = e.nextElement();
                listener.handleAtRule(this.ac, ident, string);
            }
        } else if (!Util.noErrorTrace) {
            ParseException error = new ParseException("at-rules are not implemented in CSS1");
            this.ac.getFrame().addError(new CssError(error));
        }
    }

    @Override
    public CssProperty handleDeclaration(String property, CssExpression expression, boolean important) throws InvalidParamException {
        CssProperty prop;
        if (Util.onDebug) {
            System.err.println("Creating " + property + ": " + expression);
        }
        try {
            prop = this.getMediaDeclaration().equals("on") && this.getAtRule() instanceof AtRuleMedia ? this.properties.createMediaFeature(this.ac, this.getAtRule(), property, expression) : this.properties.createProperty(this.ac, this.getAtRule(), property, expression);
        }
        catch (InvalidParamException e) {
            throw e;
        }
        catch (Exception e) {
            if (Util.onDebug) {
                e.printStackTrace();
            }
            throw new InvalidParamException(e.toString(), this.ac);
        }
        if (important) {
            prop.setImportant();
        }
        prop.setOrigin(this.origin);
        prop.setInfo(this.ac.getFrame().getLine(), this.ac.getFrame().getSourceFile());
        return prop;
    }

    public void parseDeclarations(CssSelectors context) {
        block5: {
            try {
                Vector<CssProperty> properties = this.declarations();
                if (properties != null && properties.size() != 0) {
                    this.handleRule(context, properties);
                }
            }
            catch (ParseException e) {
                if (Util.noErrorTrace) break block5;
                CssParseException ex = new CssParseException(e);
                ex.skippedString = "";
                ex.property = this.currentProperty;
                ex.contexts = this.currentContext;
                CssError error = new CssError(this.getSourceFile(), this.getLine(), ex);
                this.ac.getFrame().addError(error);
            }
        }
        if (!Util.noErrorTrace) {
            Enumeration<CssValidatorListener> e = this.listeners.elements();
            while (e.hasMoreElements()) {
                CssValidatorListener listener = e.nextElement();
                listener.notifyErrors(this.ac.getFrame().getErrors());
                listener.notifyWarnings(this.ac.getFrame().getWarnings());
            }
        }
    }

    @Override
    public void newAtRule(AtRule atRule) {
        Enumeration<CssValidatorListener> e = this.listeners.elements();
        while (e.hasMoreElements()) {
            e.nextElement().newAtRule(atRule);
        }
    }

    @Override
    public void addCharSet(String charset) {
        Enumeration<CssValidatorListener> e = this.listeners.elements();
        while (e.hasMoreElements()) {
            e.nextElement().addCharSet(charset);
        }
    }

    @Override
    public void endOfAtRule() {
        Enumeration<CssValidatorListener> e = this.listeners.elements();
        while (e.hasMoreElements()) {
            e.nextElement().endOfAtRule();
        }
    }

    @Override
    public void setImportant(boolean important) {
        Enumeration<CssValidatorListener> e = this.listeners.elements();
        while (e.hasMoreElements()) {
            e.nextElement().setImportant(important);
        }
    }

    @Override
    public void setSelectorList(Vector selectors) {
        Enumeration<CssValidatorListener> e = this.listeners.elements();
        while (e.hasMoreElements()) {
            e.nextElement().setSelectorList(selectors);
        }
    }

    @Override
    public void addProperty(Vector properties) {
        Enumeration<CssValidatorListener> e = this.listeners.elements();
        while (e.hasMoreElements()) {
            e.nextElement().setProperty(properties);
        }
    }

    @Override
    public void endOfRule() {
        Enumeration<CssValidatorListener> e = this.listeners.elements();
        while (e.hasMoreElements()) {
            e.nextElement().endOfRule();
        }
    }

    @Override
    public void removeThisRule() {
        Enumeration<CssValidatorListener> e = this.listeners.elements();
        while (e.hasMoreElements()) {
            e.nextElement().removeThisRule();
        }
    }

    @Override
    public void removeThisAtRule() {
        Enumeration<CssValidatorListener> e = this.listeners.elements();
        while (e.hasMoreElements()) {
            e.nextElement().removeThisAtRule();
        }
    }

    @Override
    public void handleRule(CssSelectors selector, Vector declarations) {
        Enumeration<CssValidatorListener> e = this.listeners.elements();
        while (e.hasMoreElements()) {
            e.nextElement().handleRule(this.ac, selector, declarations);
        }
    }

    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }

    public void setStyle(Class style) {
        this.ac.setCssSelectorsStyle(style);
    }

    public CssFouffa(InputStream stream) {
        super(stream);
        this.properties = new CssPropertyFactory("css2");
    }

    public CssFouffa(Reader stream) {
        super(stream);
        this.properties = new CssPropertyFactory("css2");
    }

    public CssFouffa(CssParserTokenManager tm) {
        super(tm);
        this.properties = new CssPropertyFactory("css2");
    }
}

