/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.ui.pathmapper;

import com.aptana.php.debug.ui.pathmapper.Messages;
import com.aptana.webserver.core.IServer;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPropertyListener;
import org2.eclipse.php.debug.core.debugger.pathmapper.PathMapper;
import org2.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org2.eclipse.php.internal.debug.ui.wizard.IControlHandler;
import org2.eclipse.php.internal.debug.ui.wizard.web.PathMapperCompositeFragment;

public class PathMapperDialog
extends TitleAreaDialog
implements IControlHandler,
IPropertyListener {
    private IServer server;
    private Image image;
    private PathMapperCompositeFragment pathMapperCompositeFragment;

    public PathMapperDialog(Shell shell, IServer server) {
        super(shell);
        this.server = server;
        this.setHelpAvailable(false);
    }

    protected void configureShell(Shell newShell) {
        if (newShell != null) {
            if (this.server != null) {
                newShell.setText(MessageFormat.format(Messages.PathMapperDialog_titleTextForServer, this.server.getName()));
            } else {
                newShell.setText(Messages.PathMapperDialog_titleText);
            }
        }
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).create());
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label titleBarSeparator = new Label(composite, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
        this.pathMapperCompositeFragment = new PathMapperCompositeFragment(composite, this, true);
        this.pathMapperCompositeFragment.setData(this.server);
        this.pathMapperCompositeFragment.addPropertyChangeListener(this);
        this.pathMapperCompositeFragment.setLayoutData(new GridData(1808));
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PathMapperDialog.this.image != null && !PathMapperDialog.this.image.isDisposed()) {
                    PathMapperDialog.this.image.dispose();
                }
            }
        });
        return composite;
    }

    protected void okPressed() {
        if (this.pathMapperCompositeFragment != null) {
            this.pathMapperCompositeFragment.performOk();
        }
        super.okPressed();
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(false);
        }
        return c;
    }

    protected boolean isResizable() {
        return true;
    }

    @Override
    public void setDescription(String desc) {
        super.setTitle(desc);
    }

    @Override
    public void setImageDescriptor(ImageDescriptor image) {
        if (image != null) {
            this.image = image.createImage();
            super.setTitleImage(this.image);
        }
    }

    @Override
    public void update() {
    }

    public void propertyChanged(Object source, int propId) {
        PathMapper currentServerMapping = PathMapperRegistry.getByServer(this.server);
        Button button = this.getButton(0);
        if (button != null) {
            if (currentServerMapping != null) {
                Object[] currentMappings = currentServerMapping.getMapping();
                Object[] newMappings = this.pathMapperCompositeFragment.getMappings();
                Arrays.sort(currentMappings);
                Arrays.sort(newMappings);
                if (!Arrays.equals(currentMappings, newMappings)) {
                    button.setEnabled(true);
                    return;
                }
            }
            button.setEnabled(false);
        }
    }
}

