/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.debug.core.debugger.pathmapper;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org2.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;
import org2.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org2.eclipse.php.internal.debug.core.pathmapper.VirtualPath;

public class PathMapper
implements IXMLPreferencesStorable {
    private Map<VirtualPath, VirtualPath> remoteToLocalMap = new HashMap<VirtualPath, VirtualPath>();
    private Map<VirtualPath, VirtualPath> localToRemoteMap = new HashMap<VirtualPath, VirtualPath>();
    private Map<VirtualPath, PathEntry.Type> localToPathEntryType = new HashMap<VirtualPath, PathEntry.Type>();

    /*
     * Unable to fully structure code
     */
    public synchronized void addEntry(String remoteFile, PathEntry entry) {
        remotePath = new VirtualPath(remoteFile);
        localPath = entry.getAbstractPath().clone();
        if (remotePath.getLastSegment().equalsIgnoreCase(localPath.getLastSegment())) ** GOTO lbl10
        return;
        while (remotePath.getLastSegment().equalsIgnoreCase(localPath.getLastSegment())) {
            remotePath.removeLastSegment();
            localPath.removeLastSegment();
lbl10:
            // 2 sources

            if (remotePath.getSegmentsCount() > 0 && localPath.getSegmentsCount() > 1) continue;
        }
        if (!remotePath.equals(localPath)) {
            this.remoteToLocalMap.put(remotePath, localPath);
            this.localToRemoteMap.put(localPath, remotePath);
            this.localToPathEntryType.put(localPath, entry.getType());
        }
    }

    public String getRemoteFile(String localFile) {
        VirtualPath path = this.getPath(this.localToRemoteMap, new VirtualPath(localFile));
        if (path != null) {
            return path.toString();
        }
        return null;
    }

    public VirtualPath getLocalPathMapping(VirtualPath remotePath) {
        return this.remoteToLocalMap.get(remotePath);
    }

    public PathEntry getLocalFile(String remoteFile) {
        VirtualPath path = this.getPath(this.remoteToLocalMap, new VirtualPath(remoteFile));
        if (path != null) {
            String localFile = path.toString();
            PathEntry.Type type = this.getPathType(path);
            if (type == PathEntry.Type.WORKSPACE) {
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(localFile);
                if (resource != null) {
                    return new PathEntry(path, type, (Object)resource.getParent());
                }
            } else {
                File file = new File(localFile);
                if (file.exists()) {
                    if (type == PathEntry.Type.INCLUDE_FOLDER || type == PathEntry.Type.INCLUDE_VAR) {
                        return new PathEntry(path, type, null);
                    }
                    return new PathEntry(path, type, (Object)file.getParentFile());
                }
            }
        }
        return null;
    }

    protected VirtualPath getPath(Map<VirtualPath, VirtualPath> map, VirtualPath path) {
        path = path.clone();
        VirtualPath mapPath = null;
        LinkedList<String> strippedSegments = new LinkedList<String>();
        while (path.getSegmentsCount() > 0) {
            mapPath = map.get(path);
            if (mapPath != null) {
                mapPath = mapPath.clone();
                break;
            }
            strippedSegments.add(path.removeLastSegment());
        }
        if (mapPath == null && (mapPath = map.get(path)) != null) {
            mapPath = mapPath.clone();
        }
        if (mapPath != null) {
            ListIterator i = strippedSegments.listIterator(strippedSegments.size());
            while (i.hasPrevious()) {
                mapPath.addLastSegment((String)i.previous());
            }
        }
        return mapPath;
    }

    protected PathEntry.Type getPathType(VirtualPath path) {
        path = path.clone();
        while (path.getSegmentsCount() > 0) {
            PathEntry.Type type = this.localToPathEntryType.get(path);
            if (type != null) {
                return type;
            }
            path.removeLastSegment();
        }
        return null;
    }

    public synchronized Mapping[] getMapping() {
        ArrayList<Mapping> l = new ArrayList<Mapping>(this.localToRemoteMap.size());
        for (VirtualPath localPath : this.localToRemoteMap.keySet()) {
            VirtualPath remotePath = this.localToRemoteMap.get(localPath);
            PathEntry.Type type = this.localToPathEntryType.get(localPath);
            l.add(new Mapping(localPath, remotePath, type));
        }
        return l.toArray(new Mapping[l.size()]);
    }

    public synchronized void setMapping(Mapping[] mappings) {
        this.remoteToLocalMap.clear();
        this.localToRemoteMap.clear();
        this.localToPathEntryType.clear();
        Mapping[] mappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            Mapping mapping = mappingArray[n2];
            this.localToRemoteMap.put(mapping.localPath, mapping.remotePath);
            this.remoteToLocalMap.put(mapping.remotePath, mapping.localPath);
            this.localToPathEntryType.put(mapping.localPath, mapping.type);
            ++n2;
        }
    }

    public synchronized void addMapping(Mapping mapping) {
        this.localToRemoteMap.put(mapping.localPath, mapping.remotePath);
        this.remoteToLocalMap.put(mapping.remotePath, mapping.localPath);
        this.localToPathEntryType.put(mapping.localPath, mapping.type);
    }

    public synchronized void removeMapping(Mapping mapping) {
        this.localToRemoteMap.remove(mapping.localPath);
        this.remoteToLocalMap.remove(mapping.remotePath);
        this.localToPathEntryType.remove(mapping.localPath);
    }

    public synchronized void restoreFromMap(Map map) {
        if (map == null) {
            return;
        }
        this.remoteToLocalMap.clear();
        this.localToRemoteMap.clear();
        this.localToPathEntryType.clear();
        for (Object next : map.keySet()) {
            HashMap entryMap = (HashMap)map.get(next);
            String localStr = (String)entryMap.get("local");
            String remoteStr = (String)entryMap.get("remote");
            String typeStr = (String)entryMap.get("type");
            if (localStr == null || remoteStr == null || typeStr == null) continue;
            PathEntry.Type type = PathEntry.Type.valueOf(typeStr);
            VirtualPath local = new VirtualPath(localStr);
            VirtualPath remote = new VirtualPath(remoteStr);
            if (!next.toString().startsWith("item")) continue;
            this.remoteToLocalMap.put(remote, local);
            this.localToRemoteMap.put(local, remote);
            this.localToPathEntryType.put(local, type);
        }
    }

    public synchronized Map storeToMap() {
        HashMap entries = new HashMap();
        Iterator<VirtualPath> i = this.localToRemoteMap.keySet().iterator();
        int c = 1;
        while (i.hasNext()) {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            VirtualPath local = i.next();
            VirtualPath remote = this.localToRemoteMap.get(local);
            PathEntry.Type type = this.localToPathEntryType.get(local);
            entry.put("local", local);
            entry.put("remote", remote);
            if (type != null) {
                entry.put("type", type.name());
            }
            entries.put("item" + c++, entry);
        }
        return entries;
    }

    public static class Mapping
    implements Cloneable,
    Comparable<Mapping> {
        public VirtualPath localPath;
        public VirtualPath remotePath;
        public PathEntry.Type type;

        public Mapping() {
        }

        public Mapping(VirtualPath localPath, VirtualPath remotePath, PathEntry.Type type) {
            this.localPath = localPath;
            this.remotePath = remotePath;
            this.type = type;
        }

        public Mapping clone() {
            return new Mapping(this.localPath, this.remotePath, this.type);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Mapping)) {
                return false;
            }
            Mapping other = (Mapping)obj;
            return other.localPath.equals(this.localPath) && other.remotePath.equals(this.remotePath) && other.type == this.type;
        }

        public int hashCode() {
            return this.localPath.hashCode() + 13 * this.remotePath.hashCode() + 31 * this.type.hashCode();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("Mapping { ");
            buf.append(this.localPath).append(", ").append(this.remotePath).append(", ").append((Object)this.type);
            return buf.toString();
        }

        @Override
        public int compareTo(Mapping o) {
            if (this.localPath == null || this.remotePath == null || o.localPath == null || o.remotePath == null) {
                return 0;
            }
            return (String.valueOf(this.localPath.toString()) + this.remotePath.toString()).compareTo(String.valueOf(o.localPath.toString()) + o.remotePath.toString());
        }
    }
}

