/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.daemon;

import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org2.eclipse.php.internal.debug.core.daemon.ICommunicationDaemon;

public class CommunicationDaemonRegistry {
    private static final String EXTENSION_POINT_NAME = "debugCommunicationDaemon";
    private static final String DAEMON_TAG = "daemon";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String DEFAULT_DEBUG_DAEMONS_NAMESPACE = "com.aptana.php.debug.epl";
    private Dictionary<String, CommunicationDaemonFactory> daemons = new Hashtable<String, CommunicationDaemonFactory>();
    private static CommunicationDaemonRegistry instance = null;

    private CommunicationDaemonRegistry() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(DEFAULT_DEBUG_DAEMONS_NAMESPACE, EXTENSION_POINT_NAME);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (DAEMON_TAG.equals(element.getName())) {
                this.daemons.put(element.getAttribute(ID_ATTRIBUTE), new CommunicationDaemonFactory(element));
            }
            ++i;
        }
    }

    private static CommunicationDaemonRegistry getInstance() {
        if (instance == null) {
            instance = new CommunicationDaemonRegistry();
        }
        return instance;
    }

    private Dictionary<String, CommunicationDaemonFactory> getDaemons() {
        return this.daemons;
    }

    public static ICommunicationDaemon getDaemon(String id) throws Exception {
        return (ICommunicationDaemon)((Object)CommunicationDaemonRegistry.getInstance().getDaemons().get(id));
    }

    public static ICommunicationDaemon[] getBestMatchCommunicationDaemons() {
        try {
            Dictionary<String, CommunicationDaemonFactory> factories = CommunicationDaemonRegistry.getInstance().getDaemons();
            Enumeration<CommunicationDaemonFactory> e = factories.elements();
            ArrayList<ICommunicationDaemon> pdtDaemons = new ArrayList<ICommunicationDaemon>(5);
            ArrayList<ICommunicationDaemon> additionalDaemons = new ArrayList<ICommunicationDaemon>(5);
            while (e.hasMoreElements()) {
                final CommunicationDaemonFactory initializerFactory = e.nextElement();
                final ICommunicationDaemon initializerDaemon = initializerFactory.createDaemon();
                boolean filter = WorkbenchActivityHelper.filterItem((Object)new IPluginContribution(){

                    public String getLocalId() {
                        return initializerDaemon.getDebuggerID();
                    }

                    public String getPluginId() {
                        return initializerFactory.element.getNamespaceIdentifier();
                    }
                });
                if (filter) continue;
                if (DEFAULT_DEBUG_DAEMONS_NAMESPACE.equals(initializerFactory.element.getNamespaceIdentifier())) {
                    if (!initializerDaemon.isEnabled()) continue;
                    pdtDaemons.add(initializerDaemon);
                    continue;
                }
                if (!initializerDaemon.isEnabled()) continue;
                additionalDaemons.add(initializerDaemon);
            }
            ArrayList<ICommunicationDaemon> daemons = new ArrayList<ICommunicationDaemon>(pdtDaemons.size() + 4);
            daemons.addAll(pdtDaemons);
            for (ICommunicationDaemon addedDaemon : additionalDaemons) {
                daemons.add(addedDaemon);
                for (ICommunicationDaemon pdtDaemon : pdtDaemons) {
                    if (!pdtDaemon.getClass().isAssignableFrom(addedDaemon.getClass())) continue;
                    daemons.remove(pdtDaemon);
                }
            }
            ICommunicationDaemon[] daemonsLoaded = new ICommunicationDaemon[daemons.size()];
            daemons.toArray(daemonsLoaded);
            return daemonsLoaded;
        }
        catch (Exception e) {
            PHPDebugEPLPlugin.logError(e);
            return null;
        }
    }

    class CommunicationDaemonFactory {
        ICommunicationDaemon daemon;
        IConfigurationElement element;

        public CommunicationDaemonFactory(IConfigurationElement element) {
            this.element = element;
        }

        public ICommunicationDaemon createDaemon() {
            if (this.daemon == null) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable("Error creation extension for debugCommunicationDaemon"){

                    public void run() throws Exception {
                        CommunicationDaemonFactory.this.daemon = (ICommunicationDaemon)CommunicationDaemonFactory.this.element.createExecutableExtension(CommunicationDaemonRegistry.CLASS_ATTRIBUTE);
                    }
                });
            }
            return this.daemon;
        }
    }
}

