/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.launching;

import com.aptana.php.debug.core.launch.ScriptLocator;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org2.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org2.eclipse.php.internal.debug.core.Logger;
import org2.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org2.eclipse.php.internal.debug.core.daemon.DebugDaemon;
import org2.eclipse.php.internal.debug.core.interpreter.phpIni.PHPINIDebuggerUtil;
import org2.eclipse.php.internal.debug.core.interpreter.phpIni.PHPINIUtil;
import org2.eclipse.php.internal.debug.core.interpreter.preferences.PHPexeItem;
import org2.eclipse.php.internal.debug.core.launching.DebugSessionIdGenerator;
import org2.eclipse.php.internal.debug.core.launching.Messages;
import org2.eclipse.php.internal.debug.core.launching.PHPLaunch;
import org2.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org2.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org2.eclipse.php.internal.debug.core.preferences.PHPexes;
import org2.eclipse.php.internal.debug.core.zend.debugger.DebugParametersInitializersRegistry;
import org2.eclipse.php.internal.debug.core.zend.debugger.PHPExecutableDebuggerInitializer;
import org2.eclipse.php.internal.debug.core.zend.debugger.PHPSessionLaunchMapper;
import org2.eclipse.php.internal.debug.core.zend.debugger.ProcessCrashDetector;

public class PHPExecutableLaunchDelegate
extends LaunchConfigurationDelegate {
    private static final boolean WINDOWS = File.separatorChar == '\\';
    public static final String SAVE_AUTOMATICALLY = "save_automatically";
    protected Map<String, String> envVariables = null;

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new PHPLaunch(configuration, mode, null);
    }

    public void debugPHPExecutable(ILaunch launch, String phpExe, String fileToDebug) throws DebugException {
        try {
            launch.setAttribute("executable_launch", Boolean.toString(true));
            IDebugParametersInitializer parametersInitializer = DebugParametersInitializersRegistry.getBestMatchDebugParametersInitializer(launch);
            PHPExecutableDebuggerInitializer debuggerInitializer = new PHPExecutableDebuggerInitializer(launch);
            String phpExeString = new File(phpExe).getAbsolutePath();
            String fileName = new File(fileToDebug).getAbsolutePath();
            String query = PHPLaunchUtilities.generateQuery(launch, parametersInitializer);
            String iniFileLocation = launch.getAttribute("PHPIniLocation");
            String workingDir = new File(fileToDebug).getParentFile().getAbsolutePath();
            debuggerInitializer.initializeDebug(phpExeString, fileName, workingDir, query, this.envVariables, iniFileLocation);
        }
        catch (IOException e1) {
            Logger.logException("PHPDebugTarget: Debugger didn't find file to debug.", e1);
            String errorMessage = PHPDebugCoreMessages.DebuggerFileNotFound_1;
            throw new DebugException((IStatus)new Status(4, "com.aptana.php.debug.epl", 150, errorMessage, (Throwable)e1));
        }
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IResource resource;
        if (!DebugDaemon.getDefault().validateCommunicationDaemons("org2.eclipse.php.debug.core.zendDebugger")) {
            monitor.setCanceled(true);
            monitor.done();
            return;
        }
        if (!PHPLaunchUtilities.notifyPreviousLaunches(launch)) {
            monitor.setCanceled(true);
            monitor.done();
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        String phpExeString = configuration.getAttribute("ATTR_LOCATION", null);
        String phpIniPath = configuration.getAttribute("ATTR_INI_LOCATION", null);
        configuration.getAttribute("ATTR_WORKING_DIRECTORY", null);
        String fileName = ScriptLocator.getScriptFile((ILaunchConfiguration)configuration);
        if (fileName == null || fileName.length() == 0) {
            this.displayErrorMessage(Messages.PHPExecutableLaunchDelegate_invalidFileName);
            return;
        }
        boolean runWithDebugInfo = configuration.getAttribute("org2.eclipse.php.debug.core.RunWithDebugInfo", true);
        IProject project = null;
        if (fileName == null) {
            fileName = configuration.getAttribute("ATTR_FILE", null);
        }
        if (fileName != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(fileName)) != null) {
            project = resource.getProject();
            fileName = resource.getLocation().toFile().getAbsolutePath();
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (fileName == null || fileName.equals("")) {
            PHPDebugEPLPlugin.logError("Please set a valid PHP executable for this launch.", new Exception("\nCould not launch the debug/run session for the given PHP file. \nPlease set a valid PHP file for this launch. \nNote that files external, non project, files are not supported."));
            this.displayErrorMessage(Messages.PHPExecutableLaunchDelegate_launchedFileInvalid);
            return;
        }
        if (phpExeString == null) {
            this.displayErrorMessage(Messages.PHPExecutableLaunchDelegate_phpExeStringMissingError);
            return;
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10);
        File phpIni = phpIniPath != null && new File(phpIniPath).exists() ? new File(phpIniPath) : PHPINIUtil.findPHPIni(phpExeString);
        File tempIni = PHPINIDebuggerUtil.prepareBeforeDebug(phpIni, phpExeString, project, "org2.eclipse.php.debug.core.zendDebugger");
        launch.setAttribute("PHPIniLocation", tempIni.getAbsolutePath());
        if (mode.equals("debug") || runWithDebugInfo) {
            boolean stopAtFirstLine = configuration.getAttribute("firstLineBreakpoint", PHPProjectPreferences.getStopAtFirstLine(project));
            int requestPort = PHPDebugEPLPlugin.getDebugPort("org2.eclipse.php.debug.core.zendDebugger");
            ILaunchConfigurationWorkingCopy wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
            if (project != null) {
                wc.setAttribute("org2.eclipse.php.debug.core.PHP_Project", project.getFullPath().toString());
            }
            wc.setAttribute("debugTransferEncoding", PHPProjectPreferences.getTransferEncoding(project));
            wc.setAttribute("debugOutputEncoding", PHPProjectPreferences.getOutputEncoding(project));
            wc.setAttribute("php_debug_type", "php_exe_script_debug");
            wc.doSave();
            if (monitor.isCanceled()) {
                return;
            }
            int sessionID = DebugSessionIdGenerator.generateSessionID();
            PHPSessionLaunchMapper.put(sessionID, launch);
            launch.setAttribute("port", Integer.toString(requestPort));
            launch.setAttribute("firstLineBreakpoint", Boolean.toString(stopAtFirstLine));
            launch.setAttribute("debugSessionID", Integer.toString(sessionID));
            this.debugPHPExecutable(launch, phpExeString, fileName);
        } else {
            PHPexeItem[] items;
            Path phpExe = new Path(phpExeString);
            String[] envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
            File phpExeFile = new File(phpExeString);
            String phpIniLocation = launch.getAttribute("PHPIniLocation");
            String phpConfigDir = phpExeFile.getParent();
            if (phpIniLocation != null && !phpIniLocation.equals("")) {
                phpConfigDir = new File(phpIniLocation).getParent();
            }
            String sapiType = null;
            PHPexeItem[] pHPexeItemArray = items = PHPexes.getInstance().getAllItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                PHPexeItem item = pHPexeItemArray[n2];
                if (item.getExecutable().equals(phpExeFile)) {
                    sapiType = item.getSapiType();
                    break;
                }
                ++n2;
            }
            String[] args = PHPLaunchUtilities.getProgramArguments(launch.getLaunchConfiguration());
            String[] cmdLine = PHPLaunchUtilities.getCommandLine(launch.getLaunchConfiguration(), phpExeString, phpConfigDir, fileName, (String[])(sapiType == "CLI" ? args : null));
            if (!WINDOWS) {
                StringBuffer buf = new StringBuffer();
                if ("macosx".equals(Platform.getOS())) {
                    buf.append("DYLD_LIBRARY_PATH");
                } else {
                    buf.append("LD_LIBRARY_PATH");
                }
                buf.append('=');
                buf.append(phpExeFile.getParent());
                String[] envpNew = new String[envp == null ? 1 : envp.length + 1];
                if (envp != null) {
                    System.arraycopy(envp, 0, envpNew, 0, envp.length);
                }
                envpNew[envpNew.length - 1] = buf.toString();
                envp = envpNew;
            }
            if (monitor.isCanceled()) {
                return;
            }
            File workingDir = new File(fileName).getParentFile();
            Process p = workingDir.exists() ? DebugPlugin.exec((String[])cmdLine, (File)workingDir, (String[])envp) : DebugPlugin.exec((String[])cmdLine, null, (String[])envp);
            new Thread(new ProcessCrashDetector(p)).start();
            IProcess process = null;
            HashMap<String, String> processAttributes = new HashMap<String, String>();
            String programName = phpExe.lastSegment();
            String extension = phpExe.getFileExtension();
            if (extension != null) {
                programName = programName.substring(0, programName.length() - (extension.length() + 1));
            }
            programName = programName.toLowerCase();
            processAttributes.put(IProcess.ATTR_PROCESS_TYPE, programName);
            if (p != null) {
                subMonitor = new SubProgressMonitor(monitor, 80);
                subMonitor.beginTask(MessageFormat.format("start launch", configuration.getName()), -1);
                process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)phpExe.toOSString(), processAttributes);
                if (process == null) {
                    p.destroy();
                    throw new CoreException((IStatus)new Status(4, "com.aptana.php.debug.epl", 0, null, null));
                }
                subMonitor.done();
            }
            process.setAttribute(IProcess.ATTR_CMDLINE, fileName);
            if (!CommonTab.isLaunchInBackground((ILaunchConfiguration)configuration)) {
                while (!process.isTerminated()) {
                    try {
                        if (monitor.isCanceled()) {
                            process.terminate();
                            break;
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                subMonitor = new SubProgressMonitor(monitor, 10);
                RefreshTab.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)subMonitor);
            }
        }
    }

    private void displayErrorMessage(final String message) {
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)display.getActiveShell(), (String)PHPDebugCoreMessages.Debugger_LaunchError_title, (String)message);
            }
        });
    }

    protected boolean saveBeforeLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        String filePath = configuration.getAttribute("ATTR_FILE", "");
        if ("".equals(filePath)) {
            return super.saveBeforeLaunch(configuration, mode, monitor);
        }
        return super.saveBeforeLaunch(configuration, mode, monitor);
    }
}

