/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org2.eclipse.php.internal.debug.core.Logger;
import org2.eclipse.php.internal.debug.core.daemon.CommunicationDaemonRegistry;
import org2.eclipse.php.internal.debug.core.daemon.ICommunicationDaemon;
import org2.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;

public class PHPDebuggersRegistry {
    private static final String EXTENSION_POINT_NAME = "phpDebuggers";
    private static final String DEBUGGER_TAG = "phpDebugger";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CONFIGURATION_CLASS_ATTRIBUTE = "debuggerConfiguration";
    private static String DEFAULT_DEBUGGER_ID = "org2.eclipse.php.debug.core.xdebugDebugger";
    private static PHPDebuggersRegistry instance;
    private HashMap<String, String> debuggers = new HashMap();
    private HashMap<String, AbstractDebuggerConfiguration> configurations = new HashMap();

    private PHPDebuggersRegistry() {
        this.loadDebuggers();
    }

    private static PHPDebuggersRegistry getInstance() {
        if (instance == null) {
            instance = new PHPDebuggersRegistry();
        }
        return instance;
    }

    public static Set<String> getDebuggersIds() {
        return Collections.unmodifiableSet(PHPDebuggersRegistry.getInstance().debuggers.keySet());
    }

    public static AbstractDebuggerConfiguration getDebuggerConfiguration(String debuggerId) {
        return PHPDebuggersRegistry.getInstance().configurations.get(debuggerId);
    }

    public static AbstractDebuggerConfiguration[] getDebuggersConfigurations() {
        Collection<AbstractDebuggerConfiguration> values = PHPDebuggersRegistry.getInstance().configurations.values();
        AbstractDebuggerConfiguration[] configurations = new AbstractDebuggerConfiguration[values.size()];
        return values.toArray(configurations);
    }

    public static String getDefaultDebuggerId() {
        return DEFAULT_DEBUGGER_ID;
    }

    public static void setDefaultDebuggerId(String id) throws IllegalArgumentException {
        if (!PHPDebuggersRegistry.getInstance().debuggers.containsKey(id)) {
            throw new IllegalArgumentException("No such debugger id was registered: " + id);
        }
        DEFAULT_DEBUGGER_ID = id;
    }

    public static String getDebuggerName(String debuggerID) {
        return PHPDebuggersRegistry.getInstance().debuggers.get(debuggerID);
    }

    private void loadDebuggers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("com.aptana.php.debug.epl", EXTENSION_POINT_NAME);
        HashMap<String, AbstractDebuggerConfiguration> nonPDTConfigurations = new HashMap<String, AbstractDebuggerConfiguration>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            final IConfigurationElement element = iConfigurationElementArray[n2];
            if (DEBUGGER_TAG.equals(element.getName())) {
                String name = element.getAttribute(NAME_ATTRIBUTE);
                final String id = element.getAttribute(ID_ATTRIBUTE);
                boolean isPDT = true;
                boolean filter = WorkbenchActivityHelper.filterItem((Object)new IPluginContribution(){

                    public String getLocalId() {
                        return id;
                    }

                    public String getPluginId() {
                        return element.getNamespaceIdentifier();
                    }
                });
                if (!filter) {
                    this.debuggers.put(id, name);
                    try {
                        AbstractDebuggerConfiguration configuration = (AbstractDebuggerConfiguration)element.createExecutableExtension(CONFIGURATION_CLASS_ATTRIBUTE);
                        configuration.setDebuggerId(id);
                        configuration.setName(name);
                        try {
                            ICommunicationDaemon[] daemons;
                            ICommunicationDaemon[] iCommunicationDaemonArray = daemons = CommunicationDaemonRegistry.getBestMatchCommunicationDaemons();
                            int n3 = daemons.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ICommunicationDaemon daemon = iCommunicationDaemonArray[n4];
                                if (daemon.isDebuggerDaemon() && id.equals(daemon.getDebuggerID())) {
                                    configuration.setCommunicationDaemon(daemon);
                                    break;
                                }
                                ++n4;
                            }
                        }
                        catch (Exception e) {
                            IdeLog.logError((Plugin)PHPDebugEPLPlugin.getDefault(), (String)"Error loading a debugger configuration", (Throwable)e);
                            configuration.setPort(-1);
                        }
                        this.configurations.put(id, configuration);
                        if (!isPDT) {
                            nonPDTConfigurations.put(id, configuration);
                        }
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                    }
                }
            }
            ++n2;
        }
        Set keySet = nonPDTConfigurations.keySet();
        for (String key : keySet) {
            AbstractDebuggerConfiguration configuration = (AbstractDebuggerConfiguration)nonPDTConfigurations.get(key);
            this.configurations.put(key, configuration);
            this.debuggers.put(configuration.getDebuggerId(), configuration.getName());
        }
    }
}

