/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.preferences;

import com.aptana.php.debug.core.interpreter.IInterpreter;
import com.aptana.php.debug.core.interpreter.Interpreters;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org2.eclipse.php.internal.debug.core.interpreter.preferences.PHPexeItem;
import org2.eclipse.php.internal.debug.core.preferences.IPHPExesListener;
import org2.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org2.eclipse.php.internal.debug.core.preferences.PHPExesEvent;

public class PHPexes {
    public static final String SEPARATOR = ";";
    public static final String ZEND_DEBUGGER_ID = "org2.eclipse.php.debug.core.zendDebugger";
    public static final String XDEBUG_DEBUGGER_ID = "org2.eclipse.php.debug.core.xdebugDebugger";
    private static final String EXTENSIONS = "extensions";
    public static final String PHP_LANGUAGE_NAME = "php";
    private static Object lock = new Object();
    private static PHPexes instance;
    private HashMap<String, HashMap<String, PHPexeItem>> items = new HashMap();
    private ArrayList<PHPexeItem> allItems = new ArrayList();
    private PHPexeItem defaultItem;
    private final LinkedList<IPHPExesListener> listeners = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PHPexes getInstance() {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                instance = new PHPexes();
            }
            return instance;
        }
    }

    private PHPexes() {
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addItem(PHPexeItem item) {
        this.allItems.add(item);
        String debuggerId = item.getDebuggerID();
        HashMap<String, PHPexeItem> map = this.items.get(debuggerId);
        if (map == null) {
            map = new HashMap();
            this.items.put(debuggerId, map);
        }
        if (map.isEmpty() && (item.isDefault() || this.allItems.size() == 1)) {
            this.setDefaultItem(item);
        }
        map.put(item.getName(), item);
        LinkedList<IPHPExesListener> linkedList = this.listeners;
        synchronized (linkedList) {
            IPHPExesListener[] allListeners = new IPHPExesListener[this.listeners.size()];
            this.listeners.toArray(allListeners);
            IPHPExesListener[] iPHPExesListenerArray = allListeners;
            int n = allListeners.length;
            int n2 = 0;
            while (n2 < n) {
                IPHPExesListener listener = iPHPExesListenerArray[n2];
                PHPExesEvent phpExesEvent = new PHPExesEvent(item);
                listener.phpExeAdded(phpExesEvent);
                ++n2;
            }
        }
    }

    public PHPexeItem getDefaultItem(String debuggerId) {
        if (this.defaultItem != null && this.defaultItem.getDebuggerID().equals(debuggerId)) {
            return this.defaultItem;
        }
        return null;
    }

    public boolean hasItems(String debuggerId) {
        HashMap<String, PHPexeItem> map = this.items.get(debuggerId);
        return map != null && map.size() > 0;
    }

    public boolean hasItems() {
        return this.getAllItems().length > 0;
    }

    public PHPexeItem[] getEditableItems() {
        Set<String> installedDebuggers = PHPDebuggersRegistry.getDebuggersIds();
        ArrayList<PHPexeItem> list = new ArrayList<PHPexeItem>();
        for (String debuggerId : installedDebuggers) {
            HashMap<String, PHPexeItem> installedExes = this.items.get(debuggerId);
            if (installedExes == null) continue;
            Set<String> exeNames = installedExes.keySet();
            for (String name : exeNames) {
                PHPexeItem exeItem = installedExes.get(name);
                if (!exeItem.isEditable()) continue;
                list.add(exeItem);
            }
        }
        return list.toArray(new PHPexeItem[list.size()]);
    }

    public PHPexeItem getItem(String debuggerId, String name) {
        HashMap<String, PHPexeItem> map = this.items.get(debuggerId);
        if (map == null) {
            return null;
        }
        return map.get(name);
    }

    public PHPexeItem getItemForFile(String exeFilePath, String iniFilePath) {
        PHPexeItem[] items = this.getItemsForFile(exeFilePath, iniFilePath);
        if (items != null && items.length > 0) {
            return items[0];
        }
        return null;
    }

    public PHPexeItem[] getItemsForFile(String exeFilePath, String iniFilePath) {
        ArrayList<PHPexeItem> result = new ArrayList<PHPexeItem>(5);
        Set<String> installedDebuggers = PHPDebuggersRegistry.getDebuggersIds();
        for (String debuggerId : installedDebuggers) {
            HashMap<String, PHPexeItem> installedExes = this.items.get(debuggerId);
            if (installedExes == null) continue;
            Set<String> exeNames = installedExes.keySet();
            for (String name : exeNames) {
                PHPexeItem exeItem = installedExes.get(name);
                boolean iniEquals = true;
                if (iniFilePath != null) {
                    boolean bl = exeItem.getINILocation() == null ? iniFilePath == null || iniFilePath.equals("") : (iniEquals = iniFilePath.equals(exeItem.getINILocation().toString()));
                }
                if (!iniEquals || exeFilePath == null || !exeFilePath.equals(exeItem.getExecutable().toString())) continue;
                result.add(exeItem);
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new PHPexeItem[result.size()]);
    }

    public PHPexeItem[] getItems(String debuggerId) {
        HashMap<String, PHPexeItem> installedExes = this.items.get(debuggerId);
        if (installedExes == null) {
            return null;
        }
        PHPexeItem[] retItems = new PHPexeItem[installedExes.size()];
        return installedExes.values().toArray(retItems);
    }

    public PHPexeItem[] getAllItems() {
        ArrayList<PHPexeItem> allItems = new ArrayList<PHPexeItem>();
        Set<String> debuggers = this.items.keySet();
        for (String debugger : debuggers) {
            HashMap<String, PHPexeItem> debuggerItems = this.items.get(debugger);
            if (debuggerItems == null) continue;
            Collection<PHPexeItem> exeItems = debuggerItems.values();
            for (PHPexeItem item : exeItems) {
                allItems.add(item);
            }
        }
        return allItems.toArray(new PHPexeItem[allItems.size()]);
    }

    private void load() {
        PHPexeItem item;
        String[] debuggerDefault;
        this.items = new HashMap();
        List interpreters = Interpreters.getDefault().getInterpreters(PHP_LANGUAGE_NAME);
        for (IInterpreter interpreter : interpreters) {
            if (!(interpreter instanceof PHPexeItem)) continue;
            this.addItem((PHPexeItem)interpreter);
        }
        IEclipsePreferences prefs = PHPDebugEPLPlugin.getInstancePreferences();
        String defaultDebuggerSetting = prefs.get("com.aptana.php.debug.eplinstalledPHPDefaults", null);
        if (defaultDebuggerSetting != null && defaultDebuggerSetting.length() != 0 && (debuggerDefault = defaultDebuggerSetting.split("=")).length == 2 && (item = this.getItem(debuggerDefault[0], debuggerDefault[1])) != null) {
            this.setDefaultItem(item);
            return;
        }
        String debuggerId = PHPDebugEPLPlugin.getCurrentDebuggerId();
        PHPexeItem defaultItem = this.getDefaultItem(debuggerId);
        if (defaultItem != null) {
            this.setDefaultItem(defaultItem);
        } else {
            PHPexeItem[] itemsForDebugger = this.getItems(debuggerId);
            if (itemsForDebugger == null) {
                itemsForDebugger = this.getItems(debuggerId = ZEND_DEBUGGER_ID.equals(debuggerId) ? XDEBUG_DEBUGGER_ID : ZEND_DEBUGGER_ID);
                if (itemsForDebugger == null) {
                    return;
                }
                prefs.put("com.aptana.php.debug.php_debugger_id", debuggerId);
                try {
                    prefs.flush();
                }
                catch (BackingStoreException e) {
                    PHPDebugEPLPlugin.logError("Error while saving the PHP executables settings.", e);
                }
            }
            PHPexeItem first = null;
            PHPexeItem firstCGI = null;
            PHPexeItem[] pHPexeItemArray = itemsForDebugger;
            int n = itemsForDebugger.length;
            int n2 = 0;
            while (n2 < n) {
                PHPexeItem item2 = pHPexeItemArray[n2];
                if (item2.isDefault()) {
                    this.setDefaultItem(item2);
                    first = null;
                    break;
                }
                if (first == null) {
                    first = item2;
                }
                if (firstCGI == null && "CGI".equals(item2.getSapiType())) {
                    firstCGI = item2;
                }
                ++n2;
            }
            if (firstCGI != null) {
                this.setDefaultItem(firstCGI);
            } else if (first != null) {
                this.setDefaultItem(first);
            }
        }
    }

    public synchronized void removeItem(PHPexeItem item) {
        this.allItems.remove(item);
        String debuggerID = item.getDebuggerID();
        HashMap<String, PHPexeItem> exes = this.items.get(debuggerID);
        PHPexeItem removedItem = null;
        if (exes != null) {
            removedItem = exes.remove(item.getName());
        }
        if (removedItem != null && removedItem.isDefault()) {
            if (this.allItems.isEmpty()) {
                this.defaultItem = null;
            } else {
                this.setDefaultItem(this.allItems.get(0));
            }
        }
        IPHPExesListener[] allListeners = new IPHPExesListener[this.listeners.size()];
        this.listeners.toArray(allListeners);
        IPHPExesListener[] iPHPExesListenerArray = allListeners;
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPHPExesListener listener = iPHPExesListenerArray[n2];
            PHPExesEvent phpExesEvent = new PHPExesEvent(item);
            listener.phpExeRemoved(phpExesEvent);
            ++n2;
        }
    }

    public synchronized void setDefaultItem(PHPexeItem defaultItem) {
        if (defaultItem == this.defaultItem) {
            return;
        }
        for (PHPexeItem e : this.allItems) {
            if (e.equals(defaultItem)) {
                e.setDefault(true);
                continue;
            }
            e.setDefault(false);
        }
        defaultItem.setDefault(true);
        PHPexeItem oldDefault = this.defaultItem;
        this.defaultItem = defaultItem;
        IPHPExesListener[] allListeners = new IPHPExesListener[this.listeners.size()];
        this.listeners.toArray(allListeners);
        IPHPExesListener[] iPHPExesListenerArray = allListeners;
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPHPExesListener listener = iPHPExesListenerArray[n2];
            listener.phpExeDefaultChanged(oldDefault, this.defaultItem);
            ++n2;
        }
    }

    public void setDefaultItem(String debuggerID, String defaultItemName) {
        PHPexeItem item = this.getItem(debuggerID, defaultItemName);
        if (item != null) {
            this.setDefaultItem(item);
        }
    }

    public void save() {
        IEclipsePreferences prefs = PHPDebugEPLPlugin.getInstancePreferences();
        PHPexeItem[] phpItems = this.getEditableItems();
        StringBuffer locationsString = new StringBuffer();
        StringBuffer inisString = new StringBuffer();
        StringBuffer namesString = new StringBuffer();
        StringBuffer debuggersString = new StringBuffer();
        StringBuffer extensionsString = new StringBuffer();
        int i = 0;
        while (i < phpItems.length) {
            String[] extensions2;
            PHPexeItem item = phpItems[i];
            if (i > 0) {
                locationsString.append(SEPARATOR);
                inisString.append(SEPARATOR);
                namesString.append(SEPARATOR);
                debuggersString.append(SEPARATOR);
                extensionsString.append(SEPARATOR);
            }
            locationsString.append(item.getExecutable().toString());
            inisString.append(item.getINILocation() != null ? item.getINILocation().toString() : "null");
            namesString.append(item.getName());
            debuggersString.append(item.getDebuggerID());
            String[] stringArray = extensions2 = item.getExtensions();
            int n = extensions2.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                extensionsString.append(s);
                extensionsString.append('\u0005');
                ++n2;
            }
            ++i;
        }
        prefs.put("com.aptana.php.debug.eplinstalledPHPNames", namesString.toString());
        prefs.put("com.aptana.php.debug.eplinstalledPHPLocations", locationsString.toString());
        prefs.put("com.aptana.php.debug.eplinstalledPHPInis", inisString.toString());
        prefs.put("com.aptana.php.debug.eplinstalledPHPDebuggers", debuggersString.toString());
        prefs.put(EXTENSIONS, extensionsString.toString());
        StringBuffer defaultsString = new StringBuffer();
        Iterator iterator = this.defaultItem != null ? Collections.singleton(this.defaultItem).iterator() : Collections.emptySet().iterator();
        while (iterator.hasNext()) {
            PHPexeItem exeItem = (PHPexeItem)iterator.next();
            defaultsString.append(exeItem.getDebuggerID());
            defaultsString.append('=');
            defaultsString.append(exeItem.getName());
            if (!iterator.hasNext()) continue;
            defaultsString.append(SEPARATOR);
        }
        prefs.put("com.aptana.php.debug.eplinstalledPHPDefaults", defaultsString.toString());
        if (this.defaultItem != null) {
            prefs.put("com.aptana.php.debug.php_debugger_id", this.defaultItem.getDebuggerID());
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            PHPDebugEPLPlugin.logError("Error while saving the PHP executables settings.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPHPExesListener(IPHPExesListener listener) {
        LinkedList<IPHPExesListener> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePHPExesListener(IPHPExesListener listener) {
        LinkedList<IPHPExesListener> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(listener);
        }
    }

    public static PHPexeItem locateCGI(String debuggerId, String sapiType) {
        PHPexeItem[] items;
        PHPexeItem[] pHPexeItemArray = items = PHPexes.getInstance().getItems(debuggerId);
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            PHPexeItem item = pHPexeItemArray[n2];
            if ("CGI".equals(item.getSapiType())) {
                return item;
            }
            ++n2;
        }
        return null;
    }
}

