/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.xdebug.communication;

import com.aptana.php.debug.core.server.PHPServersManager;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import com.aptana.webserver.core.IServer;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org2.eclipse.php.debug.core.debugger.pathmapper.PathMapper;
import org2.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org2.eclipse.php.internal.debug.core.daemon.AbstractDebuggerCommunicationDaemon;
import org2.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org2.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org2.eclipse.php.internal.debug.core.sourcelookup.PHPSourceLookupDirector;
import org2.eclipse.php.internal.debug.core.xdebug.IDELayerFactory;
import org2.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceMgr;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpMultiSessionTarget;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSession;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;

public class XDebugCommunicationDaemon
extends AbstractDebuggerCommunicationDaemon {
    public static final String XDEBUG_DEBUGGER_ID = "org2.eclipse.php.debug.core.xdebugDebugger";
    public static final int[] DEBUGGER_DEFAULT_PORTS = new int[]{9000};
    private PortChangeListener portChangeListener;

    @Override
    public void init() {
        this.initDeamonChangeListener();
        super.init();
    }

    protected void initDeamonChangeListener() {
        if (this.portChangeListener == null) {
            Preferences preferences = PHPDebugEPLPlugin.getDefault().getPluginPreferences();
            this.portChangeListener = new PortChangeListener();
            preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.portChangeListener);
        }
    }

    @Override
    public int getReceiverPort() {
        return PHPDebugEPLPlugin.getDebugPort(XDEBUG_DEBUGGER_ID);
    }

    @Override
    public String getDebuggerID() {
        return XDEBUG_DEBUGGER_ID;
    }

    @Override
    public boolean isDebuggerDaemon() {
        return true;
    }

    public static boolean isDefaultDebugPort(int port) {
        int[] nArray = DEBUGGER_DEFAULT_PORTS;
        int n = DEBUGGER_DEFAULT_PORTS.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i == port) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void startConnectionThread(Socket socket) {
        if (DBGpLogger.debugSession()) {
            DBGpLogger.debug("Connection established: " + socket.toString());
        }
        try {
            DBGpSession session = new DBGpSession(socket);
            if (session.isActive() && !DBGpSessionHandler.getInstance().fireSessionAdded(session)) {
                XDebugPreferenceMgr.AcceptRemoteSession aSess = XDebugPreferenceMgr.getAcceptRemoteSession();
                if (aSess != XDebugPreferenceMgr.AcceptRemoteSession.off) {
                    if (aSess == XDebugPreferenceMgr.AcceptRemoteSession.localhost && !session.getRemoteAddress().isLoopbackAddress() && !PHPDebugEPLPlugin.getDebugHosts().contains(session.getRemoteHostname())) {
                        session.endSession();
                    } else if (aSess == XDebugPreferenceMgr.AcceptRemoteSession.prompt) {
                        PromptUser prompt = new PromptUser(session);
                        Display.getDefault().syncExec((Runnable)prompt);
                        if (prompt.isResult()) {
                            this.createLaunch(session);
                        } else {
                            session.endSession();
                        }
                    } else {
                        this.createLaunch(session);
                    }
                } else {
                    session.endSession();
                }
            }
        }
        catch (Exception e) {
            PHPDebugEPLPlugin.logError("Unexpected Exception: Listener thread still listening", e);
        }
    }

    private void createLaunch(DBGpSession session) {
        boolean stopAtFirstLine = true;
        DBGpTarget target = null;
        PathMapper mapper = null;
        PHPSourceLookupDirector srcLocator = new PHPSourceLookupDirector();
        srcLocator.initializeParticipants();
        ILaunchConfigurationType launchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.aptana.php.debug.epl.XDebugJitLaunchConfigurationType");
        ILaunchConfigurationWorkingCopy wc = null;
        if (launchType != null) {
            if (DebugUITools.getLaunchPerspective((ILaunchConfigurationType)launchType, (String)"debug") == null) {
                DebugUITools.setLaunchPerspective((ILaunchConfigurationType)launchType, (String)"debug", (String)"org.eclipse.debug.ui.DebugPerspective");
            }
            try {
                wc = launchType.newInstance(null, "XDebug JIT Session");
                wc.setAttribute("org.eclipse.debug.ui.private", true);
            }
            catch (CoreException coreException) {
                wc = null;
            }
        }
        Launch remoteLaunch = new Launch(wc, "debug", (ISourceLocator)srcLocator);
        boolean multiSession = XDebugPreferenceMgr.useMultiSession();
        if (session.getSessionId() == null && !multiSession) {
            stopAtFirstLine = PHPLaunchUtilities.shouldBreakOnJitFirstLine(session.getRemoteHostname());
            target = new DBGpTarget((ILaunch)remoteLaunch, null, null, session.getIdeKey(), stopAtFirstLine, null, null);
            mapper = this.resolveMapper(session);
            DBGpSessionHandler.getInstance().addSessionListener(target);
        } else if (session.getSessionId() != null) {
            String sessionId = session.getSessionId();
            IDebugTarget[] debugTargets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
            boolean foundPreviousMatchingLaunch = false;
            IDebugTarget[] iDebugTargetArray = debugTargets;
            int n = debugTargets.length;
            int n2 = 0;
            while (n2 < n) {
                DBGpTarget existingTaget;
                IDebugTarget aTarget = iDebugTargetArray[n2];
                if (aTarget instanceof DBGpTarget && sessionId.equals((existingTaget = (DBGpTarget)aTarget).getSessionID())) {
                    mapper = existingTaget.getPathMapper();
                    stopAtFirstLine = existingTaget.isStoppingAtFirstLine();
                    foundPreviousMatchingLaunch = true;
                    break;
                }
                ++n2;
            }
            if (!foundPreviousMatchingLaunch) {
                stopAtFirstLine = PHPLaunchUtilities.shouldBreakOnJitFirstLine(session.getRemoteHostname());
            }
            target = new DBGpTarget((ILaunch)remoteLaunch, null, null, session.getIdeKey(), stopAtFirstLine, null, sessionId);
            if (mapper == null) {
                mapper = this.resolveMapper(session);
            }
            DBGpSessionHandler.getInstance().addSessionListener(target);
        } else {
            target = new DBGpTarget((ILaunch)remoteLaunch, null, session.getIdeKey(), session.getSessionId(), stopAtFirstLine);
            mapper = this.resolveMapper(session);
        }
        target.setPathMapper(mapper);
        target.setSession(session);
        session.setDebugTarget(target);
        if (multiSession && session.getSessionId() == null) {
            DBGpMultiSessionTarget multiSessionTarget = new DBGpMultiSessionTarget((ILaunch)remoteLaunch, null, null, session.getIdeKey(), stopAtFirstLine, null, session.getSessionId());
            DBGpSessionHandler.getInstance().addSessionListener(multiSessionTarget);
            remoteLaunch.addDebugTarget((IDebugTarget)multiSessionTarget);
            multiSessionTarget.sessionReceived((DBGpBreakpointFacade)((Object)IDELayerFactory.getIDELayer()), XDebugPreferenceMgr.createSessionPreferences(), target, mapper);
        } else {
            remoteLaunch.addDebugTarget((IDebugTarget)target);
            target.sessionReceived((DBGpBreakpointFacade)((Object)IDELayerFactory.getIDELayer()), XDebugPreferenceMgr.createSessionPreferences());
        }
        DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)remoteLaunch);
    }

    private PathMapper resolveMapper(DBGpSession session) {
        String remoteHostname;
        IServer server = null;
        if (session.getSessionId() != null) {
            List servers = PHPServersManager.getServers();
            for (IServer serverConf : servers) {
                URL baseURL = serverConf.getBaseURL();
                if (baseURL.getPort() != session.getRemotePort() || !baseURL.getHost().equalsIgnoreCase(session.getRemoteHostname())) continue;
                server = serverConf;
                break;
            }
            if (server == null) {
                server = PHPServersManager.getServer((InetAddress)session.getRemoteAddress());
            }
        }
        if ((server == null || session.getSessionId() == null) && (server = PHPServersManager.getTemporaryServer((String)(remoteHostname = session.getRemoteHostname()), (int)80)) == null) {
            server = PHPServersManager.createTemporaryServer((String)remoteHostname, (int)80, (boolean)session.isSecure());
            PHPServersManager.addTemporaryServer((IServer)server);
        }
        PathMapper mapper = null;
        if (server != null) {
            mapper = PathMapperRegistry.getByServer(server);
        }
        if (mapper == null) {
            mapper = new PathMapper();
        }
        return mapper;
    }

    private class PortChangeListener
    implements Preferences.IPropertyChangeListener {
        private PortChangeListener() {
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (event.getProperty().equals("com.aptana.php.debug.epl.xdebug_port")) {
                XDebugCommunicationDaemon.this.resetSocket();
            }
        }
    }

    private class PromptUser
    implements Runnable {
        private DBGpSession session;
        private boolean result;

        public boolean isResult() {
            return this.result;
        }

        public PromptUser(DBGpSession session) {
            this.session = session;
        }

        @Override
        public void run() {
            String insert = String.valueOf(this.session.getRemoteAddress().getCanonicalHostName()) + "/" + this.session.getRemoteAddress().getHostAddress();
            String message = MessageFormat.format(PHPDebugCoreMessages.XDebugMessage_remoteSessionPrompt, insert);
            this.result = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.XDebugMessage_remoteSessionTitle, (String)message);
        }
    }
}

