/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;

public class SimpleByteValue
extends DBGpElement
implements IValue {
    private byte value;

    public SimpleByteValue(byte value, IDebugTarget debugTarget) {
        super(debugTarget);
        this.value = value;
    }

    public String getReferenceTypeName() throws DebugException {
        return "byte";
    }

    public String getValueString() throws DebugException {
        String valStr = Integer.toHexString(this.value & 0xFF);
        if (valStr.length() == 1) {
            valStr = "0" + valStr;
        }
        return valStr;
    }

    public IVariable[] getVariables() throws DebugException {
        return new IVariable[0];
    }

    public boolean hasVariables() throws DebugException {
        return false;
    }

    public boolean isAllocated() throws DebugException {
        return false;
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }
}

