/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.zend.debugger;

import java.util.Collection;

public class Breakpoint
implements Cloneable {
    public static final String NAME_CHANGED_PROPERTY = "fileName";
    public static final String LINE_CHANGED_PROPERTY = "lineNumber";
    public static final String ID_CHANGED_PROPERTY = "id";
    public static final String TYPE_CHANGED_PROPERTY = "type";
    public static final String LIFETIME_CHANGED_PROPERTY = "lifetime";
    public static final String EXPRESSION_CHANGED_PROPERTY = "expression";
    public static final String ENABLE_CHANGED_PROPERTY = "enable";
    static final long serialVersionUID = 8217568055748309793L;
    public static final int DEFAULT_ID = -1;
    public static final int ZEND_CONDITIONAL_BREAKPOINT = 2;
    public static final String CONDITIONAL_STRING = "Conditional";
    public static final int ZEND_STATIC_BREAKPOINT = 1;
    public static final String STATIC_STRING = "Static";
    public static final int ZEND_ONETIME_BREAKPOINT = 1;
    public static final String ONETIME_STRING = "One time";
    public static final int ZEND_PERMANENT_BREAKPOINT = 2;
    public static final String PERMANENT_STRING = "Permanent";
    private int id;
    private int type;
    private int lifetime;
    private String expression = "";
    private boolean enable;
    private boolean conditionalFlag = false;
    private boolean staticFlag = true;
    protected String fileName = "";
    protected int lineNumber = -1;
    protected transient Collection listeners;

    public Breakpoint() {
        this("", -1);
    }

    public Breakpoint(String fileName, int lineNumber) {
        this.setFileName(fileName);
        this.setLineNumber(lineNumber);
        this.id = -1;
        this.setStaticFlag(true);
        this.lifetime = 2;
        this.enable = true;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setID(int id) {
        if (this.id != id) {
            int oldValue = this.id;
            this.id = id;
            this.fireBreakpointChanged(this, ID_CHANGED_PROPERTY, new Integer(oldValue), new Integer(id));
        }
    }

    public int getID() {
        return this.id;
    }

    public void setFileName(String newFileName) {
        if (this.fileName.equals(newFileName)) {
            return;
        }
        String oldFileName = this.fileName;
        this.fileName = newFileName;
        this.fireBreakpointChanged(this, NAME_CHANGED_PROPERTY, oldFileName, newFileName);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int newLineNumber) {
        if (this.lineNumber == newLineNumber) {
            return;
        }
        int oldLineNumber = this.lineNumber;
        this.lineNumber = newLineNumber;
        this.fireBreakpointChanged(this, LINE_CHANGED_PROPERTY, new Integer(oldLineNumber), new Integer(newLineNumber));
    }

    public void setConditionalFlag(boolean b) {
        this.conditionalFlag = b;
    }

    public void setStaticFlag(boolean b) {
        this.staticFlag = b;
    }

    public boolean getStaticFlag() {
        return this.staticFlag;
    }

    public boolean getConditionalFlag() {
        return this.conditionalFlag;
    }

    public void setType(int type) {
        if (type < 4 && this.type != type) {
            int oldValue = this.type;
            this.type = type;
            this.conditionalFlag = type >= 2;
            this.staticFlag = type == 1 || type == 3;
            this.fireBreakpointChanged(this, TYPE_CHANGED_PROPERTY, new Integer(oldValue), new Integer(this.id));
        }
    }

    public int getType() {
        int s = this.staticFlag ? 1 : 0;
        int c = this.conditionalFlag ? 2 : 0;
        this.type = s + c;
        return this.type;
    }

    public void setLifeTime(int lifetime) {
        if ((lifetime == 1 || lifetime == 2) && this.lifetime != lifetime) {
            int oldValue = lifetime;
            this.lifetime = lifetime;
            this.fireBreakpointChanged(this, LIFETIME_CHANGED_PROPERTY, new Integer(oldValue), new Integer(this.id));
        }
    }

    public int getLifeTime() {
        return this.lifetime;
    }

    public void setExpression(String expression) {
        if (!this.expression.equals(expression)) {
            String oldValue = this.expression;
            this.expression = expression;
            if (!expression.equals("")) {
                this.setConditionalFlag(true);
            } else {
                this.setConditionalFlag(false);
            }
            this.fireBreakpointChanged(this, EXPRESSION_CHANGED_PROPERTY, oldValue, expression);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setEnable(boolean enable) {
        if (this.enable != enable) {
            boolean oldValue = this.enable;
            this.enable = enable;
            this.fireBreakpointChanged(this, ENABLE_CHANGED_PROPERTY, new Boolean(oldValue), new Boolean(enable));
        }
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String toString() {
        return "id: " + this.id + " type: " + this.type + "  file name: " + this.getFileName() + " line: " + this.getLineNumber();
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj == null || !(obj instanceof Breakpoint)) {
            return false;
        }
        Breakpoint other = (Breakpoint)obj;
        return this.id == other.id && this.type == other.type && this.lifetime == other.lifetime && this.fileName.equals(other.getFileName()) && this.lineNumber == other.getLineNumber();
    }

    protected void fireBreakpointChanged(Breakpoint breakpoint, String property, Object oldValue, Object newValue) {
        if (this.listeners != null) {
            for (BreakpointListener curr : this.listeners) {
                curr.breakpointChanged(breakpoint, property, oldValue, newValue);
            }
        }
    }

    public int compareTo(Object o) {
        if (!(o instanceof Breakpoint)) {
            return -1;
        }
        Breakpoint other = (Breakpoint)o;
        int rv = this.fileName.compareTo(other.getFileName());
        if (rv == 0) {
            rv = this.lineNumber - other.getLineNumber();
        }
        return rv;
    }

    public Object clone() {
        try {
            Breakpoint ble = (Breakpoint)super.clone();
            ble.listeners = null;
            return ble;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static interface BreakpointListener {
        public void breakpointChanged(Breakpoint var1, String var2, Object var3, Object var4);
    }
}

