/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.zend.debugger;

import org2.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org2.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;

public class DefaultExpression
implements Expression {
    private String[] name;
    private String fullName;
    private ExpressionValue expressionValue;

    public DefaultExpression(String expression) {
        this.name = new String[]{expression.trim()};
        this.fullName = expression;
        this.setValue(null);
    }

    @Override
    public String[] getName() {
        return this.name;
    }

    @Override
    public String getLastName() {
        return this.name[this.name.length - 1];
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public void setValue(ExpressionValue value) {
        if (value == null) {
            value = ExpressionValue.NULL_VALUE;
        }
        this.expressionValue = value;
    }

    @Override
    public ExpressionValue getValue() {
        return this.expressionValue;
    }

    public String toString() {
        return String.valueOf(this.getLastName()) + " = " + this.getValue().getValueAsString();
    }

    @Override
    public Expression createChildExpression(String endName, String endRepresentation) {
        return new DefaultExpression(this, endName, endRepresentation);
    }

    protected DefaultExpression(Expression parent, String name, String representation) {
        String[] parentName = parent.getName();
        this.name = new String[parentName.length + 1];
        System.arraycopy(parentName, 0, this.name, 0, parentName.length);
        this.name[parentName.length] = name;
        this.fullName = String.valueOf(parent.getFullName()) + representation;
        this.setValue(null);
    }
}

