/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.zend.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org2.eclipse.php.internal.debug.core.Logger;
import org2.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org2.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org2.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org2.eclipse.php.internal.debug.core.zend.debugger.IRemoteDebugger;
import org2.eclipse.php.internal.debug.core.zend.debugger.PHPstack;
import org2.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org2.eclipse.php.internal.debug.core.zend.debugger.StackLayer;
import org2.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org2.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;
import org2.eclipse.php.internal.debug.core.zend.model.PHPThread;
import org2.eclipse.php.internal.debug.core.zend.model.PHPVariable;
import org2.eclipse.php.internal.debug.core.zend.model.ResolveBlackList;

public class ContextManager {
    private PHPDebugTarget fTarget;
    private IRemoteDebugger fDebugger;
    private StackLayer[] fPreviousLayers;
    private IStackFrame[] fPreviousFrames;
    private ILock fFramesInitLock = Job.getJobManager().newLock();
    private Map<String, IVariable[]> fVariables = new HashMap<String, IVariable[]>();
    private int fSuspendCount;
    private static final String DUMMY_PHP_FILE = "dummy.php";

    public ContextManager(PHPDebugTarget target, IRemoteDebugger debugger) {
        this.fTarget = target;
        this.fSuspendCount = target.getSuspendCount();
        this.fDebugger = debugger;
    }

    public void addToResolveBlacklist(VirtualPath path, ResolveBlackList.Type type) {
        ResolveBlackList.getInstance().add(this.fDebugger.getDebugHandler().getDebugTarget().getLaunch(), path, type);
    }

    public boolean isResolveBlacklisted(String remoteFile) {
        return ResolveBlackList.getInstance().containsEntry(this.fDebugger.getDebugHandler().getDebugTarget().getLaunch(), remoteFile);
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        PHPstack stack = this.fDebugger.getCallStack();
        PHPThread thread = (PHPThread)this.fTarget.getThreads()[0];
        StackLayer[] layers = stack.getLayers();
        this.fFramesInitLock.acquire();
        try {
            if (this.fPreviousFrames == null) {
                this.fPreviousFrames = this.applyDebugFilters(this.createNewFrames(layers, thread));
                DefaultExpressionsManager expressionsManager = this.fTarget.getExpressionManager();
                if (expressionsManager != null) {
                    expressionsManager.clear();
                }
                this.fVariables.clear();
                IVariable[] variables = this.createVariables();
                IStackFrame[] iStackFrameArray = this.fPreviousFrames;
                int n = this.fPreviousFrames.length;
                int n2 = 0;
                while (n2 < n) {
                    IStackFrame frame = iStackFrameArray[n2];
                    this.fVariables.put(((PHPStackFrame)frame).createUID(), variables);
                    ++n2;
                }
                this.fSuspendCount = this.fTarget.getSuspendCount();
                IStackFrame[] iStackFrameArray2 = this.fPreviousFrames;
                return iStackFrameArray2;
            }
        }
        finally {
            this.fFramesInitLock.release();
        }
        if (this.fSuspendCount == this.fTarget.getSuspendCount()) {
            return this.fPreviousFrames;
        }
        this.fSuspendCount = this.fTarget.getSuspendCount();
        boolean layersSame = this.compareLayers(layers, this.fPreviousLayers);
        if (layersSame) {
            PHPStackFrame originalFrame = (PHPStackFrame)this.fPreviousFrames[0];
            int topID = originalFrame.getIdentifier();
            String fileName = originalFrame.getAbsoluteFileName();
            String sourceFile = originalFrame.getSourceName();
            this.fPreviousFrames[0] = new PHPStackFrame(thread, fileName, layers.length == 1 ? "" : this.fPreviousFrames[1].getName(), this.fTarget.getLastStop(), topID, sourceFile);
            this.fVariables.put(((PHPStackFrame)this.fPreviousFrames[0]).createUID(), this.createVariables());
        } else if (layers.length == 1 && layers[0].getCalledFileName().endsWith(DUMMY_PHP_FILE)) {
            this.fDebugger.finish();
        } else {
            this.fPreviousFrames = this.applyDebugFilters(this.createNewFrames(layers, thread));
            IVariable[] variables = null;
            IStackFrame[] iStackFrameArray = this.fPreviousFrames;
            int n = this.fPreviousFrames.length;
            int n3 = 0;
            while (n3 < n) {
                IStackFrame frame = iStackFrameArray[n3];
                String frameUID = ((PHPStackFrame)frame).createUID();
                if (!this.fVariables.containsKey(frameUID)) {
                    if (variables == null) {
                        variables = this.createVariables();
                    }
                    this.fVariables.put(frameUID, variables);
                }
                ++n3;
            }
            this.fSuspendCount = this.fTarget.getSuspendCount();
        }
        return this.fPreviousFrames;
    }

    private IStackFrame[] applyDebugFilters(IStackFrame[] previousFrames) {
        ArrayList<IStackFrame> tempStackFrames = new ArrayList<IStackFrame>();
        int i = 0;
        while (i < previousFrames.length) {
            String stackFrameName;
            if (i != previousFrames.length - 1 || !(stackFrameName = ((PHPStackFrame)previousFrames[i]).getAbsoluteFileName()).endsWith(DUMMY_PHP_FILE)) {
                tempStackFrames.add(previousFrames[i]);
            }
            ++i;
        }
        IStackFrame[] result = new IStackFrame[tempStackFrames.size()];
        tempStackFrames.toArray(result);
        return result;
    }

    public IVariable[] getVariables(PHPStackFrame stackFrame) {
        if (stackFrame == null) {
            return this.createVariables();
        }
        IVariable[] variables = this.fVariables.get(stackFrame.createUID());
        return variables == null ? new IVariable[]{} : variables;
    }

    public Expression[] getStackVariables(PHPStackFrame stack) {
        String functionName = "";
        try {
            functionName = stack.getName();
        }
        catch (DebugException e) {
            Logger.logException("Problem getting name from stack", e);
        }
        Expression[] variables = new Expression[]{};
        if (!functionName.equals("")) {
            StackLayer stackLayer = null;
            try {
                int i = this.fPreviousLayers.length - 1;
                while (i >= 0) {
                    StackLayer element = this.fPreviousLayers[i];
                    if (element.getCalledFileName().equals(stack.getAbsoluteFileName()) && element.getCalledFunctionName().equals(stack.getName())) {
                        stackLayer = element;
                        break;
                    }
                    --i;
                }
            }
            catch (DebugException debugException) {}
            if (stackLayer != null) {
                variables = stackLayer.getVariables();
            }
        }
        return variables;
    }

    private boolean compareLayers(StackLayer[] layers, StackLayer[] prevLayers) {
        if (layers.length != prevLayers.length) {
            return false;
        }
        int i = 0;
        while (i < layers.length) {
            if (!this.compareLayer(layers[i], prevLayers[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean compareLayer(StackLayer layer, StackLayer prevLayer) {
        return layer.getCallerFileName().equals(prevLayer.getCallerFileName()) && layer.getCallerFunctionName().equals(prevLayer.getCallerFunctionName()) && layer.getCallerLineNumber() == prevLayer.getCallerLineNumber() && layer.getCalledFileName().equals(prevLayer.getCalledFileName()) && layer.getCalledFunctionName().equals(prevLayer.getCalledFunctionName()) && layer.getCalledLineNumber() == prevLayer.getCalledLineNumber();
    }

    private IStackFrame[] createNewFrames(StackLayer[] layers, PHPThread thread) throws DebugException {
        RemoteDebugger remoteDebugger = (RemoteDebugger)this.fDebugger;
        String cwd = remoteDebugger.getCurrentWorkingDirectory();
        String currentScript = null;
        IStackFrame[] frames = new IStackFrame[(layers.length - 1) * 2 + 1];
        int frameCt = (layers.length - 1) * 2 + 1;
        int i = 1;
        while (i < layers.length) {
            String sName = layers[i].getCallerFileName();
            String rName = remoteDebugger.convertToLocalFilename(sName, cwd, frameCt < frames.length ? ((PHPStackFrame)frames[frameCt]).getSourceName() : null);
            if (rName == null) {
                rName = sName;
            }
            frames[frameCt - 1] = new PHPStackFrame(thread, sName, layers[i].getCallerFunctionName(), layers[i].getCallerLineNumber() + 1, frameCt, rName);
            --frameCt;
            sName = layers[i].getCalledFileName();
            rName = remoteDebugger.convertToLocalFilename(sName, cwd, rName);
            if (rName == null) {
                rName = sName;
            }
            frames[frameCt - 1] = new PHPStackFrame(thread, sName, layers[i].getCalledFunctionName(), layers[i].getCalledLineNumber() + 1, frameCt, layers[i], rName);
            --frameCt;
            if (!layers[i].getCalledFileName().equals(this.fTarget.getLastFileName())) {
                currentScript = rName;
            }
            ++i;
        }
        String resolvedFile = remoteDebugger.convertToLocalFilename(this.fTarget.getLastFileName(), cwd, currentScript);
        if (resolvedFile == null) {
            resolvedFile = this.fTarget.getLastFileName();
        }
        frames[0] = new PHPStackFrame(thread, this.fTarget.getLastFileName(), layers.length == 1 ? "" : frames[1].getName(), this.fTarget.getLastStop(), frameCt, resolvedFile);
        this.fPreviousLayers = layers;
        return frames;
    }

    private IVariable[] createVariables() {
        DefaultExpressionsManager expressionsManager = this.fTarget.getExpressionManager();
        if (expressionsManager == null) {
            return new IVariable[0];
        }
        Expression[] localVariables = expressionsManager.getLocalVariables(1);
        IVariable[] variables = new PHPVariable[localVariables.length];
        int i = 0;
        while (i < localVariables.length) {
            variables[i] = new PHPVariable(this.fTarget, localVariables[i]);
            ++i;
        }
        return variables;
    }

    public IRemoteDebugger getRemoteDebugger() {
        return this.fDebugger;
    }
}

