/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.zend.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org2.eclipse.php.internal.debug.core.pathmapper.VirtualPath;

public class ResolveBlackList
implements ILaunchesListener {
    private static Map<ILaunch, Map<VirtualPath, Type>> blackListMap;
    private static ResolveBlackList instance;

    static {
        instance = new ResolveBlackList();
    }

    private ResolveBlackList() {
        blackListMap = new HashMap<ILaunch, Map<VirtualPath, Type>>();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public static ResolveBlackList getInstance() {
        return instance;
    }

    private static Map<VirtualPath, Type> getByLaunch(ILaunch launch) {
        if (!blackListMap.containsKey(launch)) {
            blackListMap.put(launch, new HashMap());
        }
        return blackListMap.get(launch);
    }

    public void add(ILaunch launch, VirtualPath path, Type type) {
        ResolveBlackList.getByLaunch(launch).put(path, type);
    }

    public boolean containsEntry(ILaunch launch, String file) {
        if (!VirtualPath.isAbsolute(file)) {
            return false;
        }
        Map<VirtualPath, Type> map = ResolveBlackList.getByLaunch(launch);
        for (VirtualPath path : map.keySet()) {
            VirtualPath tmp = new VirtualPath(file);
            Type type = map.get(path);
            if (type == Type.FILE) {
                if (!path.equals(tmp)) continue;
                return true;
            }
            if (type == Type.FOLDER) {
                tmp.removeLastSegment();
                if (!path.equals(tmp)) continue;
                return true;
            }
            if (type != Type.RECURSIVE || !path.isPrefixOf(tmp)) continue;
            return true;
        }
        return false;
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch l = iLaunchArray[n2];
            blackListMap.remove(l);
            ++n2;
        }
    }

    public static enum Type {
        FILE,
        FOLDER,
        RECURSIVE;

    }
}

