/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.pathmapper;

import com.aptana.editor.php.internal.ui.PHPPluginImages;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org2.eclipse.php.debug.core.debugger.pathmapper.PathMapper;
import org2.eclipse.php.internal.core.project.IIncludePathEntry;
import org2.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org2.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org2.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org2.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org2.eclipse.php.internal.ui.util.PixelConverter;
import org2.eclipse.php.util.StatusInfo;

public class PathMapperEntryDialog
extends StatusDialog {
    private PathMapper.Mapping fEditData;
    private Text fServerPathText;
    private Text fWorkspacePathText;
    private Button fWorkspacePathBrowseBtn;

    public PathMapperEntryDialog(Shell parent) {
        this(parent, null);
        this.setResizable(parent);
    }

    public PathMapperEntryDialog(Shell parent, PathMapper.Mapping editData) {
        super(parent);
        this.setResizable(parent);
        if (editData != null) {
            this.fEditData = editData.clone();
            this.setTitle("Edit Path Mapping");
        } else {
            this.setTitle("Add new Path Mapping");
        }
        this.setHelpAvailable(false);
    }

    public PathMapper.Mapping getResult() {
        return this.fEditData;
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText("Path on &Server:");
        this.fServerPathText = new Text(composite, 2048);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PathMapperEntryDialog.this.validate();
            }
        };
        this.fServerPathText.addModifyListener(modifyListener);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.fServerPathText.setLayoutData((Object)layoutData);
        this.addExampleText(composite, "e.g. '/', '/public' etc.");
        label = new Label(composite, 0);
        label.setText("Path in &Workspace");
        this.fWorkspacePathText = new Text(composite, 2048);
        layoutData = new GridData(768);
        this.fWorkspacePathText.setLayoutData((Object)layoutData);
        this.fWorkspacePathText.addModifyListener(modifyListener);
        this.fWorkspacePathBrowseBtn = new Button(composite, 0);
        this.fWorkspacePathBrowseBtn.setText("&Workspace...");
        this.fWorkspacePathBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceBrowseDialog dialog = new WorkspaceBrowseDialog(PathMapperEntryDialog.this.getShell());
                if (dialog.open() == 0) {
                    Object selectedElement = dialog.getSelectedElement();
                    PathMapperEntryDialog.this.fWorkspacePathText.setData(null);
                    if (selectedElement instanceof IResource) {
                        IResource resource = (IResource)selectedElement;
                        PathMapperEntryDialog.this.fWorkspacePathText.setData((Object)PathEntry.Type.WORKSPACE);
                        PathMapperEntryDialog.this.fWorkspacePathText.setText(resource.getFullPath().toString());
                    } else if (selectedElement instanceof IIncludePathEntry) {
                        IIncludePathEntry includePathEntry = (IIncludePathEntry)selectedElement;
                        PathMapperEntryDialog.this.fWorkspacePathText.setData((Object)(includePathEntry.getEntryKind() == 4 ? PathEntry.Type.INCLUDE_VAR : PathEntry.Type.INCLUDE_FOLDER));
                        if (includePathEntry.getEntryKind() == 4) {
                            IPath incPath = IncludePathVariableManager.instance().resolveVariablePath(includePathEntry.getPath().toString());
                            if (incPath != null) {
                                PathMapperEntryDialog.this.fWorkspacePathText.setText(incPath.toOSString());
                            }
                        } else {
                            PathMapperEntryDialog.this.fWorkspacePathText.setText(includePathEntry.getPath().toOSString());
                        }
                    } else if (selectedElement instanceof WorkspaceBrowseDialog.IPFile) {
                        WorkspaceBrowseDialog.IPFile ipFile = (WorkspaceBrowseDialog.IPFile)selectedElement;
                        IIncludePathEntry includePathEntry = ipFile.includePathEntry;
                        PathMapperEntryDialog.this.fWorkspacePathText.setData((Object)(includePathEntry.getEntryKind() == 4 ? PathEntry.Type.INCLUDE_VAR : PathEntry.Type.INCLUDE_FOLDER));
                        PathMapperEntryDialog.this.fWorkspacePathText.setText(ipFile.file.getAbsolutePath());
                    }
                }
            }
        });
        PathMapperEntryDialog.applyDialogFont((Control)composite);
        this.initializeValues();
        return parent;
    }

    private void setResizable(Shell parent) {
        int style = 16;
        if (parent != null) {
            style |= parent.getStyle();
        }
        this.setShellStyle(style);
    }

    protected void addExampleText(Composite parent, String text) {
        new Label(parent, 0);
        Label banner = new Label(parent, 0);
        banner.setText(text);
        Font defaultFont = JFaceResources.getTextFont();
        final Font smallFont = new Font((Device)banner.getDisplay(), defaultFont.getFontData()[0].getName(), 8, 0);
        banner.setFont(smallFont);
        banner.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                smallFont.dispose();
            }
        });
        GridData gds = new GridData(768);
        gds.horizontalSpan = 2;
        gds.verticalIndent = -2;
        gds.verticalAlignment = 128;
        banner.setLayoutData((Object)gds);
    }

    protected void initializeValues() {
        if (this.fEditData != null) {
            this.fServerPathText.setText(this.fEditData.remotePath.toString());
            this.fWorkspacePathText.setData((Object)this.fEditData.type);
            this.fWorkspacePathText.setText(this.fEditData.localPath.toString());
        }
    }

    protected void setError(String error) {
        this.updateStatus((IStatus)new StatusInfo(4, error));
    }

    protected void validate() {
        PathMapper.Mapping mapping = new PathMapper.Mapping();
        String remotePathStr = this.fServerPathText.getText().trim();
        if (remotePathStr.length() == 0) {
            this.setError("Path on server must not be empty!");
            return;
        }
        try {
            mapping.remotePath = new VirtualPath(remotePathStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setError("Path on server is illegal or not absolute!");
            return;
        }
        String workspacePath = this.fWorkspacePathText.getText().trim();
        if (workspacePath.length() == 0) {
            this.setError("Path in workspace must not be empty!");
            return;
        }
        boolean pathExistsInWorkspace = false;
        mapping.type = (PathEntry.Type)((Object)this.fWorkspacePathText.getData());
        if (mapping.type == PathEntry.Type.INCLUDE_FOLDER || mapping.type == PathEntry.Type.INCLUDE_VAR) {
            pathExistsInWorkspace = new File(workspacePath).exists();
        } else {
            boolean bl = pathExistsInWorkspace = ResourcesPlugin.getWorkspace().getRoot().findMember(workspacePath) != null;
        }
        if (!pathExistsInWorkspace) {
            this.setError(NLS.bind((String)"Path ''{0}'' doesn't exist in workspace!", (Object)workspacePath));
            return;
        }
        try {
            mapping.localPath = new VirtualPath(workspacePath);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setError("Path in workspace is illegal or not absolute!");
            return;
        }
        this.fEditData = mapping;
        this.updateStatus(Status.OK_STATUS);
    }

    class WorkspaceBrowseDialog
    extends StatusDialog {
        private TreeViewer fViewer;
        private Object selectedElement;

        public WorkspaceBrowseDialog(Shell parent) {
            super(parent);
            this.setTitle("Select Workspace Resource");
        }

        public Object getSelectedElement() {
            return this.selectedElement;
        }

        protected Control createDialogArea(Composite parent) {
            parent = (Composite)super.createDialogArea(parent);
            parent.setLayoutData((Object)new GridData(1808));
            PixelConverter pixelConverter = new PixelConverter((Control)parent);
            this.fViewer = new TreeViewer(parent, 2820);
            GridData layoutData = new GridData(1808);
            layoutData.widthHint = pixelConverter.convertWidthInCharsToPixels(70);
            layoutData.heightHint = pixelConverter.convertHeightInCharsToPixels(20);
            this.fViewer.getControl().setLayoutData((Object)layoutData);
            this.fViewer.setContentProvider((IContentProvider)new ContentProvider());
            this.fViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    WorkspaceBrowseDialog.this.validate();
                }
            });
            this.fViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    WorkspaceBrowseDialog.this.okPressed();
                }
            });
            return parent;
        }

        protected void validate() {
            IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
            Object element = selection.getFirstElement();
            if (element == null) {
                this.updateStatus((IStatus)new StatusInfo(4, ""));
                return;
            }
            this.selectedElement = element;
            this.updateStatus(Status.OK_STATUS);
        }

        class ContentProvider
        implements ITreeContentProvider {
            ContentProvider() {
            }

            public Object[] getChildren(Object parentElement) {
                try {
                    if (parentElement instanceof IContainer) {
                        IProject project;
                        PHPProjectOptions options;
                        IResource[] members;
                        LinkedList<Object> r = new LinkedList<Object>();
                        IContainer container = (IContainer)parentElement;
                        IResource[] iResourceArray = members = container.members();
                        int n = members.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource member = iResourceArray[n2];
                            if (member instanceof IContainer && member.isAccessible()) {
                                if (member instanceof IProject) {
                                    IProject project2 = (IProject)member;
                                    if (project2.hasNature("com.aptana.editor.php.phpNature")) {
                                        r.add(member);
                                    }
                                } else {
                                    r.add(member);
                                }
                            }
                            ++n2;
                        }
                        if (parentElement instanceof IProject && (options = PHPProjectOptions.forProject((IProject)(project = (IProject)parentElement))) != null) {
                            IIncludePathEntry[] includePath = options.readRawIncludePath();
                            r.addAll(Arrays.asList(includePath));
                        }
                        return r.toArray();
                    }
                    if (parentElement instanceof IIncludePathEntry) {
                        IIncludePathEntry includePathEntry = (IIncludePathEntry)parentElement;
                        IPath path = includePathEntry.getPath();
                        File file = null;
                        if (includePathEntry.getEntryKind() == 1) {
                            file = path.toFile();
                        } else if (includePathEntry.getEntryKind() == 4 && (path = IncludePathVariableManager.instance().resolveVariablePath(path.toString())) != null) {
                            file = path.toFile();
                        }
                        if (file != null) {
                            return this.getChildren(new IPFile(includePathEntry, file));
                        }
                    } else if (parentElement instanceof IPFile) {
                        IPFile ipFile = (IPFile)parentElement;
                        File file = ipFile.file;
                        if (file.isDirectory()) {
                            File[] dirs = file.listFiles(new FileFilter(){

                                @Override
                                public boolean accept(File pathname) {
                                    return pathname.isDirectory();
                                }
                            });
                            ArrayList<IPFile> r = new ArrayList<IPFile>(dirs.length);
                            File[] fileArray = dirs;
                            int n = dirs.length;
                            int n3 = 0;
                            while (n3 < n) {
                                File dir = fileArray[n3];
                                r.add(new IPFile(ipFile.includePathEntry, dir));
                                ++n3;
                            }
                            return r.toArray();
                        }
                    }
                }
                catch (CoreException coreException) {}
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof IResource) {
                    return ((IResource)element).getParent();
                }
                if (element instanceof IPFile) {
                    IPFile ipFile = (IPFile)element;
                    return new IPFile(ipFile.includePathEntry, ipFile.file.getParentFile());
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        class IPFile {
            IIncludePathEntry includePathEntry;
            File file;

            IPFile(IIncludePathEntry includePathEntry, File file) {
                this.includePathEntry = includePathEntry;
                this.file = file;
            }

            public int hashCode() {
                return this.file.hashCode() + 13 * this.includePathEntry.hashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof IPFile)) {
                    return false;
                }
                IPFile other = (IPFile)obj;
                return other.file.equals(this.file) && other.includePathEntry.equals(this.includePathEntry);
            }
        }

        class LabelProvider
        implements ILabelProvider {
            private WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();

            public Image getImage(Object element) {
                if (element instanceof IIncludePathEntry) {
                    IIncludePathEntry includePathEntry = (IIncludePathEntry)element;
                    if (includePathEntry.getEntryKind() == 4) {
                        return PHPPluginImages.get((String)"com.aptana.editor.php.epl.envvar_obj.gif");
                    }
                    return PHPPluginImages.get((String)"com.aptana.editor.php.epl.library_obj.gif");
                }
                if (element instanceof IPFile) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                return this.workbenchLabelProvider.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof IIncludePathEntry) {
                    IIncludePathEntry includePathEntry = (IIncludePathEntry)element;
                    return includePathEntry.getPath().toOSString();
                }
                if (element instanceof IPFile) {
                    return ((IPFile)element).file.getName();
                }
                return this.workbenchLabelProvider.getText(element);
            }

            public void addListener(ILabelProviderListener listener) {
                this.workbenchLabelProvider.addListener(listener);
            }

            public void dispose() {
                this.workbenchLabelProvider.dispose();
            }

            public boolean isLabelProperty(Object element, String property) {
                return this.workbenchLabelProvider.isLabelProperty(element, property);
            }

            public void removeListener(ILabelProviderListener listener) {
                this.workbenchLabelProvider.removeListener(listener);
            }
        }
    }
}

