/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.pathmapper;

import com.aptana.editor.php.internal.ui.PHPPluginImages;
import com.aptana.editor.php.internal.ui.wizard.field.IListAdapter;
import com.aptana.ui.util.StatusLineMessageTimerManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org2.eclipse.php.debug.core.debugger.pathmapper.PathMapper;
import org2.eclipse.php.internal.core.util.ScrolledCompositeImpl;
import org2.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org2.eclipse.php.internal.debug.ui.pathmapper.PathMapperEntryDialog;
import org2.eclipse.php.internal.ui.wizard.field.ListDialogField;

public class PathMappingComposite
extends Composite {
    public static final int IDX_ADD = 0;
    public static final int IDX_EDIT = 1;
    public static final int IDX_REMOVE = 2;
    private static final String[] buttonLabels = new String[]{"&Add", "&Edit", "&Remove"};
    private static final String[] columnHeaders = new String[]{"Path on server", "Local path"};
    private static final ColumnLayoutData[] columnLayoutDatas = new ColumnLayoutData[]{new ColumnWeightData(50), new ColumnWeightData(50)};
    private List<IPropertyListener> listeners = new ArrayList<IPropertyListener>(3);
    private ListDialogField fMapList;
    private boolean serverIsValid;
    private final boolean isForEdit;

    public PathMappingComposite(Composite parent, int style) {
        this(parent, style, true);
    }

    public PathMappingComposite(Composite parent, int style, boolean isForEdit) {
        super(parent, style);
        this.isForEdit = isForEdit;
        this.initializeControls();
    }

    protected void initializeControls() {
        this.fMapList = new ListDialogField((IListAdapter)new ListAdapter(), (String[])(this.isForEdit ? buttonLabels : null), (ILabelProvider)new LabelProvider());
        this.fMapList.setTableColumns(new ListDialogField.ColumnsDescription(columnLayoutDatas, columnHeaders, true));
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        PixelConverter conv = new PixelConverter((Control)this);
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl((Composite)this, 768);
        scrolledCompositeImpl.setLayout((Layout)layout);
        scrolledCompositeImpl.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite((Composite)scrolledCompositeImpl, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        scrolledCompositeImpl.setContent((Control)composite);
        scrolledCompositeImpl.setFont(this.getFont());
        GridData data = new GridData(1808);
        data.widthHint = conv.convertWidthInCharsToPixels(50);
        Control listControl = this.fMapList.getListControl(composite);
        listControl.setLayoutData((Object)data);
        Composite buttonsControl = this.fMapList.getButtonBox(composite);
        buttonsControl.setLayoutData((Object)new GridData(258));
        Point size = composite.computeSize(-1, -1);
        scrolledCompositeImpl.setMinSize(size.x, size.y);
        if (!this.isForEdit) {
            Table table = this.fMapList.getTableViewer().getTable();
            table.setBackground(this.getDisplay().getSystemColor(19));
            table.setLinesVisible(true);
            table.setForeground(this.getDisplay().getSystemColor(16));
            table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    Display.getDefault().beep();
                    StatusLineMessageTimerManager.setErrorMessage((String)"Please click link above to edit the path mapping", (long)3000L, (boolean)true);
                }
            });
        }
        this.updateButtonsEnablement();
    }

    public void addPropertyChangeListener(IPropertyListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePropertyChangeListener(IPropertyListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyPropertyChanged(int propertyID) {
        IPropertyListener[] fireAt;
        IPropertyListener[] iPropertyListenerArray = fireAt = this.listeners.toArray(new IPropertyListener[this.listeners.size()]);
        int n = fireAt.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyListener listener = iPropertyListenerArray[n2];
            listener.propertyChanged((Object)this, propertyID);
            ++n2;
        }
    }

    protected void handleAdd() {
        PathMapperEntryDialog dialog = new PathMapperEntryDialog(this.getShell());
        if (dialog.open() == 0) {
            PathMapper.Mapping mapping = dialog.getResult();
            this.fMapList.addElement((Object)mapping);
            this.notifyPropertyChanged(0);
        }
    }

    protected void handleEdit() {
        List l = this.fMapList.getSelectedElements();
        if (l.size() == 1) {
            PathMapper.Mapping newElement;
            PathMapper.Mapping oldElement = (PathMapper.Mapping)l.get(0);
            PathMapperEntryDialog dialog = new PathMapperEntryDialog(this.getShell(), oldElement);
            if (dialog.open() == 0 && !oldElement.equals(newElement = dialog.getResult())) {
                this.fMapList.replaceElement((Object)oldElement, (Object)newElement);
                this.notifyPropertyChanged(1);
            }
        }
    }

    protected void handleRemove() {
        this.fMapList.removeElements(this.fMapList.getSelectedElements());
        this.notifyPropertyChanged(2);
    }

    public void setData(Object data) {
        PathMapper.Mapping[] mappings = null;
        if (data == null) {
            mappings = new PathMapper.Mapping[]{};
        } else {
            if (!(data instanceof PathMapper.Mapping[])) {
                throw new IllegalArgumentException("Data must be instance of Mapping[]");
            }
            mappings = (PathMapper.Mapping[])data;
        }
        this.fMapList.setElements(Arrays.asList(mappings));
        this.updateButtonsEnablement();
    }

    public PathMapper.Mapping[] getMappings() {
        List l = this.fMapList.getElements();
        return l.toArray(new PathMapper.Mapping[l.size()]);
    }

    public void setServerIsValid(boolean serverIsValid) {
        this.serverIsValid = serverIsValid;
    }

    protected void updateButtonsEnablement() {
        List selectedElements = this.fMapList.getSelectedElements();
        this.fMapList.enableButton(0, this.serverIsValid);
        this.fMapList.enableButton(1, this.serverIsValid && selectedElements.size() == 1);
        this.fMapList.enableButton(2, this.serverIsValid && selectedElements.size() > 0);
    }

    class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider
    implements ITableLabelProvider {
        LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 1) {
                PathMapper.Mapping mapping = (PathMapper.Mapping)element;
                if (mapping.type == PathEntry.Type.EXTERNAL) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                if (mapping.type == PathEntry.Type.INCLUDE_VAR) {
                    return PHPPluginImages.get((String)"com.aptana.editor.php.epl.envvar_obj.gif");
                }
                if (mapping.type == PathEntry.Type.INCLUDE_FOLDER) {
                    return PHPPluginImages.get((String)"com.aptana.editor.php.epl.library_obj.gif");
                }
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(mapping.localPath.toString());
                if (resource != null) {
                    return WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider().getImage((Object)resource);
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            PathMapper.Mapping mapping = (PathMapper.Mapping)element;
            switch (columnIndex) {
                case 0: {
                    return mapping.remotePath.toString();
                }
                case 1: {
                    return mapping.localPath.toString();
                }
            }
            return null;
        }
    }

    class ListAdapter
    implements IListAdapter {
        ListAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            switch (index) {
                case 0: {
                    PathMappingComposite.this.handleAdd();
                    break;
                }
                case 1: {
                    PathMappingComposite.this.handleEdit();
                    break;
                }
                case 2: {
                    PathMappingComposite.this.handleRemove();
                }
            }
        }

        public void doubleClicked(ListDialogField field) {
            if (PathMappingComposite.this.isForEdit) {
                PathMappingComposite.this.handleEdit();
            }
        }

        public void selectionChanged(ListDialogField field) {
            PathMappingComposite.this.updateButtonsEnablement();
        }
    }
}

