/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.preferences;

import com.aptana.editor.php.util.ScrolledPageContent;
import com.aptana.php.debug.core.preferences.PHPDebugPreferencesUtil;
import com.aptana.php.debug.core.server.PHPServersManager;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import com.aptana.webserver.core.IServer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.osgi.service.prefs.BackingStoreException;
import org2.eclipse.php.internal.debug.core.interpreter.preferences.PHPexeItem;
import org2.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org2.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org2.eclipse.php.internal.debug.core.preferences.PHPexes;
import org2.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org2.eclipse.php.internal.debug.ui.preferences.AbstractPHPPreferencePageBlock;

public class PHPDebugPreferencesAddon
extends AbstractPHPPreferencePageBlock {
    private static final String SERVERS_PAGE_ID = "org2.eclipse.php.server.internal.ui.PHPServersPreferencePage";
    private static final String PHP_EXE_PAGE_ID = "org2.eclipse.php.debug.ui.preferencesphps.PHPsPreferencePage";
    private Button fStopAtFirstLine;
    private Text fClientIP;
    private Label fClientIPLabel;
    private Combo fDefaultDebugger;
    private Combo fDefaultServer;
    private Combo fDefaultPHPExe;
    private Collection<String> debuggersIds;
    private PreferencePage propertyPage;
    private ExpandableComposite expandbleDebugEncoding;
    private ExpandableComposite expandbleOutputEncoding;

    public void setCompositeAddon(Composite parent) {
        Composite composite = this.addPageContents(parent);
        this.addProjectPreferenceSubsection(this.createSubsection(composite, PHPDebugUIMessages.PhpDebugPreferencePage_6));
    }

    public void initializeValues(PreferencePage propertyPage) {
        String projectServerName;
        IEclipsePreferences node;
        this.propertyPage = propertyPage;
        IScopeContext[] preferenceScopes = this.createPreferenceScopes(propertyPage);
        boolean stopAtFirstLine = PHPDebugPreferencesUtil.getBoolean("com.aptana.php.debug.eplstop_at_first_line_string", true);
        String debuggerName = PHPDebuggersRegistry.getDebuggerName(PHPDebugPreferencesUtil.getString("com.aptana.php.debug.php_debugger_id", "org2.eclipse.php.debug.core.xdebugDebugger"));
        String serverName = PHPServersManager.getDefaultServer(null).getName();
        PHPexes exes = PHPexes.getInstance();
        String phpExeName = PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined;
        if (exes.hasItems(PHPDebugEPLPlugin.getCurrentDebuggerId())) {
            phpExeName = exes.getDefaultItem(PHPDebugEPLPlugin.getCurrentDebuggerId()).getName();
        }
        PHPDebugPreferencesUtil.getString("com.aptana.php.debug.epltransfer_encoding", "UTF-8");
        PHPDebugPreferencesUtil.getString("com.aptana.php.debug.eploutput_encoding", "UTF-8");
        this.loadDebuggers(this.fDefaultDebugger);
        this.loadServers(this.fDefaultServer);
        boolean exeLoaded = false;
        if (preferenceScopes[0] instanceof ProjectScope && (node = preferenceScopes[0].getNode(this.getPreferenceNodeQualifier())) != null && this.getProject(propertyPage) != null && !(projectServerName = PHPServersManager.getDefaultServer((IProject)this.getProject(propertyPage)).getName()).equals("")) {
            String debuggerId = node.get("com.aptana.php.debug.php_debugger_id", PHPDebugEPLPlugin.getCurrentDebuggerId());
            debuggerName = PHPDebuggersRegistry.getDebuggerName(debuggerId);
            serverName = projectServerName;
            stopAtFirstLine = node.getBoolean("com.aptana.php.debug.eplstop_at_first_line_string", stopAtFirstLine);
            node.get("com.aptana.php.debug.epltransfer_encoding", "");
            node.get("com.aptana.php.debug.eploutput_encoding", "");
            phpExeName = node.get("com.aptana.php.debug.epldefaultPHP", phpExeName);
            if (PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined.equals(phpExeName) && exes.hasItems(debuggerId)) {
                phpExeName = exes.getDefaultItem(debuggerId).getName();
                node.put("com.aptana.php.debug.epldefaultPHP", phpExeName);
                try {
                    node.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
            this.loadPHPExes(this.fDefaultPHPExe, exes.getItems(node.get("com.aptana.php.debug.php_debugger_id", PHPDebugEPLPlugin.getCurrentDebuggerId())));
            exeLoaded = true;
        }
        if (!exeLoaded) {
            this.loadPHPExes(this.fDefaultPHPExe, exes.getItems(PHPDebugEPLPlugin.getCurrentDebuggerId()));
        }
        this.fStopAtFirstLine.setSelection(stopAtFirstLine);
        this.fClientIP.setText(PHPDebugPreferencesUtil.getString("com.aptana.php.debug.eplclient_ip", "127.0.0.1"));
        this.fDefaultDebugger.select(this.fDefaultDebugger.indexOf(debuggerName));
        this.fDefaultServer.select(this.fDefaultServer.indexOf(serverName));
        this.fDefaultPHPExe.select(this.fDefaultPHPExe.indexOf(phpExeName));
        if (this.getProject(propertyPage) != null) {
            this.fClientIP.setVisible(false);
            this.fClientIPLabel.setVisible(false);
        }
    }

    public boolean performOK(boolean isProjectSpecific) {
        this.savePreferences(isProjectSpecific);
        return true;
    }

    public void performApply(boolean isProjectSpecific) {
        this.performOK(isProjectSpecific);
    }

    public boolean performCancel() {
        return true;
    }

    public void performDefaults() {
        IEclipsePreferences prefs = new DefaultScope().getNode("com.aptana.php.debug.epl");
        this.fStopAtFirstLine.setSelection(prefs.getBoolean("com.aptana.php.debug.eplstop_at_first_line_string", true));
        this.fClientIP.setText(prefs.get("com.aptana.php.debug.eplclient_ip", "127.0.0.1"));
        this.loadDebuggers(this.fDefaultDebugger);
        this.loadServers(this.fDefaultServer);
        this.loadPHPExes(this.fDefaultPHPExe, PHPexes.getInstance().getItems(PHPDebugEPLPlugin.getCurrentDebuggerId()));
    }

    protected String getPreferenceNodeQualifier() {
        return PHPProjectPreferences.getPreferenceNodeQualifier();
    }

    private void addProjectPreferenceSubsection(Composite composite) {
        GridData gd = (GridData)composite.getLayoutData();
        gd.heightHint = 260;
        composite.setLayoutData((Object)gd);
        this.addLabelControl(composite, PHPDebugUIMessages.PhpDebugPreferencePage_phpDebugger, "com.aptana.php.debug.php_debugger_id");
        this.fDefaultDebugger = this.addCombo(composite, 2);
        new Label(composite, 0);
        this.addLabelControl(composite, PHPDebugUIMessages.PhpDebugPreferencePage_9, "server_preferences");
        this.fDefaultServer = this.addCombo(composite, 2);
        this.addLink(composite, PHPDebugUIMessages.PhpDebugPreferencePage_serversLink, SERVERS_PAGE_ID);
        this.addLabelControl(composite, PHPDebugUIMessages.PhpDebugPreferencePage_12, "com.aptana.php.debug.epldefaultPHP");
        this.fDefaultPHPExe = this.addCombo(composite, 2);
        this.addLink(composite, PHPDebugUIMessages.PhpDebugPreferencePage_installedPHPsLink, PHP_EXE_PAGE_ID);
        ScrolledPageContent sc1 = new ScrolledPageContent(composite);
        Composite comp = sc1.getBody();
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        sc1.setLayoutData((Object)gd);
        this.expandbleDebugEncoding = this.createStyleSection(comp, PHPDebugUIMessages.PHPDebugPreferencesAddon_debugTransferEncoding, 3);
        Composite inner = new Composite((Composite)this.expandbleDebugEncoding, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(3, false));
        this.expandbleDebugEncoding.setClient((Control)inner);
        this.expandbleOutputEncoding = this.createStyleSection(comp, PHPDebugUIMessages.PHPDebugPreferencesAddon_debugOutputEncoding, 3);
        inner = new Composite((Composite)this.expandbleOutputEncoding, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(3, false));
        this.expandbleOutputEncoding.setClient((Control)inner);
        this.fStopAtFirstLine = this.addCheckBox(composite, PHPDebugUIMessages.PhpDebugPreferencePage_1, "com.aptana.php.debug.eplstop_at_first_line_string", 0);
        this.fClientIPLabel = new Label(composite, 0);
        this.fClientIPLabel.setText("Client Host/IP:");
        this.fClientIP = new Text(composite, 2048);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.fClientIP.setLayoutData((Object)layoutData);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PHPDebugPreferencesAddon.this.expandbleDebugEncoding.setExpanded(true);
                ScrolledPageContent spc = (ScrolledPageContent)FormUtil.getScrolledComposite((Control)PHPDebugPreferencesAddon.this.expandbleDebugEncoding);
                Point p = spc.getSize();
                spc.setSize(p.x, 70);
                spc.getParent().layout();
            }
        });
        this.fDefaultDebugger.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedDebugger = PHPDebugPreferencesAddon.this.getSelectedDebuggerId();
                PHPexeItem[] items = PHPexes.getInstance().getItems(selectedDebugger);
                PHPDebugPreferencesAddon.this.loadPHPExes(PHPDebugPreferencesAddon.this.fDefaultPHPExe, items);
            }
        });
    }

    private void loadPHPExes(Combo combo, PHPexeItem[] items) {
        combo.removeAll();
        if (items == null || items.length == 0) {
            combo.add(PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined);
            combo.select(0);
            return;
        }
        PHPexeItem[] pHPexeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            PHPexeItem element = pHPexeItemArray[n2];
            combo.add(element.getName());
            ++n2;
        }
        if (this.fDefaultDebugger.getItemCount() > 0) {
            String defaultItemName;
            PHPexeItem defaultItem = PHPexes.getInstance().getDefaultItem(this.getSelectedDebuggerId());
            if (defaultItem != null) {
                defaultItemName = defaultItem.getName();
            } else {
                defaultItemName = PHPDebugUIMessages.PHPDebuggersTable_notDefined;
                if (combo.indexOf(defaultItemName) == -1) {
                    combo.add(defaultItemName, 0);
                    combo.select(0);
                }
            }
            int index = combo.indexOf(defaultItemName);
            if (index > -1) {
                combo.select(index);
            } else if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        }
    }

    private void loadServers(Combo combo) {
        combo.removeAll();
        List servers = PHPServersManager.getServers();
        if (servers != null) {
            for (IServer element : servers) {
                combo.add(element.getName());
            }
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        }
    }

    private void loadDebuggers(Combo combo) {
        this.debuggersIds = PHPDebuggersRegistry.getDebuggersIds();
        String defaultDebuggerID = "org2.eclipse.php.debug.core.zendDebugger";
        combo.removeAll();
        Iterator<String> debuggers = this.debuggersIds.iterator();
        int defaultIndex = 0;
        int index = 0;
        while (debuggers.hasNext()) {
            String id = debuggers.next();
            if (defaultDebuggerID.equals(id)) {
                defaultIndex = index;
            } else {
                ++index;
            }
            String debuggerName = PHPDebuggersRegistry.getDebuggerName(id);
            combo.add(debuggerName);
        }
        if (combo.getItemCount() > 0) {
            combo.select(defaultIndex);
        }
    }

    private ExpandableComposite createStyleSection(Composite parent, String label, int nColumns) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 18);
        excomposite.setText(label);
        excomposite.setExpanded(false);
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        excomposite.setLayoutData((Object)new GridData(4, 4, true, false, nColumns, 1));
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                PHPDebugPreferencesAddon.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        return excomposite;
    }

    private void expandedStateChanged(ExpandableComposite expandable) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite((Control)expandable);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.reflow(true);
        }
    }

    private ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    private void addLink(Composite parent, String label, final String propertyPageID) {
        Link link = new Link(parent, 0);
        link.setFont(parent.getFont());
        link.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        link.setText(label);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)PHPDebugPreferencesAddon.this.propertyPage.getShell(), (String)propertyPageID, null, null);
                dialog.setBlockOnOpen(true);
                dialog.addPageChangedListener(new IPageChangedListener(){

                    public void pageChanged(PageChangedEvent event) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                String selectedDebugger = PHPDebugPreferencesAddon.this.fDefaultDebugger.getText();
                                String selectedServer = PHPDebugPreferencesAddon.this.fDefaultServer.getText();
                                String selectedPHP = PHPDebugPreferencesAddon.this.fDefaultPHPExe.getText();
                                PHPDebugPreferencesAddon.this.loadDebuggers(PHPDebugPreferencesAddon.this.fDefaultDebugger);
                                PHPDebugPreferencesAddon.this.loadServers(PHPDebugPreferencesAddon.this.fDefaultServer);
                                PHPDebugPreferencesAddon.this.loadPHPExes(PHPDebugPreferencesAddon.this.fDefaultPHPExe, PHPexes.getInstance().getItems(PHPDebugPreferencesAddon.this.getSelectedDebuggerId()));
                                PHPDebugPreferencesAddon.this.selectComboItem(PHPDebugPreferencesAddon.this.fDefaultDebugger, PHPDebugPreferencesAddon.this.fDefaultDebugger.indexOf(selectedDebugger));
                                PHPDebugPreferencesAddon.this.selectComboItem(PHPDebugPreferencesAddon.this.fDefaultServer, PHPDebugPreferencesAddon.this.fDefaultServer.indexOf(selectedServer));
                                PHPDebugPreferencesAddon.this.selectComboItem(PHPDebugPreferencesAddon.this.fDefaultPHPExe, PHPDebugPreferencesAddon.this.fDefaultPHPExe.indexOf(selectedPHP));
                            }
                        });
                    }
                });
                dialog.open();
            }
        });
    }

    private void selectComboItem(Combo combo, int itemIndex) {
        if (itemIndex < 0) {
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        } else {
            combo.select(itemIndex);
        }
    }

    private Combo addCombo(Composite parent, int horizontalIndent) {
        Combo combo = new Combo(parent, 2060);
        GridData gd = new GridData(768);
        gd.horizontalIndent = horizontalIndent;
        combo.setLayoutData((Object)gd);
        return combo;
    }

    private void savePreferences(boolean isProjectSpecific) {
        String phpExe = this.fDefaultPHPExe.getText();
        PHPexes exes = PHPexes.getInstance();
        if (exes.getItem(this.getSelectedDebuggerId(), phpExe) == null) {
            PHPexeItem item = exes.getDefaultItem(this.getSelectedDebuggerId());
            phpExe = item != null ? item.getName() : "";
        }
        IEclipsePreferences prefs = new InstanceScope().getNode("com.aptana.php.debug.epl");
        IScopeContext[] preferenceScopes = this.createPreferenceScopes(this.propertyPage);
        IEclipsePreferences debugUINode = preferenceScopes[0].getNode(this.getPreferenceNodeQualifier());
        IProject project = this.getProject(this.propertyPage);
        if (isProjectSpecific && debugUINode != null && preferenceScopes[0] instanceof ProjectScope && project != null) {
            debugUINode.putBoolean("com.aptana.php.debug.eplstop_at_first_line_string", this.fStopAtFirstLine.getSelection());
            debugUINode.put("com.aptana.php.debug.epldefaultPHP", phpExe);
            debugUINode.put("com.aptana.php.debug.php_debugger_id", this.getSelectedDebuggerId());
        } else if (project == null) {
            prefs.putBoolean("com.aptana.php.debug.eplstop_at_first_line_string", this.fStopAtFirstLine.getSelection());
            prefs.put("com.aptana.php.debug.eplclient_ip", this.fClientIP.getText());
            prefs.put("com.aptana.php.debug.php_debugger_id", this.getSelectedDebuggerId());
            exes.setDefaultItem(this.getSelectedDebuggerId(), phpExe);
        } else if (debugUINode != null) {
            debugUINode.remove("com.aptana.php.debug.eplstop_at_first_line_string");
            debugUINode.remove("com.aptana.php.debug.epldefaultPHP");
            debugUINode.remove("com.aptana.php.debug.epltransfer_encoding");
            debugUINode.remove("com.aptana.php.debug.eploutput_encoding");
            debugUINode.remove("com.aptana.php.debug.php_debugger_id");
        }
        try {
            debugUINode.flush();
            exes.save();
            prefs.flush();
        }
        catch (BackingStoreException e) {
            PHPDebugEPLPlugin.logError(e);
        }
    }

    private String getSelectedDebuggerId() {
        int selectedIndex = this.fDefaultDebugger.getSelectionIndex();
        String debuggerId = "org2.eclipse.php.debug.core.xdebugDebugger";
        if (selectedIndex > -1 && this.debuggersIds.size() > selectedIndex) {
            debuggerId = this.debuggersIds.toArray()[selectedIndex].toString();
        }
        return debuggerId;
    }
}

