/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.preferences.phps;

import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org2.eclipse.php.internal.debug.core.interpreter.preferences.PHPexeItem;
import org2.eclipse.php.internal.debug.core.preferences.PHPexes;
import org2.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org2.eclipse.php.internal.debug.ui.preferences.phps.InstalledPHPsBlock;
import org2.eclipse.php.internal.debug.ui.wizard.exe.PHPExeEditDialog;

public class PHPsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static String ID = "org2.eclipse.php.debug.ui.preferencesphps.PHPsPreferencePage";
    private InstalledPHPsBlock fPHPBlock;
    private Object data;

    public PHPsPreferencePage() {
        this.setTitle(PHPDebugUIMessages.PHPsPreferencePage_1);
        this.setDescription(PHPDebugUIMessages.PHPsPreferencePage_2);
    }

    public void init(IWorkbench workbench) {
    }

    public void applyData(Object data) {
        this.data = data;
    }

    protected Control createContents(Composite ancestor) {
        this.initializeDialogUnits((Control)ancestor);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ancestor.setLayout((Layout)layout);
        this.fPHPBlock = new InstalledPHPsBlock();
        this.fPHPBlock.createControl(ancestor);
        Control control = this.fPHPBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        this.fPHPBlock.restoreColumnSettings(PHPDebugEPLPlugin.getDefault().getDialogSettings(), "com.aptana.php.debug.eplphpdebug.dialog.columnwidth");
        this.initDefaultPHP();
        this.applyDialogFont(ancestor);
        return ancestor;
    }

    public boolean performOk() {
        IDialogSettings settings = PHPDebugEPLPlugin.getDefault().getDialogSettings();
        this.fPHPBlock.saveColumnSettings(settings, "com.aptana.php.debug.eplphpdebug.dialog.columnwidth");
        this.fPHPBlock.commitChanges();
        return super.performOk();
    }

    private void verifyDefaultPHP(PHPexeItem php) {
        boolean exist;
        if (php != null && !(exist = php.getExecutable().exists())) {
            this.fPHPBlock.removePHPs(new PHPexeItem[]{php});
            ErrorDialog.openError((Shell)this.getControl().getShell(), (String)PHPDebugUIMessages.PHPsPreferencePage_1, (String)PHPDebugUIMessages.PHPsPreferencePage_10, (IStatus)new Status(4, "com.aptana.php.debug.epl", 4, PHPDebugUIMessages.PHPsPreferencePage_11, null));
            return;
        }
    }

    private void initDefaultPHP() {
        PHPexeItem realDefault = PHPexes.getInstance().getDefaultItem(PHPDebugEPLPlugin.getCurrentDebuggerId());
        if (realDefault != null) {
            PHPexeItem[] phps;
            PHPexeItem[] pHPexeItemArray = phps = this.fPHPBlock.getPHPs();
            int n = phps.length;
            int n2 = 0;
            while (n2 < n) {
                PHPexeItem fakePHP = pHPexeItemArray[n2];
                if (fakePHP.equals(realDefault)) {
                    this.verifyDefaultPHP(fakePHP);
                    break;
                }
                ++n2;
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (PHPsPreferencePage.this.data instanceof PHPexeItem) {
                        PHPexes exes = PHPexes.getInstance();
                        PHPexeItem pexeItem = (PHPexeItem)PHPsPreferencePage.this.data;
                        PHPexeItem phpExeToEdit = new PHPexeItem(pexeItem.getName(), pexeItem.getExecutable(), pexeItem.getINILocation(), pexeItem.getDebuggerID(), pexeItem.isEditable());
                        PHPExeEditDialog dialog = new PHPExeEditDialog(PHPsPreferencePage.this.getShell(), phpExeToEdit, exes.getAllItems(), false);
                        dialog.setTitle(PHPDebugUIMessages.InstalledPHPsBlock_8);
                        if (dialog.open() != 0) {
                            PHPsPreferencePage.this.performOk();
                        }
                        pexeItem.setName(phpExeToEdit.getName());
                        pexeItem.setExecutable(phpExeToEdit.getExecutable());
                        pexeItem.setINILocation(phpExeToEdit.getINILocation());
                        String debuggerID = phpExeToEdit.getDebuggerID();
                        pexeItem.setDebuggerID(debuggerID);
                        PHPsPreferencePage.this.performOk();
                    }
                }
            });
        }
    }
}

