/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.preferences.stepFilter;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org2.eclipse.php.internal.core.project.IIncludePathEntry;
import org2.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org2.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org2.eclipse.php.internal.debug.ui.preferences.stepFilter.IncPathFile;

public class PHPResourceContentProvider
implements ITreeContentProvider {
    private IContentType phpContentType = Platform.getContentTypeManager().getContentType("com.aptana.contenttype.phtml.php");

    public Object[] getChildren(Object parentElement) {
        try {
            if (parentElement instanceof IContainer) {
                IResource[] members;
                LinkedList<Object> r = new LinkedList<Object>();
                IContainer container = (IContainer)parentElement;
                IResource[] iResourceArray = members = container.members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (member instanceof IContainer && member.isAccessible() && !this.isResourceFiltered(member)) {
                        if (member instanceof IProject) {
                            IProject project = (IProject)member;
                            if (project.hasNature("com.aptana.editor.php.phpNature")) {
                                r.add(member);
                            }
                        } else {
                            r.add(member);
                        }
                    }
                    ++n2;
                }
                if (parentElement instanceof IWorkspaceRoot) {
                    return r.toArray();
                }
                if (parentElement instanceof IProject) {
                    IProject project = (IProject)parentElement;
                    PHPProjectOptions options = PHPProjectOptions.forProject((IProject)project);
                    if (options != null) {
                        IIncludePathEntry[] includePath = options.readRawIncludePath();
                        r.addAll(Arrays.asList(includePath));
                    }
                    return r.toArray();
                }
            } else if (parentElement instanceof IIncludePathEntry) {
                IIncludePathEntry buildpathEntry = (IIncludePathEntry)parentElement;
                IPath path = buildpathEntry.getPath();
                File file = null;
                if (buildpathEntry.getEntryKind() == 1) {
                    file = path.toFile();
                } else if (buildpathEntry.getEntryKind() == 4 && (path = IncludePathVariableManager.instance().resolveVariablePath(path.toString())) != null) {
                    file = path.toFile();
                }
                if (file != null) {
                    return this.getChildren(new IncPathFile(buildpathEntry, file));
                }
            } else if (parentElement instanceof IncPathFile) {
                IncPathFile ipFile = (IncPathFile)parentElement;
                File file = ipFile.file;
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    ArrayList<IncPathFile> r = new ArrayList<IncPathFile>(files.length);
                    File[] fileArray = files;
                    int n = files.length;
                    int n3 = 0;
                    while (n3 < n) {
                        File currentFile = fileArray[n3];
                        r.add(new IncPathFile(ipFile.includePathEntry, currentFile));
                        ++n3;
                    }
                    return r.toArray();
                }
            }
        }
        catch (CoreException coreException) {}
        return new Object[0];
    }

    private boolean isResourceFiltered(IResource member) {
        if (member instanceof IFile) {
            return !this.phpContentType.isAssociatedWith(member.getName());
        }
        return false;
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        if (element instanceof IncPathFile) {
            IncPathFile ipFile = (IncPathFile)element;
            return new IncPathFile(ipFile.includePathEntry, ipFile.file.getParentFile());
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

