/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.wizard;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class TextDialogCellEditor
extends CellEditor {
    public static final String CELL_EDITOR_IMG_DOTS_BUTTON = "cell_editor_dots_button_image";
    private Composite editor;
    private Control contents;
    private Text defaultLabel;
    private Button button;
    private FocusListener buttonFocusListener;
    private Object value = null;
    private static final int defaultStyle = 0;

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put(CELL_EDITOR_IMG_DOTS_BUTTON, ImageDescriptor.createFromFile(TextDialogCellEditor.class, (String)"images/dots_button.gif"));
    }

    public TextDialogCellEditor() {
        this.setStyle(0);
    }

    protected TextDialogCellEditor(Composite parent) {
        this(parent, 0);
    }

    protected TextDialogCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Button createButton(Composite parent) {
        Button result = new Button(parent, 1024);
        result.setText("...");
        return result;
    }

    protected Control createContents(Composite cell) {
        this.defaultLabel = new Text(cell, 16392);
        this.defaultLabel.setFont(cell.getFont());
        this.defaultLabel.setBackground(cell.getBackground());
        return this.defaultLabel;
    }

    protected Control createControl(Composite parent) {
        Font font = parent.getFont();
        Color bg = parent.getBackground();
        this.editor = new Composite(parent, this.getStyle());
        this.editor.setFont(font);
        this.editor.setBackground(bg);
        this.editor.setLayout((Layout)new DialogCellLayout());
        this.contents = this.createContents(this.editor);
        this.updateContents(this.value);
        this.button = this.createButton(this.editor);
        this.button.setFont(font);
        this.button.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    TextDialogCellEditor.this.fireCancelEditor();
                }
            }
        });
        this.button.addFocusListener(this.getButtonFocusListener());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextDialogCellEditor.this.button.removeFocusListener(TextDialogCellEditor.this.getButtonFocusListener());
                Object newValue = TextDialogCellEditor.this.openDialogBox((Control)TextDialogCellEditor.this.editor);
                TextDialogCellEditor.this.button.addFocusListener(TextDialogCellEditor.this.getButtonFocusListener());
                if (newValue != null) {
                    boolean newValidState = TextDialogCellEditor.this.isCorrect(newValue);
                    if (newValidState) {
                        TextDialogCellEditor.this.markDirty();
                        TextDialogCellEditor.this.doSetValue(newValue);
                    } else {
                        TextDialogCellEditor.this.setErrorMessage(MessageFormat.format(TextDialogCellEditor.this.getErrorMessage(), newValue.toString()));
                    }
                    TextDialogCellEditor.this.fireApplyEditorValue();
                }
            }
        });
        this.setValueValid(true);
        return this.editor;
    }

    public void deactivate() {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.removeFocusListener(this.getButtonFocusListener());
        }
        super.deactivate();
    }

    protected Object doGetValue() {
        return this.value;
    }

    protected void doSetFocus() {
        this.button.setFocus();
        this.button.addFocusListener(this.getButtonFocusListener());
    }

    private FocusListener getButtonFocusListener() {
        if (this.buttonFocusListener == null) {
            this.buttonFocusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    TextDialogCellEditor.this.focusLost();
                }
            };
        }
        return this.buttonFocusListener;
    }

    protected void doSetValue(Object value) {
        this.value = value;
        this.updateContents(value);
    }

    protected Text getDefaultLabel() {
        return this.defaultLabel;
    }

    protected abstract Object openDialogBox(Control var1);

    protected void updateContents(Object value) {
        if (this.defaultLabel == null) {
            return;
        }
        String text = "";
        if (value != null) {
            text = value.toString();
        }
        this.defaultLabel.setText(text);
    }

    private class DialogCellLayout
    extends Layout {
        private DialogCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = TextDialogCellEditor.this.button.computeSize(-1, -1, force);
            if (TextDialogCellEditor.this.contents != null) {
                TextDialogCellEditor.this.contents.setBounds(0, 0, bounds.width - size.x, bounds.height);
            }
            int pos = bounds.width - size.x;
            int delta = 0;
            int dx = 0;
            if (Platform.getOS().equals("macosx")) {
                delta = 5;
                dx = 3;
            }
            TextDialogCellEditor.this.button.setBounds(pos - dx, -delta, size.x, bounds.height + delta);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = TextDialogCellEditor.this.contents.computeSize(-1, -1, force);
            Point buttonSize = TextDialogCellEditor.this.button.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

