/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.wizard.web;

import com.aptana.webserver.core.IServer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org2.eclipse.php.debug.core.debugger.pathmapper.PathMapper;
import org2.eclipse.php.internal.core.util.ScrolledCompositeImpl;
import org2.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org2.eclipse.php.internal.debug.ui.pathmapper.PathMappingComposite;
import org2.eclipse.php.internal.debug.ui.wizard.CompositeFragment;
import org2.eclipse.php.internal.debug.ui.wizard.IControlHandler;

public class PathMapperCompositeFragment
extends CompositeFragment {
    private PathMappingComposite pathMapperComposite;

    public PathMapperCompositeFragment(Composite parent, IControlHandler handler, boolean isForEditing) {
        super(parent, handler, isForEditing);
        this.controlHandler.setTitle("Server Path Mapping");
        this.controlHandler.setDescription("Specify mapping between server and local paths");
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.aptana.editor.php.epl", (String)"/icons/full/wizban/server_wiz.gif");
        this.controlHandler.setImageDescriptor(imageDescriptor);
        this.setDisplayName("Path Mapping");
        this.setTitle("Edit Server Path Mapping");
        this.setDescription("Configure Server Path Mapping");
        this.createControl(isForEditing);
    }

    protected void createControl(boolean isForEditing) {
        GridLayout pageLayout = new GridLayout();
        this.setLayout((Layout)pageLayout);
        Label label = new Label((Composite)this, 64);
        label.setText("Specify mapping between the server and the workspace paths. \nChanges made here affect all the launch configurations that use the selected server.");
        ScrolledCompositeImpl scrolledComposite = new ScrolledCompositeImpl((Composite)this, 768);
        GridData data = new GridData(1808);
        scrolledComposite.setLayoutData((Object)data);
        this.pathMapperComposite = new PathMappingComposite((Composite)scrolledComposite, 0);
        data = new GridData(1808);
        this.pathMapperComposite.setLayoutData(data);
        scrolledComposite.setContent((Control)this.pathMapperComposite);
        scrolledComposite.setLayout((Layout)new GridLayout());
        scrolledComposite.setFont(this.getFont());
        Point size = this.pathMapperComposite.computeSize(-1, -1);
        scrolledComposite.setMinSize(size.x, size.y);
        data = new GridData(1808);
        scrolledComposite.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)this);
        this.init();
        this.validate();
    }

    public void addPropertyChangeListener(IPropertyListener listener) {
        if (this.pathMapperComposite != null) {
            this.pathMapperComposite.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(IPropertyListener listener) {
        if (this.pathMapperComposite != null) {
            this.pathMapperComposite.removePropertyChangeListener(listener);
        }
    }

    protected void init() {
        if (this.pathMapperComposite == null || this.pathMapperComposite.isDisposed()) {
            return;
        }
        IServer server = this.getServer();
        this.pathMapperComposite.setServerIsValid(server != null);
        if (server != null) {
            PathMapper pathMapper = PathMapperRegistry.getByServer(server);
            this.pathMapperComposite.setData(pathMapper.getMapping());
        } else {
            this.pathMapperComposite.setData(null);
        }
    }

    protected void validate() {
        this.setMessage(this.getDescription(), 0);
        this.setComplete(true);
        this.controlHandler.update();
    }

    protected void setMessage(String message, int type) {
        this.controlHandler.setMessage(message, type);
        this.setComplete(type != 3);
        this.controlHandler.update();
    }

    @Override
    public boolean performOk() {
        IServer server = this.getServer();
        if (server != null) {
            PathMapper pathMapper = PathMapperRegistry.getByServer(server);
            pathMapper.setMapping(this.pathMapperComposite.getMappings());
            PathMapperRegistry.storeToPreferences();
        }
        return true;
    }

    @Override
    public void setData(Object server) {
        if (server != null && !(server instanceof IServer)) {
            throw new IllegalArgumentException("The given object is not a Server");
        }
        super.setData(server);
        this.init();
        this.validate();
    }

    public PathMapper.Mapping[] getMappings() {
        return this.pathMapperComposite.getMappings();
    }

    public IServer getServer() {
        return (IServer)this.getData();
    }
}

