/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.wizard.web;

import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import com.aptana.ui.util.SWTUtils;
import com.aptana.webserver.core.IServer;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org2.eclipse.php.internal.debug.ui.wizard.CompositeFragment;
import org2.eclipse.php.internal.debug.ui.wizard.ICompositeFragmentFactory;
import org2.eclipse.php.internal.debug.ui.wizard.IControlHandler;
import org2.eclipse.php.internal.debug.ui.wizard.WizardFragmentsFactoryRegistry;
import org2.eclipse.php.util.SWTUtil;

public class ServerEditDialog
extends TitleAreaDialog
implements IControlHandler {
    protected static final String FRAGMENT_GROUP_ID = "org2.eclipse.php.server.ui.serverWizardAndComposite";
    private IServer server;
    private ArrayList runtimeComposites;
    private SelectionListener tabsListener;

    public ServerEditDialog(Shell parentShell, IServer server) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.server = server;
        this.runtimeComposites = new ArrayList(3);
    }

    protected Control createDialogArea(Composite parent) {
        ICompositeFragmentFactory[] factories;
        CTabFolder tabs = SWTUtil.createTabFolder((Composite)parent);
        ICompositeFragmentFactory[] iCompositeFragmentFactoryArray = factories = WizardFragmentsFactoryRegistry.getFragmentsFactories(FRAGMENT_GROUP_ID);
        int n = factories.length;
        int n2 = 0;
        while (n2 < n) {
            ICompositeFragmentFactory element = iCompositeFragmentFactoryArray[n2];
            CTabItem tabItem = new CTabItem(tabs, 2048);
            CompositeFragment fragment = element.createComposite((Composite)tabs, this);
            fragment.setData(this.server);
            tabItem.setText(fragment.getDisplayName());
            tabItem.setControl((Control)fragment);
            this.runtimeComposites.add(fragment);
            ++n2;
        }
        this.getShell().setText("Edit Server");
        this.getShell().setImage(SWTUtils.getImage((AbstractUIPlugin)PHPDebugEPLPlugin.getDefault(), (String)"/icons/full/obj16/server_run.gif"));
        this.tabsListener = new TabsSelectionListener();
        tabs.addSelectionListener(this.tabsListener);
        return tabs;
    }

    protected void cancelPressed() {
        Iterator composites = this.runtimeComposites.iterator();
        while (composites.hasNext()) {
            ((CompositeFragment)((Object)composites.next())).performCancel();
        }
        super.cancelPressed();
    }

    protected void okPressed() {
        Iterator composites = this.runtimeComposites.iterator();
        while (composites.hasNext()) {
            ((CompositeFragment)((Object)composites.next())).performOk();
        }
        super.okPressed();
    }

    @Override
    public void setDescription(String desc) {
        super.setMessage(desc);
    }

    @Override
    public void setImageDescriptor(ImageDescriptor image) {
        super.setTitleImage(image.createImage());
    }

    @Override
    public void update() {
        Button button = this.getButton(0);
        if (button != null) {
            Iterator composites = this.runtimeComposites.iterator();
            while (composites.hasNext()) {
                if (((CompositeFragment)((Object)composites.next())).isComplete()) continue;
                button.setEnabled(false);
                return;
            }
            button.setEnabled(true);
        }
    }

    @Override
    public void setMessage(String newMessage, int newType) {
        if (newType == 2) {
            newType = 1;
        }
        super.setMessage(newMessage, newType);
    }

    public IServer getServer() {
        return this.server;
    }

    public void setServer(IServer server) {
        this.server = server;
    }

    private class TabsSelectionListener
    implements SelectionListener {
        private TabsSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            CTabItem item = (CTabItem)e.item;
            CompositeFragment fragment = (CompositeFragment)item.getControl();
            ServerEditDialog.this.setTitle(fragment.getTitle());
            ServerEditDialog.this.setDescription(fragment.getDescription());
        }
    }
}

