/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.internal.listeners;

import com.aptana.scripting.model.AbstractElement;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.CommandContext;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.ElementVisibilityListener;
import com.aptana.scripting.model.TriggerType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class ExecutionListenerRegistrant
implements ElementVisibilityListener,
IExecutionListener {
    private static ExecutionListenerRegistrant INSTANCE;
    private Map<CommandElement, Set<String>> _commandToIdsMap = new HashMap<CommandElement, Set<String>>();
    private Map<String, Set<CommandElement>> _idToCommandsMap = new HashMap<String, Set<CommandElement>>();
    private Set<CommandElement> _nonlimitedCommands = new HashSet<CommandElement>();

    public static synchronized ExecutionListenerRegistrant getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExecutionListenerRegistrant();
            INSTANCE.setup();
        }
        return INSTANCE;
    }

    public static synchronized void shutdown() {
        if (INSTANCE != null) {
            INSTANCE.tearDown();
            INSTANCE = null;
        }
    }

    protected void addCommand(CommandElement command) {
        if (command.hasProperty(TriggerType.EXECUTION_LISTENER.getPropertyName())) {
            String[] ids = command.getTriggerTypeValues(TriggerType.EXECUTION_LISTENER);
            if (ids.length > 0) {
                HashSet<String> idSet = new HashSet<String>(Arrays.asList(ids));
                this._commandToIdsMap.put(command, idSet);
                for (String id : idSet) {
                    Set<CommandElement> commandsUsingId = this._idToCommandsMap.get(id);
                    if (commandsUsingId == null) {
                        commandsUsingId = new HashSet<CommandElement>();
                        this._idToCommandsMap.put(id, commandsUsingId);
                    }
                    commandsUsingId.add(command);
                }
            } else {
                this._nonlimitedCommands.add(command);
            }
        }
    }

    public void elementBecameHidden(AbstractElement element) {
        if (element instanceof CommandElement) {
            this.removeCommand((CommandElement)element);
        }
    }

    public void elementBecameVisible(AbstractElement element) {
        if (element instanceof CommandElement) {
            this.addCommand((CommandElement)element);
        }
    }

    private void execute(String id, String ... properties) {
        if (this._idToCommandsMap.containsKey(id) || !this._nonlimitedCommands.isEmpty()) {
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            propertyMap.put("id", id);
            int length = properties.length & 0xFFFFFFFE;
            int i = 0;
            while (i < length) {
                String name = properties[i];
                String value = properties[i + 1];
                propertyMap.put(name, value);
                i += 2;
            }
            HashSet<CommandElement> allCommands = new HashSet<CommandElement>();
            Set<CommandElement> commandsForId = this._idToCommandsMap.get(id);
            if (commandsForId != null) {
                allCommands.addAll(commandsForId);
            }
            allCommands.addAll(this._nonlimitedCommands);
            for (CommandElement command : allCommands) {
                CommandContext context = command.createCommandContext();
                context.put(TriggerType.EXECUTION_LISTENER.getName(), propertyMap);
                command.execute(context);
            }
        }
    }

    public void notHandled(String commandId, NotHandledException exception) {
    }

    public void postExecuteFailure(String commandId, ExecutionException exception) {
    }

    public void postExecuteSuccess(String commandId, Object returnValue) {
        this.execute(commandId, "type", "postExecuteSuccess");
    }

    public void preExecute(String commandId, ExecutionEvent event) {
    }

    protected void removeCommand(CommandElement command) {
        Set<String> ids = this._commandToIdsMap.get(command);
        if (ids != null) {
            for (String id : ids) {
                Set<CommandElement> commandsUsingId = this._idToCommandsMap.get(id);
                if (commandsUsingId == null || !commandsUsingId.remove(command) || !commandsUsingId.isEmpty()) continue;
                this._idToCommandsMap.remove(id);
            }
        } else {
            this._nonlimitedCommands.remove(command);
        }
    }

    private void setup() {
        try {
            Object service = PlatformUI.getWorkbench().getService(ICommandService.class);
            if (service instanceof ICommandService) {
                ICommandService commandService = (ICommandService)service;
                commandService.addExecutionListener((IExecutionListener)this);
            }
        }
        catch (IllegalStateException service) {
            // empty catch block
        }
        BundleManager manager = BundleManager.getInstance();
        manager.addElementVisibilityListener((ElementVisibilityListener)this);
    }

    private void tearDown() {
        BundleManager manager = BundleManager.getInstance();
        manager.removeElementVisibilityListener((ElementVisibilityListener)this);
        Object service = PlatformUI.getWorkbench().getService(ICommandService.class);
        if (service instanceof ICommandService) {
            ICommandService commandService = (ICommandService)service;
            commandService.removeExecutionListener((IExecutionListener)this);
        }
        this._commandToIdsMap.clear();
        this._idToCommandsMap.clear();
        this._nonlimitedCommands.clear();
    }
}

