/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.epl.EditorEplPlugin;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonLineNumberRulerColumn
extends LineNumberRulerColumn {
    private static final boolean IS_MAC = Util.isMac();
    private CompositeRuler fParentRuler;
    private ITextViewer fCachedTextViewer;
    private StyledText fCachedTextWidget;
    private Canvas fCanvas;
    private int fScrollPos;
    private Image fBuffer;
    private InternalListener fInternalListener = new InternalListener();
    private Font fFont;
    private int[] fIndentation;
    private boolean fSensitiveToTextChanges = false;
    private Color fForeground;
    private Color fBackground;
    private int fCachedNumberOfDigits = -1;
    private boolean fRelayoutRequired = false;
    private Object fRunnableLock = new Object();
    private boolean fIsRunnablePosted = false;
    private Runnable fRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = CommonLineNumberRulerColumn.this.fRunnableLock;
            synchronized (object) {
                CommonLineNumberRulerColumn.this.fIsRunnablePosted = false;
            }
            CommonLineNumberRulerColumn.this.redraw();
        }
    };
    private MouseHandler fMouseHandler;

    public void setForeground(Color foreground) {
        this.fForeground = foreground;
    }

    protected Color getForeground() {
        return this.fForeground;
    }

    public void setBackground(Color background) {
        this.fBackground = background;
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.setBackground(this.getBackground(this.fCanvas.getDisplay()));
        }
    }

    protected Color getBackground(Display display) {
        if (this.fBackground == null) {
            return display.getSystemColor(25);
        }
        return this.fBackground;
    }

    public Control getControl() {
        return this.fCanvas;
    }

    public int getWidth() {
        return this.fIndentation[0];
    }

    protected boolean updateNumberOfDigits() {
        if (this.fCachedTextViewer == null) {
            return false;
        }
        int digits = this.computeNumberOfDigits();
        if (this.fCachedNumberOfDigits != digits) {
            this.fCachedNumberOfDigits = digits;
            return true;
        }
        return false;
    }

    protected int computeNumberOfDigits() {
        IDocument document = this.fCachedTextViewer.getDocument();
        int lines = document == null ? 0 : document.getNumberOfLines();
        int digits = 2;
        while ((double)lines > Math.pow(10.0, digits) - 1.0) {
            ++digits;
        }
        return digits;
    }

    protected void layout(boolean redraw) {
        ITextViewerExtension extension;
        Control control;
        if (!redraw) {
            this.fRelayoutRequired = true;
            return;
        }
        this.fRelayoutRequired = false;
        if (this.fCachedTextViewer instanceof ITextViewerExtension && (control = (extension = (ITextViewerExtension)this.fCachedTextViewer).getControl()) instanceof Composite && !control.isDisposed()) {
            Composite composite = (Composite)control;
            composite.layout(true);
        }
    }

    protected void computeIndentations() {
        if (this.fCanvas == null || this.fCanvas.isDisposed()) {
            return;
        }
        GC gc = new GC((Drawable)this.fCanvas);
        try {
            gc.setFont(this.fCanvas.getFont());
            this.fIndentation = new int[this.fCachedNumberOfDigits + 1];
            char[] nines = new char[this.fCachedNumberOfDigits];
            Arrays.fill(nines, '9');
            String nineString = new String(nines);
            Point p = gc.stringExtent(nineString);
            this.fIndentation[0] = p.x;
            int i = 1;
            while (i <= this.fCachedNumberOfDigits) {
                p = gc.stringExtent(nineString.substring(0, i));
                this.fIndentation[i] = this.fIndentation[0] - p.x;
                ++i;
            }
        }
        finally {
            gc.dispose();
        }
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        this.fParentRuler = parentRuler;
        this.fCachedTextViewer = parentRuler.getTextViewer();
        this.fCachedTextWidget = this.fCachedTextViewer.getTextWidget();
        this.fCanvas = new Canvas(parentControl, 524288){

            public void addMouseListener(MouseListener listener) {
                if (listener == CommonLineNumberRulerColumn.this.fMouseHandler) {
                    super.addMouseListener(listener);
                } else {
                    TypedListener typedListener = null;
                    if (listener != null) {
                        typedListener = new TypedListener((SWTEventListener)listener);
                    }
                    this.addListener(8, (Listener)typedListener);
                }
            }
        };
        this.fCanvas.setBackground(this.getBackground(this.fCanvas.getDisplay()));
        this.fCanvas.setForeground(this.fForeground);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (CommonLineNumberRulerColumn.this.fCachedTextViewer != null) {
                    CommonLineNumberRulerColumn.this.doubleBufferPaint(event.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommonLineNumberRulerColumn.this.handleDispose();
                CommonLineNumberRulerColumn.this.fCachedTextViewer = null;
                CommonLineNumberRulerColumn.this.fCachedTextWidget = null;
            }
        });
        this.fMouseHandler = new MouseHandler();
        this.fCanvas.addMouseListener((MouseListener)this.fMouseHandler);
        this.fCanvas.addMouseMoveListener((MouseMoveListener)this.fMouseHandler);
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.addViewportListener((IViewportListener)this.fInternalListener);
            this.fCachedTextViewer.addTextListener((ITextListener)this.fInternalListener);
            if (this.fFont == null && this.fCachedTextWidget != null && !this.fCachedTextWidget.isDisposed()) {
                this.fFont = this.fCachedTextWidget.getFont();
            }
        }
        if (this.fFont != null) {
            this.fCanvas.setFont(this.fFont);
        }
        this.updateNumberOfDigits();
        this.computeIndentations();
        return this.fCanvas;
    }

    protected void handleDispose() {
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.removeViewportListener((IViewportListener)this.fInternalListener);
            this.fCachedTextViewer.removeTextListener((ITextListener)this.fInternalListener);
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
    }

    private void doubleBufferPaint(GC dest) {
        Point size = this.fCanvas.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            Rectangle r = this.fBuffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.fBuffer);
        gc.setFont(this.fCanvas.getFont());
        if (this.fForeground != null) {
            gc.setForeground(this.fForeground);
        }
        try {
            gc.setBackground(this.getBackground(this.fCanvas.getDisplay()));
            gc.fillRectangle(0, 0, size.x, size.y);
            ILineRange visibleLines = JFaceTextUtil.getVisibleModelLines((ITextViewer)this.fCachedTextViewer);
            if (visibleLines == null) {
                return;
            }
            this.fScrollPos = this.fCachedTextWidget.getTopPixel();
            this.doPaint(gc, visibleLines);
        }
        finally {
            gc.dispose();
        }
        dest.drawImage(this.fBuffer, 0, 0);
    }

    protected int getVisibleLinesInViewport() {
        return CommonLineNumberRulerColumn.getVisibleLinesInViewport(this.fCachedTextWidget);
    }

    protected final boolean isViewerEntirelyShown() {
        return JFaceTextUtil.isShowingEntireContents((StyledText)this.fCachedTextWidget);
    }

    void doPaint(GC gc, ILineRange visibleLines) {
        Display display = this.fCachedTextWidget.getDisplay();
        int y = -JFaceTextUtil.getHiddenTopLinePixels((StyledText)this.fCachedTextWidget);
        List<LineMap> lineMap = this.getLineMap(this.fCachedTextWidget, visibleLines);
        int lineCount = this.fCachedTextWidget.getLineCount();
        int lineMapSize = lineMap.size();
        int i = 0;
        while (i < lineMapSize) {
            LineMap map = lineMap.get(i);
            int line = map.documentLine;
            int widgetLine = map.widgetLine;
            try {
                int lineHeight = this.fCachedTextWidget.getLineHeight(this.fCachedTextWidget.getOffsetAtLine(widgetLine));
                this.paintLine(line, y, lineHeight, gc, display);
                int distanceFromPrevious = 1;
                if (line < lineCount - 1 && i + 1 < lineMapSize) {
                    distanceFromPrevious = lineMap.get((int)(i + 1)).visualLine - map.visualLine;
                }
                y += lineHeight * distanceFromPrevious;
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)EditorEplPlugin.getDefault(), (String)MessageFormat.format("Error painting line number: {0}", map), (Throwable)e);
            }
            ++i;
        }
    }

    List<LineMap> getLineMap(StyledText text, ILineRange visibleLines) {
        ArrayList<LineMap> lineMap = new ArrayList<LineMap>();
        int endLine = CommonLineNumberRulerColumn.end(visibleLines);
        int firstVisibleLineY = 0;
        int lineHeight = 1;
        try {
            lineHeight = text.getLineHeight();
            int widgetLine = JFaceTextUtil.modelLineToWidgetLine((ITextViewer)this.fCachedTextViewer, (int)visibleLines.getStartLine());
            firstVisibleLineY = text.getLocationAtOffset((int)text.getOffsetAtLine((int)widgetLine)).y;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)EditorEplPlugin.getDefault(), (String)"Error translating starting line number to y offset in text widget", (Throwable)e);
        }
        int i = visibleLines.getStartLine();
        while (i < endLine) {
            if (i == 0) {
                lineMap.add(new LineMap(0, 0, 0));
            } else {
                int widgetI = JFaceTextUtil.modelLineToWidgetLine((ITextViewer)this.fCachedTextViewer, (int)i);
                if (widgetI != -1) {
                    try {
                        if (widgetI >= 0 && widgetI < text.getLineCount()) {
                            int lineY = text.getLocationAtOffset((int)text.getOffsetAtLine((int)widgetI)).y;
                            lineMap.add(new LineMap(i, widgetI, visibleLines.getStartLine() + (lineY - firstVisibleLineY) / lineHeight));
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)EditorEplPlugin.getDefault(), (String)MessageFormat.format("Error translating line number {0} to y offset in text widget", i), (Throwable)e);
                    }
                }
            }
            ++i;
        }
        return lineMap;
    }

    private static int end(ILineRange range) {
        return range.getStartLine() + range.getNumberOfLines();
    }

    protected String createDisplayString(int line) {
        return Integer.toString(line + 1);
    }

    private int getBaselineBias(GC gc, int widgetLine) {
        int offset = this.fCachedTextWidget.getOffsetAtLine(widgetLine);
        int widgetBaseline = this.fCachedTextWidget.getBaseline(offset);
        FontMetrics fm = gc.getFontMetrics();
        int fontBaseline = fm.getAscent() + fm.getLeading();
        int baselineBias = widgetBaseline - fontBaseline;
        return Math.max(0, baselineBias);
    }

    protected void paintLine(int line, int y, int lineheight, GC gc, Display display) {
        int widgetLine = JFaceTextUtil.modelLineToWidgetLine((ITextViewer)this.fCachedTextViewer, (int)line);
        String s = this.createDisplayString(line);
        int indentation = this.fIndentation[s.length()];
        int baselineBias = this.getBaselineBias(gc, widgetLine);
        gc.drawString(s, indentation, y + baselineBias, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doPostRedraw() {
        Display d;
        if (this.fCanvas != null && !this.fCanvas.isDisposed() && (d = this.fCanvas.getDisplay()) != null) {
            Object object = this.fRunnableLock;
            synchronized (object) {
                if (this.fIsRunnablePosted) {
                    return;
                }
                this.fIsRunnablePosted = true;
            }
            d.asyncExec(this.fRunnable);
        }
    }

    public void redraw() {
        if (this.fRelayoutRequired) {
            this.layout(true);
            return;
        }
        if (this.fCachedTextViewer != null && this.fCanvas != null && !this.fCanvas.isDisposed()) {
            if (IS_MAC) {
                this.fCanvas.redraw();
                this.fCanvas.update();
            } else {
                GC gc = new GC((Drawable)this.fCanvas);
                this.doubleBufferPaint(gc);
                gc.dispose();
            }
        }
    }

    public void setModel(IAnnotationModel model) {
    }

    public void setFont(Font font) {
        this.fFont = font;
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.setFont(this.fFont);
            this.updateNumberOfDigits();
            this.computeIndentations();
        }
    }

    protected CompositeRuler getParentRuler() {
        return this.fParentRuler;
    }

    static int getVisibleLinesInViewport(StyledText textWidget) {
        Rectangle clArea;
        if (textWidget != null && !(clArea = textWidget.getClientArea()).isEmpty()) {
            int firstPixel = 0;
            int lastPixel = clArea.height - 1;
            int first = JFaceTextUtil.getLineIndex((StyledText)textWidget, (int)firstPixel);
            int last = JFaceTextUtil.getLineIndex((StyledText)textWidget, (int)lastPixel);
            return last - first;
        }
        return -1;
    }

    class InternalListener
    implements IViewportListener,
    ITextListener {
        private boolean fCachedRedrawState = true;

        InternalListener() {
        }

        public void viewportChanged(int verticalPosition) {
            if (this.fCachedRedrawState && verticalPosition != CommonLineNumberRulerColumn.this.fScrollPos) {
                CommonLineNumberRulerColumn.this.redraw();
            }
        }

        public void textChanged(TextEvent event) {
            this.fCachedRedrawState = event.getViewerRedrawState();
            if (!this.fCachedRedrawState) {
                return;
            }
            if (CommonLineNumberRulerColumn.this.updateNumberOfDigits()) {
                CommonLineNumberRulerColumn.this.computeIndentations();
                CommonLineNumberRulerColumn.this.layout(event.getViewerRedrawState());
                return;
            }
            boolean viewerCompletelyShown = CommonLineNumberRulerColumn.this.isViewerEntirelyShown();
            if (viewerCompletelyShown || CommonLineNumberRulerColumn.this.fSensitiveToTextChanges || event.getDocumentEvent() == null) {
                CommonLineNumberRulerColumn.this.doPostRedraw();
            }
            CommonLineNumberRulerColumn.this.fSensitiveToTextChanges = viewerCompletelyShown;
        }
    }

    class LineMap {
        int documentLine;
        int widgetLine;
        int visualLine;

        LineMap(int docLine, int widgetLine, int visualLine) {
            this.documentLine = docLine;
            this.widgetLine = widgetLine;
            this.visualLine = visualLine;
        }

        public String toString() {
            return MessageFormat.format("LineMap <Document: {0}, widget: {1}, visual: {2}>", this.documentLine, this.widgetLine, this.visualLine);
        }
    }

    class MouseHandler
    implements MouseListener,
    MouseMoveListener {
        private int fCachedViewportSize;
        private int fStartLineOffset;
        private int fStartLineNumber;
        private int fAutoScrollDirection;
        private boolean fIsListeningForMove = false;

        MouseHandler() {
        }

        public void mouseUp(MouseEvent event) {
            if (event.button == 1) {
                this.stopSelecting();
                this.stopAutoScroll();
            }
        }

        public void mouseDown(MouseEvent event) {
            CommonLineNumberRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
            if (event.button == 1) {
                this.startSelecting((event.stateMask & 0x20000) != 0);
            }
        }

        public void mouseDoubleClick(MouseEvent event) {
            CommonLineNumberRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
            this.stopSelecting();
            this.stopAutoScroll();
        }

        public void mouseMove(MouseEvent event) {
            if (this.fIsListeningForMove && !this.autoScroll(event)) {
                int newLine = CommonLineNumberRulerColumn.this.fParentRuler.toDocumentLineNumber(event.y);
                this.expandSelection(newLine);
            }
            CommonLineNumberRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
        }

        private void startSelecting(boolean expandExistingSelection) {
            try {
                IDocument document = CommonLineNumberRulerColumn.this.fCachedTextViewer.getDocument();
                int lineNumber = CommonLineNumberRulerColumn.this.fParentRuler.getLineOfLastMouseButtonActivity();
                StyledText textWidget = CommonLineNumberRulerColumn.this.fCachedTextViewer.getTextWidget();
                if (textWidget != null && !textWidget.isFocusControl()) {
                    textWidget.setFocus();
                }
                if (expandExistingSelection && CommonLineNumberRulerColumn.this.fCachedTextViewer instanceof ITextViewerExtension5 && textWidget != null) {
                    ITextViewerExtension5 extension5 = (ITextViewerExtension5)CommonLineNumberRulerColumn.this.fCachedTextViewer;
                    int widgetCaret = textWidget.getCaretOffset();
                    int modelCaret = extension5.widgetOffset2ModelOffset(widgetCaret);
                    Point selection = CommonLineNumberRulerColumn.this.fCachedTextViewer.getSelectedRange();
                    int startOffset = modelCaret == selection.x ? selection.x + selection.y : selection.x;
                    this.fStartLineNumber = document.getLineOfOffset(startOffset);
                    this.fStartLineOffset = startOffset;
                    this.expandSelection(lineNumber);
                } else {
                    this.fStartLineNumber = lineNumber;
                    this.fStartLineOffset = document.getLineInformation(this.fStartLineNumber).getOffset();
                    CommonLineNumberRulerColumn.this.fCachedTextViewer.setSelectedRange(this.fStartLineOffset, 0);
                }
                this.fCachedViewportSize = CommonLineNumberRulerColumn.this.getVisibleLinesInViewport();
                this.fIsListeningForMove = true;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private void stopSelecting() {
            this.fIsListeningForMove = false;
        }

        private void expandSelection(int lineNumber) {
            try {
                int offset;
                IDocument document = CommonLineNumberRulerColumn.this.fCachedTextViewer.getDocument();
                IRegion lineInfo = document.getLineInformation(lineNumber);
                Display display = CommonLineNumberRulerColumn.this.fCachedTextWidget.getDisplay();
                Point absolutePosition = display.getCursorLocation();
                Point relativePosition = CommonLineNumberRulerColumn.this.fCachedTextWidget.toControl(absolutePosition);
                if (relativePosition.x < 0) {
                    offset = lineInfo.getOffset();
                } else {
                    try {
                        int widgetOffset = CommonLineNumberRulerColumn.this.fCachedTextWidget.getOffsetAtLocation(relativePosition);
                        Point p = CommonLineNumberRulerColumn.this.fCachedTextWidget.getLocationAtOffset(widgetOffset);
                        if (p.x > relativePosition.x) {
                            --widgetOffset;
                        }
                        if (CommonLineNumberRulerColumn.this.fCachedTextViewer instanceof ITextViewerExtension5) {
                            ITextViewerExtension5 extension = (ITextViewerExtension5)CommonLineNumberRulerColumn.this.fCachedTextViewer;
                            offset = extension.widgetOffset2ModelOffset(widgetOffset);
                        } else {
                            offset = widgetOffset + CommonLineNumberRulerColumn.this.fCachedTextViewer.getVisibleRegion().getOffset();
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        int lineEndWidgetOffset;
                        int lineEndOffset = lineInfo.getOffset() + lineInfo.getLength();
                        if (CommonLineNumberRulerColumn.this.fCachedTextViewer instanceof ITextViewerExtension5) {
                            ITextViewerExtension5 extension = (ITextViewerExtension5)CommonLineNumberRulerColumn.this.fCachedTextViewer;
                            lineEndWidgetOffset = extension.modelOffset2WidgetOffset(lineEndOffset);
                        } else {
                            lineEndWidgetOffset = lineEndOffset - CommonLineNumberRulerColumn.this.fCachedTextViewer.getVisibleRegion().getOffset();
                        }
                        Point p = CommonLineNumberRulerColumn.this.fCachedTextWidget.getLocationAtOffset(lineEndWidgetOffset);
                        offset = p.x < relativePosition.x ? lineEndOffset : lineInfo.getOffset();
                    }
                }
                int start = Math.min(this.fStartLineOffset, offset);
                int end = Math.max(this.fStartLineOffset, offset);
                if (lineNumber < this.fStartLineNumber) {
                    CommonLineNumberRulerColumn.this.fCachedTextViewer.setSelectedRange(end, start - end);
                } else {
                    CommonLineNumberRulerColumn.this.fCachedTextViewer.setSelectedRange(start, end - start);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private void stopAutoScroll() {
            this.fAutoScrollDirection = 0;
        }

        private boolean autoScroll(MouseEvent event) {
            Rectangle area = CommonLineNumberRulerColumn.this.fCanvas.getClientArea();
            if (event.y > area.height) {
                this.autoScroll(1024);
                return true;
            }
            if (event.y < 0) {
                this.autoScroll(128);
                return true;
            }
            this.stopAutoScroll();
            return false;
        }

        private void autoScroll(int direction) {
            if (this.fAutoScrollDirection == direction) {
                return;
            }
            int TIMER_INTERVAL = 5;
            final Display display = CommonLineNumberRulerColumn.this.fCanvas.getDisplay();
            Runnable timer = null;
            switch (direction) {
                case 128: {
                    timer = new Runnable(){

                        public void run() {
                            int top;
                            if (MouseHandler.this.fAutoScrollDirection == 128 && (top = MouseHandler.this.getInclusiveTopIndex()) > 0) {
                                CommonLineNumberRulerColumn.this.fCachedTextViewer.setTopIndex(top - 1);
                                MouseHandler.this.expandSelection(top - 1);
                                display.timerExec(5, (Runnable)this);
                            }
                        }
                    };
                    break;
                }
                case 1024: {
                    timer = new Runnable(){

                        public void run() {
                            if (MouseHandler.this.fAutoScrollDirection == 1024) {
                                int top = MouseHandler.this.getInclusiveTopIndex();
                                CommonLineNumberRulerColumn.this.fCachedTextViewer.setTopIndex(top + 1);
                                MouseHandler.this.expandSelection(top + 1 + MouseHandler.this.fCachedViewportSize);
                                display.timerExec(5, (Runnable)this);
                            }
                        }
                    };
                }
            }
            if (timer != null) {
                this.fAutoScrollDirection = direction;
                display.timerExec(5, timer);
            }
        }

        private int getInclusiveTopIndex() {
            if (CommonLineNumberRulerColumn.this.fCachedTextWidget != null && !CommonLineNumberRulerColumn.this.fCachedTextWidget.isDisposed()) {
                return JFaceTextUtil.getPartialTopIndex((ITextViewer)CommonLineNumberRulerColumn.this.fCachedTextViewer);
            }
            return -1;
        }
    }
}

