/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.formatter;

import com.aptana.editor.html.formatter.nodes.FormatterDefaultElementNode;
import com.aptana.editor.html.formatter.nodes.FormatterExcludedNode;
import com.aptana.editor.html.formatter.nodes.FormatterForeignElementNode;
import com.aptana.editor.html.formatter.nodes.FormatterHTMLCommentNode;
import com.aptana.editor.html.formatter.nodes.FormatterHTMLContentNode;
import com.aptana.editor.html.formatter.nodes.FormatterSpecialElementNode;
import com.aptana.editor.html.formatter.nodes.FormatterVoidElementNode;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.html.parsing.ast.HTMLNode;
import com.aptana.formatter.ExcludeRegionList;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.FormatterWriter;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.AbstractFormatterNodeBuilder;
import com.aptana.formatter.nodes.FormatterBlockNode;
import com.aptana.formatter.nodes.FormatterBlockWithBeginEndNode;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.nodes.IFormatterNode;
import com.aptana.formatter.nodes.IFormatterTextNode;
import com.aptana.parsing.ast.INameNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class HTMLFormatterNodeBuilder
extends AbstractFormatterNodeBuilder {
    public static final HashSet<String> VOID_ELEMENTS = new HashSet<String>(Arrays.asList("area", "base", "br", "col", "command", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"));
    public static final HashSet<String> EXCLUDED_ELEMENTS = new HashSet<String>(Arrays.asList("textarea", "pre"));
    public static final HashSet<String> SPACE_SENSITIVE_ELEMENTS = new HashSet<String>(Arrays.asList("a", "abbr", "acronym", "b", "bdo", "big", "cite", "code", "del", "dfn", "em", "font", "i", "ins", "kbd", "label", "q", "s", "samp", "small", "span", "strike", "strong", "sub", "sup", "tt", "u", "var"));
    protected static final HashSet<String> OPTIONAL_ENDING_TAGS = new HashSet<String>(Arrays.asList(""));
    private static final String INLINE_TAG_CLOSING = "/>";
    private static final Object RUBY_LANGUAGE = "com.aptana.contenttype.ruby";
    private static final Object PHP_LANGUAGE = "com.aptana.contenttype.php";
    private FormatterDocument document;
    private FormatterWriter formatterWriter;

    public HTMLFormatterNodeBuilder(FormatterWriter writer) {
        this.formatterWriter = writer;
    }

    public HTMLFormatterNodeBuilder() {
    }

    public IFormatterContainerNode build(IParseNode parseResult, FormatterDocument document) {
        this.document = document;
        FormatterBlockNode rootNode = new FormatterBlockNode((IFormatterDocument)document);
        this.start((IFormatterContainerNode)rootNode);
        IParseNode[] children = parseResult.getChildren();
        this.addNodes(children);
        this.checkedPop((IFormatterContainerNode)rootNode, document.getLength());
        if (parseResult instanceof IParseRootNode) {
            this.setOffOnRegions(this.resolveOffOnRegions((IParseRootNode)parseResult, (IFormatterDocument)document, "html.formatter.formatter.on.off.enabled", "html.formatter.formatter.off", "html.formatter.formatter.on"));
        }
        return rootNode;
    }

    private void addNodes(IParseNode[] children) {
        if (children == null || children.length == 0) {
            return;
        }
        IParseNode[] iParseNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode child = iParseNodeArray[n2];
            this.addNode(child);
            ++n2;
        }
    }

    private void addNode(IParseNode node) {
        if (node instanceof HTMLNode) {
            HTMLNode htmlNode = (HTMLNode)node;
            short nodeType = htmlNode.getNodeType();
            if (nodeType == 4) {
                FormatterHTMLCommentNode commentNode = new FormatterHTMLCommentNode((IFormatterDocument)this.document, htmlNode.getStartingOffset(), htmlNode.getEndingOffset() + 1);
                this.addChild((IFormatterNode)commentNode);
            } else if (nodeType == 2 || nodeType == 3) {
                HTMLElementNode elementNode = (HTMLElementNode)node;
                String name = elementNode.getName().toLowerCase();
                if (VOID_ELEMENTS.contains(name) || !this.hasInlineClosingTag(elementNode)) {
                    FormatterVoidElementNode formatterNode = new FormatterVoidElementNode((IFormatterDocument)this.document, name);
                    formatterNode.setBegin(HTMLFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)elementNode.getStartingOffset(), (int)(elementNode.getEndingOffset() + 1)));
                    this.push((IFormatterContainerNode)formatterNode);
                    this.checkedPop((IFormatterContainerNode)formatterNode, -1);
                } else if (EXCLUDED_ELEMENTS.contains(name)) {
                    FormatterExcludedNode nonFormattedContent = new FormatterExcludedNode((IFormatterDocument)this.document);
                    nonFormattedContent.setBegin(HTMLFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)elementNode.getStart(), (int)(elementNode.getEnd() + 1)));
                    this.push((IFormatterContainerNode)nonFormattedContent);
                    this.checkedPop((IFormatterContainerNode)nonFormattedContent, -1);
                } else {
                    this.pushFormatterNode(elementNode);
                }
            } else if (nodeType == 5) {
                FormatterHTMLContentNode contentFormatterNode = new FormatterHTMLContentNode((IFormatterDocument)this.document, htmlNode.getParent(), htmlNode.getPreviousSibling(), htmlNode.getStart(), htmlNode.getEnd() + 1);
                this.addChild((IFormatterNode)contentFormatterNode);
            }
        } else {
            this.pushForeignSpecialNode(node);
        }
    }

    private void pushForeignSpecialNode(IParseNode node) {
        int nodeStart = node.getStartingOffset();
        int nodeEnd = node.getEndingOffset() + 1;
        nodeEnd = Math.min(this.document.getLength(), nodeEnd);
        String text = this.document.get(nodeStart, nodeEnd);
        FormatterForeignElementNode formatterNode = this.resolveForeignSpecialNode(text, node);
        if (formatterNode != null) {
            this.push((IFormatterContainerNode)formatterNode);
            int startSpecial = formatterNode.getBegin()[0].getEndOffset();
            int endSpecial = formatterNode.getEnd().getStartOffset();
            if (endSpecial == this.document.getLength() - 1) {
                ++endSpecial;
            }
            FormatterSpecialElementNode specialNode = new FormatterSpecialElementNode((IFormatterDocument)this.document, "");
            specialNode.setBegin(HTMLFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)startSpecial, (int)endSpecial));
            specialNode.setEnd(HTMLFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)endSpecial, (int)endSpecial));
            this.push((IFormatterContainerNode)specialNode);
            this.checkedPop((IFormatterContainerNode)specialNode, -1);
            this.checkedPop((IFormatterContainerNode)formatterNode, -1);
            if (this.formatterWriter != null) {
                int excludeRegionStart = startSpecial + 1;
                IFormatterTextNode foreignEnd = formatterNode.getEnd();
                int excludeRegionLength = endSpecial - startSpecial - (foreignEnd.getEndOffset() - foreignEnd.getStartOffset());
                if (endSpecial == this.document.getLength()) {
                    --excludeRegionLength;
                }
                if (excludeRegionLength > excludeRegionStart) {
                    this.formatterWriter.excludeRegion((IRegion)new Region(excludeRegionStart, excludeRegionLength), ExcludeRegionList.EXCLUDE_STRATEGY.WRITE_AS_IS);
                }
            }
        } else {
            FormatterSpecialElementNode specialNode = new FormatterSpecialElementNode((IFormatterDocument)this.document, "");
            specialNode.setBegin(HTMLFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)nodeStart, (int)nodeEnd));
            specialNode.setEnd(HTMLFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)nodeEnd, (int)nodeEnd));
            this.push((IFormatterContainerNode)specialNode);
            this.checkedPop((IFormatterContainerNode)specialNode, -1);
        }
    }

    private FormatterForeignElementNode resolveForeignSpecialNode(String text, IParseNode node) {
        int end;
        int offset = node.getStartingOffset();
        String language = node.getLanguage();
        FormatterForeignElementNode elementNode = new FormatterForeignElementNode((IFormatterDocument)this.document);
        int startLength = 2;
        if (RUBY_LANGUAGE.equals(language)) {
            if (text.startsWith("<%=")) {
                startLength = 3;
            }
        } else if (PHP_LANGUAGE.equals(language)) {
            if (text.startsWith("<?php")) {
                startLength = 5;
            } else if (text.startsWith("<?=")) {
                startLength = 3;
            }
        } else {
            return null;
        }
        elementNode.setBegin(HTMLFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)offset, (int)(offset + startLength)));
        int endBegin = end = offset + text.length();
        if (end == this.document.getLength()) {
            endBegin = end - 2;
        } else {
            int endWithoutWhiteSpace = this.getEndWithoutWhiteSpaces(end, this.document);
            if (end != endWithoutWhiteSpace) {
                end = endWithoutWhiteSpace + 1;
            }
            endBegin = end;
        }
        String endStr = this.document.get(endBegin - 2, end);
        endBegin = endStr.endsWith("?>") || endStr.endsWith("%>") ? end - 2 : end;
        elementNode.setEnd(HTMLFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)endBegin, (int)end));
        return elementNode;
    }

    private boolean hasInlineClosingTag(HTMLElementNode elementNode) {
        String text;
        int startingOffset = elementNode.getStartingOffset();
        int endingOffset = elementNode.getEndingOffset();
        return endingOffset - startingOffset <= 1 || this.document.getLength() < endingOffset + 1 || !INLINE_TAG_CLOSING.equals(text = this.document.get(endingOffset - 1, endingOffset + 1));
    }

    private FormatterBlockWithBeginEndNode pushFormatterNode(HTMLElementNode node) {
        String type = node.getName().toLowerCase();
        IRange beginNodeRange = node.getNameNode().getNameRange();
        INameNode endNode = node.getEndNode();
        int endOffset = node.getEndingOffset() + 1;
        IRange endNameRange = endNode.getNameRange();
        if (endNode != null && !endNameRange.isEmpty() && endNameRange.getStartingOffset() != endNameRange.getEndingOffset()) {
            IRange endNodeRange = endNode.getNameRange();
            endOffset = endNodeRange.getStartingOffset();
        }
        boolean createdContentNode = false;
        FormatterDefaultElementNode formatterNode = new FormatterDefaultElementNode((IFormatterDocument)this.document, type, node.getChildren());
        formatterNode.setBegin(HTMLFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)beginNodeRange.getStartingOffset(), (int)(beginNodeRange.getEndingOffset() + 1)));
        this.push((IFormatterContainerNode)formatterNode);
        if (node.getNodeType() == 3 && !"com.aptana.contenttype.html".equals(node.getLanguage())) {
            FormatterSpecialElementNode specialNode = new FormatterSpecialElementNode((IFormatterDocument)this.document, "");
            int beginSpecial = beginNodeRange.getEndingOffset() + 1;
            int endSpecial = endNode.getNameRange().getStartingOffset();
            specialNode.setBegin(HTMLFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)beginSpecial, (int)endSpecial));
            specialNode.setEnd(HTMLFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)endSpecial, (int)endSpecial));
            this.push((IFormatterContainerNode)specialNode);
            this.checkedPop((IFormatterContainerNode)specialNode, -1);
        } else {
            this.addNodes(node.getChildren());
            int endNodeStartingOffset = endNode.getNameRange().getStartingOffset();
            int textStartOffset = this.getBeginWithoutWhiteSpaces(beginNodeRange.getEndingOffset() + 1, this.document);
            int textEndOffset = this.getEndWithoutWhiteSpaces(endNodeStartingOffset - 1, this.document);
            char charAt = this.document.charAt(textStartOffset - 1);
            if (textStartOffset > 0 && (charAt == ' ' || charAt == '\t')) {
                --textStartOffset;
            }
            charAt = this.document.charAt(textEndOffset + 1);
            if (textEndOffset < this.document.getLength() - 1 && (charAt == ' ' || charAt == '\t')) {
                ++textEndOffset;
            }
            if (!node.hasChildren()) {
                if (textStartOffset > textEndOffset) {
                    if (textStartOffset == endOffset) {
                        textEndOffset = textStartOffset - 1;
                    } else {
                        textStartOffset = beginNodeRange.getEndingOffset() + 1;
                        textEndOffset = endOffset - 1;
                    }
                }
                FormatterHTMLContentNode contentFormatterNode = new FormatterHTMLContentNode((IFormatterDocument)this.document, (IParseNode)node, node.getPreviousSibling(), textStartOffset, textEndOffset + 1);
                formatterNode.addChild((IFormatterNode)contentFormatterNode);
                createdContentNode = true;
            }
        }
        if (createdContentNode) {
            this.checkedPop((IFormatterContainerNode)formatterNode, -1);
        } else {
            this.checkedPop((IFormatterContainerNode)formatterNode, this.getEndWithoutWhiteSpaces(endOffset - 1, this.document) + 1);
        }
        formatterNode.setEnd(HTMLFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)endOffset, (int)(node.getEndingOffset() + 1)));
        return formatterNode;
    }

    private int getBeginWithoutWhiteSpaces(int offset, FormatterDocument document) {
        int length = document.getLength();
        while (offset < length) {
            if (!Character.isWhitespace(document.charAt(offset))) break;
            ++offset;
        }
        return offset;
    }

    private int getEndWithoutWhiteSpaces(int offset, FormatterDocument document) {
        while (offset > 0) {
            if (!Character.isWhitespace(document.charAt(offset))) break;
            --offset;
        }
        return offset;
    }
}

