/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.idl;

import com.aptana.editor.common.text.rules.CharacterMapRule;
import com.aptana.editor.common.text.rules.WhitespaceDetector;
import com.aptana.editor.idl.parsing.lexer.IDLTokenType;
import com.aptana.editor.idl.text.rules.IDLNumberRule;
import com.aptana.editor.idl.text.rules.IDLOperatorDetector;
import java.util.ArrayList;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class IDLSourceScanner
extends RuleBasedScanner {
    public IDLSourceScanner() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        rules.add(new SingleLineRule("\"", "\"", this.createToken(IDLTokenType.STRING)));
        rules.add(new MultiLineRule("/**", "*/", this.createToken(IDLTokenType.DOC_COMMENT), '\u0000', true));
        rules.add(new MultiLineRule("/*", "*/", this.createToken(IDLTokenType.MULTILINE_COMMENT), '\u0000', true));
        WordRule operatorRule = new WordRule((IWordDetector)new IDLOperatorDetector(), Token.UNDEFINED);
        operatorRule.addWord("::", this.createToken(IDLTokenType.DOUBLE_COLON));
        operatorRule.addWord("...", this.createToken(IDLTokenType.ELLIPSIS));
        rules.add(operatorRule);
        WordRule wordRule = new WordRule((IWordDetector)new WordDetector(), this.createToken(IDLTokenType.IDENTIFIER));
        wordRule.addWord("any", this.createToken(IDLTokenType.ANY));
        wordRule.addWord("attribute", this.createToken(IDLTokenType.ATTRIBUTE));
        wordRule.addWord("boolean", this.createToken(IDLTokenType.BOOLEAN));
        wordRule.addWord("caller", this.createToken(IDLTokenType.CALLER));
        wordRule.addWord("const", this.createToken(IDLTokenType.CONST));
        wordRule.addWord("creator", this.createToken(IDLTokenType.CREATOR));
        wordRule.addWord("deleter", this.createToken(IDLTokenType.DELETER));
        wordRule.addWord("DOMString", this.createToken(IDLTokenType.DOMSTRING));
        wordRule.addWord("double", this.createToken(IDLTokenType.DOUBLE));
        wordRule.addWord("exception", this.createToken(IDLTokenType.EXCEPTION));
        wordRule.addWord("false", this.createToken(IDLTokenType.FALSE));
        wordRule.addWord("float", this.createToken(IDLTokenType.FLOAT));
        wordRule.addWord("getraises", this.createToken(IDLTokenType.GETRAISES));
        wordRule.addWord("getter", this.createToken(IDLTokenType.GETTER));
        wordRule.addWord("implements", this.createToken(IDLTokenType.IMPLEMENTS));
        wordRule.addWord("in", this.createToken(IDLTokenType.IN));
        wordRule.addWord("interface", this.createToken(IDLTokenType.INTERFACE));
        wordRule.addWord("long", this.createToken(IDLTokenType.LONG));
        wordRule.addWord("module", this.createToken(IDLTokenType.MODULE));
        wordRule.addWord("Object", this.createToken(IDLTokenType.OBJECT));
        wordRule.addWord("octet", this.createToken(IDLTokenType.OCTET));
        wordRule.addWord("omittable", this.createToken(IDLTokenType.OMITTABLE));
        wordRule.addWord("optional", this.createToken(IDLTokenType.OPTIONAL));
        wordRule.addWord("raises", this.createToken(IDLTokenType.RAISES));
        wordRule.addWord("readonly", this.createToken(IDLTokenType.READONLY));
        wordRule.addWord("sequence", this.createToken(IDLTokenType.SEQUENCE));
        wordRule.addWord("setraises", this.createToken(IDLTokenType.SETRAISES));
        wordRule.addWord("setter", this.createToken(IDLTokenType.SETTER));
        wordRule.addWord("short", this.createToken(IDLTokenType.SHORT));
        wordRule.addWord("stringifier", this.createToken(IDLTokenType.STRINGIFIER));
        wordRule.addWord("true", this.createToken(IDLTokenType.TRUE));
        wordRule.addWord("typedef", this.createToken(IDLTokenType.TYPEDEF));
        wordRule.addWord("unsigned", this.createToken(IDLTokenType.UNSIGNED));
        wordRule.addWord("void", this.createToken(IDLTokenType.VOID));
        rules.add(wordRule);
        CharacterMapRule cmRule = new CharacterMapRule();
        cmRule.add('{', this.createToken(IDLTokenType.LCURLY));
        cmRule.add('}', this.createToken(IDLTokenType.RCURLY));
        cmRule.add(';', this.createToken(IDLTokenType.SEMICOLON));
        cmRule.add(':', this.createToken(IDLTokenType.COLON));
        cmRule.add('<', this.createToken(IDLTokenType.LESS_THAN));
        cmRule.add('>', this.createToken(IDLTokenType.GREATER_THAN));
        cmRule.add('=', this.createToken(IDLTokenType.EQUAL));
        cmRule.add('(', this.createToken(IDLTokenType.LPAREN));
        cmRule.add(')', this.createToken(IDLTokenType.RPAREN));
        cmRule.add(',', this.createToken(IDLTokenType.COMMA));
        cmRule.add('[', this.createToken(IDLTokenType.LBRACKET));
        cmRule.add(']', this.createToken(IDLTokenType.RBRACKET));
        cmRule.add('?', this.createToken(IDLTokenType.QUESTION));
        rules.add(cmRule);
        rules.add((Object)new IDLNumberRule(this.createToken(IDLTokenType.NUMBER)));
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    protected IToken createToken(IDLTokenType type) {
        return new Token((Object)type.getScope());
    }

    static class WordDetector
    implements IWordDetector {
        WordDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isLetter(c) || '_' == c;
        }

        public boolean isWordPart(char c) {
            return Character.isLetterOrDigit(c) || '_' == c;
        }
    }
}

