/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.idl.text.rules;

import com.aptana.editor.common.text.rules.ExtendedWordRule;
import com.aptana.editor.idl.text.rules.IDLNumberDetector;
import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;

public class IDLNumberRule
extends ExtendedWordRule {
    private static final String REGEXP = "-?( 0 ([0-7]* | [Xx][0-9A-Fa-f]+) | [1-9][0-9]* | ([0-9]+\\.[0-9]* | [0-9]*\\.[0-9]+)([Ee][+-]?[0-9]+)? | [0-9]+[Ee][+-]?[0-9]+ )";
    private static Pattern pattern;

    public IDLNumberRule(IToken token) {
        super((IWordDetector)new IDLNumberDetector(), token, false);
    }

    protected boolean wordOK(String word, ICharacterScanner scanner) {
        return IDLNumberRule.getPattern().matcher(word).matches();
    }

    private static synchronized Pattern getPattern() {
        if (pattern == null) {
            pattern = Pattern.compile(REGEXP, 4);
        }
        return pattern;
    }
}

