/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.erb.html.parsing;

import com.aptana.editor.erb.parsing.lexer.ERBTokens;
import com.aptana.editor.html.parsing.HTMLTokenScanner;
import java.util.ArrayList;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class RHTMLTokenScanner
extends HTMLTokenScanner {
    private static final String[] RUBY_START = new String[]{"<%", "<%="};
    private static final String[] RUBY_END = new String[]{"-%>", "%>"};

    public RHTMLTokenScanner() {
        String word;
        ArrayList<Object> rules = new ArrayList<Object>();
        WordRule wordRule = new WordRule((IWordDetector)new RubyStartDetector(), Token.UNDEFINED);
        IToken token = this.createToken(RHTMLTokenScanner.getERBTokenName((short)101));
        String[] stringArray = RUBY_START;
        int n = RUBY_START.length;
        int n2 = 0;
        while (n2 < n) {
            word = stringArray[n2];
            wordRule.addWord(word, token);
            ++n2;
        }
        rules.add(wordRule);
        wordRule = new WordRule((IWordDetector)new RubyEndDetector(), Token.UNDEFINED);
        token = this.createToken(RHTMLTokenScanner.getERBTokenName((short)102));
        stringArray = RUBY_END;
        n = RUBY_END.length;
        n2 = 0;
        while (n2 < n) {
            word = stringArray[n2];
            wordRule.addWord(word, token);
            ++n2;
        }
        rules.add(wordRule);
        stringArray = this.fRules;
        n = this.fRules.length;
        n2 = 0;
        while (n2 < n) {
            String rule = stringArray[n2];
            rules.add(rule);
            ++n2;
        }
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    private static String getERBTokenName(short token) {
        return ERBTokens.getTokenName(token);
    }

    private static final class RubyEndDetector
    implements IWordDetector {
        private RubyEndDetector() {
        }

        public boolean isWordPart(char c) {
            switch (c) {
                case '%': 
                case '-': 
                case '>': {
                    return true;
                }
            }
            return false;
        }

        public boolean isWordStart(char c) {
            return c == '-' || c == '%';
        }
    }

    private static final class RubyStartDetector
    implements IWordDetector {
        private RubyStartDetector() {
        }

        public boolean isWordPart(char c) {
            switch (c) {
                case '%': 
                case '<': 
                case '=': {
                    return true;
                }
            }
            return false;
        }

        public boolean isWordStart(char c) {
            return c == '<';
        }
    }
}

