/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.projects;

import java.util.List;
import java.util.UUID;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectData {
    public String projectName;
    public String directory;
    public boolean isDefaultLocation;
    public String appId;
    public String appGUID;
    public String appURL;
    public List<String> selectedItems;
    public String sdkVersion;
    public boolean cloneFromGit;
    public IProject project;
    public static final String DEFAULT_PUBLISHER_URL = "http://";

    public ProjectData() {
        this(null, null, null, true, null, DEFAULT_PUBLISHER_URL, null, null, false);
    }

    public ProjectData(IProject project, String projectName, String directory, boolean isDefaultLocation, String appId, String appURL, String sdkVersion, List<String> selectedItems, boolean cloneFromGit) {
        this.project = project;
        this.projectName = projectName;
        this.directory = directory;
        this.isDefaultLocation = isDefaultLocation;
        this.appId = appId;
        this.appURL = appURL;
        this.sdkVersion = sdkVersion;
        this.selectedItems = selectedItems;
        this.appGUID = UUID.randomUUID().toString();
        this.cloneFromGit = cloneFromGit;
    }

    public IPath getProjectLocation() {
        if (this.project != null && this.project.getLocation() != null) {
            return this.project.getLocation();
        }
        IPath path = Path.fromOSString((String)this.directory);
        if (this.isDefaultLocation) {
            path = path.append(this.projectName);
        }
        return path;
    }
}

