/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.projects;

import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.projects.templates.ProjectTemplate;
import com.aptana.core.projects.templates.TemplateType;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.projects.Messages;
import com.aptana.projects.internal.listeners.StudioProjectListenersManager;
import com.aptana.projects.listeners.IProjectListenersManager;
import com.aptana.projects.templates.IDefaultProjectTemplate;
import com.aptana.projects.templates.ProjectTemplatesManager;
import com.aptana.projects.wizards.ProjectWizardContributionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ProjectsPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aptana.projects";
    private static ProjectsPlugin plugin;
    private ProjectTemplatesManager templatesManager;
    private ProjectWizardContributionManager projectWizardContributionManager;
    private IProjectListenersManager projectListenersManager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.getTemplatesManager().addTemplate((IProjectTemplate)new DefaultWebProjectTemplate());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (this.templatesManager != null) {
            this.templatesManager.dispose();
            this.templatesManager = null;
        }
        this.projectWizardContributionManager = null;
        this.projectListenersManager = null;
        super.stop(context);
    }

    public static ProjectsPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        ImageDescriptor id;
        if (ProjectsPlugin.getDefault().getImageRegistry().getDescriptor(string) == null && (id = ProjectsPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)string)) != null) {
            ProjectsPlugin.getDefault().getImageRegistry().put(string, id);
        }
        return ProjectsPlugin.getDefault().getImageRegistry().getDescriptor(string);
    }

    public synchronized ProjectTemplatesManager getTemplatesManager() {
        if (this.templatesManager == null) {
            this.templatesManager = new ProjectTemplatesManager();
        }
        return this.templatesManager;
    }

    public synchronized ProjectWizardContributionManager getProjectWizardContributionManager() {
        if (this.projectWizardContributionManager == null) {
            this.projectWizardContributionManager = new ProjectWizardContributionManager();
        }
        return this.projectWizardContributionManager;
    }

    public synchronized IProjectListenersManager getProjectListenersManager() {
        if (this.projectListenersManager == null) {
            this.projectListenersManager = new StudioProjectListenersManager();
        }
        return this.projectListenersManager;
    }

    private static class DefaultWebProjectTemplate
    extends ProjectTemplate
    implements IDefaultProjectTemplate {
        private static final String ID = "com.aptana.projects.web.default";

        public DefaultWebProjectTemplate() {
            super("default.zip", TemplateType.WEB, Messages.ProjectsPlugin_DefaultWebProjectTemplate_Name, false, Messages.ProjectsPlugin_DefaultWebProjectTemplate_Description, null, ID, 1, CollectionsUtil.newList((Object[])new String[]{"Web"}));
        }

        public IStatus apply(IProject project, boolean promptForOverwrite) {
            return Status.OK_STATUS;
        }
    }
}

