/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.projects.internal.listeners;

import com.aptana.core.IFilter;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.StringUtil;
import com.aptana.projects.ProjectsPlugin;
import com.aptana.projects.listeners.IProjectListenersManager;
import com.aptana.projects.listeners.IStudioProjectListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;

public class StudioProjectListenersManager
implements IProjectListenersManager {
    private final String EXTENSION_POINT = "projectListeners";
    private final String ELEMENT_PROJECT_LISTENER = "projectListener";
    private final String ELEMENT_CLASS = "class";
    private final String ELEMENT_PRIORITY = "priority";
    private final String ELEMENT_PROJECT_NATURE = "natureId";
    private final Map<String, List<ProjectListenerElement>> listeners = new HashMap<String, List<ProjectListenerElement>>();

    public StudioProjectListenersManager() {
        this.readExtensionRegistry();
    }

    private void readExtensionRegistry() {
        EclipseUtil.processConfigurationElements((String)"com.aptana.projects", (String)"projectListeners", (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                StudioProjectListenersManager.this.readElement(element);
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newSet((Object[])new String[]{"projectListener"});
            }
        });
    }

    private void readElement(IConfigurationElement element) {
        String listenerClass;
        if ("projectListener".equals(element.getName()) && !StringUtil.isEmpty((String)(listenerClass = element.getAttribute("class")))) {
            String projectNature = element.getAttribute("natureId");
            List<ProjectListenerElement> values = this.listeners.get(projectNature);
            if (values == null) {
                values = new ArrayList<ProjectListenerElement>();
                this.listeners.put(projectNature, values);
            }
            values.add(new ProjectListenerElement(element));
        }
    }

    public synchronized boolean addListener(IStudioProjectListener listener, int priority, String projectNature) {
        List<ProjectListenerElement> values = this.listeners.get(projectNature);
        if (values == null) {
            values = new ArrayList<ProjectListenerElement>(2);
        }
        values.add(new ProjectListenerElement(listener, priority));
        this.listeners.put(projectNature, values);
        return true;
    }

    public synchronized IStudioProjectListener[] getProjectListeners(String ... projectNatures) {
        ArrayList<ProjectListenerElement> listenerElements = new ArrayList<ProjectListenerElement>();
        List<ProjectListenerElement> globalListeners = this.listeners.get(null);
        if (globalListeners != null) {
            listenerElements.addAll(globalListeners);
        }
        if (projectNatures != null) {
            String[] stringArray = projectNatures;
            int n = projectNatures.length;
            int n2 = 0;
            while (n2 < n) {
                String nature = stringArray[n2];
                List<ProjectListenerElement> values = this.listeners.get(nature);
                if (values != null) {
                    listenerElements.addAll(values);
                }
                ++n2;
            }
        }
        Collections.sort(listenerElements, new Comparator<ProjectListenerElement>(){

            @Override
            public int compare(ProjectListenerElement o1, ProjectListenerElement o2) {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.getPriority() - o2.getPriority();
            }
        });
        ArrayList<IStudioProjectListener> projectListeners = new ArrayList<IStudioProjectListener>();
        for (ProjectListenerElement element : listenerElements) {
            projectListeners.add(element.getListener());
        }
        return projectListeners.toArray(new IStudioProjectListener[projectListeners.size()]);
    }

    public synchronized boolean removeListener(final IStudioProjectListener listener, String projectNature) {
        if (listener == null) {
            return false;
        }
        List<ProjectListenerElement> values = this.listeners.get(projectNature);
        if (values == null) {
            return false;
        }
        ProjectListenerElement element = (ProjectListenerElement)CollectionsUtil.find(values, (IFilter)new IFilter<ProjectListenerElement>(){

            public boolean include(ProjectListenerElement item) {
                return listener.equals(item.getListener());
            }
        });
        if (element == null) {
            return false;
        }
        values.remove(element);
        this.listeners.put(projectNature, values);
        return true;
    }

    private class ProjectListenerElement {
        private Integer priority;
        private IStudioProjectListener projectListener;
        private final IConfigurationElement ice;

        ProjectListenerElement(IStudioProjectListener listener, int priority) {
            this(null);
            this.projectListener = listener;
            this.priority = priority;
        }

        ProjectListenerElement(IConfigurationElement element) {
            this.ice = element;
        }

        public synchronized IStudioProjectListener getListener() {
            if (this.projectListener == null) {
                try {
                    this.projectListener = (IStudioProjectListener)this.ice.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)ProjectsPlugin.getDefault(), (String)MessageFormat.format("Failed to create project listener from contributor: {0}, class: {1}", this.ice.getContributor().getName(), this.ice.getAttribute("class")), (Throwable)e);
                }
            }
            return this.projectListener;
        }

        public synchronized int getPriority() {
            if (this.priority == null) {
                String rawPriority = this.ice.getAttribute("priority");
                try {
                    this.priority = Integer.valueOf(rawPriority);
                }
                catch (Exception e) {
                    this.priority = 100;
                }
            }
            return this.priority;
        }
    }
}

