/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.projects.wizards;

import com.aptana.core.IFilter;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.projects.ProjectsPlugin;
import com.aptana.projects.wizards.IProjectWizardContributor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectWizardContributionManager {
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_PRIORITY = "priority";
    private static final String EXTENSION_POINT_NAME = "projectWizardContributors";
    private static final int DEFAULT_PRIORITY = 60;
    private List<IProjectWizardContributor> contributors;

    public IWizardPage[] createPages(Object data, String[] natureIds) {
        this.loadExtensions();
        ArrayList<IWizardPage> pages = new ArrayList<IWizardPage>();
        for (IProjectWizardContributor contributor : this.contributors) {
            IWizardPage wizardPage;
            if (!ArrayUtil.isEmpty((Object[])natureIds) && !contributor.hasNatureId(natureIds) || (wizardPage = contributor.createWizardPage(data)) == null) continue;
            pages.add(wizardPage);
        }
        return pages.toArray(new IWizardPage[pages.size()]);
    }

    public void finalizeWizardPages(IWizardPage[] pages, String[] natureIds) {
        this.loadExtensions();
        for (IProjectWizardContributor contributor : this.contributors) {
            IWizardPage[] iWizardPageArray = pages;
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage page = iWizardPageArray[n2];
                if (ArrayUtil.isEmpty((Object[])natureIds) || contributor.hasNatureId(natureIds)) {
                    contributor.finalizeWizardPage(page);
                }
                ++n2;
            }
        }
    }

    public Set<IProjectWizardContributor> contributeSampleProjectCreationPage(String[] natureIds, Object data, WizardPage page, Composite parent) {
        this.loadExtensions();
        HashSet<IProjectWizardContributor> activeContributors = new HashSet<IProjectWizardContributor>();
        for (IProjectWizardContributor contributor : this.contributors) {
            if (!ArrayUtil.isEmpty((Object[])natureIds) && !contributor.hasNatureId(natureIds)) continue;
            activeContributors.add(contributor);
            contributor.appendSampleProjectCreationPage(data, (IWizardPage)page, parent);
        }
        return activeContributors;
    }

    public Set<IProjectWizardContributor> contributeProjectCreationPage(String[] natureIds, Object data, WizardPage page, Composite parent) {
        this.loadExtensions();
        HashSet<IProjectWizardContributor> activeContributors = new HashSet<IProjectWizardContributor>();
        for (IProjectWizardContributor contributor : this.contributors) {
            if (!ArrayUtil.isEmpty((Object[])natureIds) && !contributor.hasNatureId(natureIds)) continue;
            activeContributors.add(contributor);
            contributor.appendProjectCreationPage(data, (IWizardPage)page, parent);
        }
        return activeContributors;
    }

    public void updateProject(Object data, String[] natureIds) {
        this.loadExtensions();
        for (IProjectWizardContributor contributor : this.contributors) {
            if (!ArrayUtil.isEmpty((Object[])natureIds) && !contributor.hasNatureId(natureIds)) continue;
            contributor.updateProjectCreationPage(data);
        }
    }

    public IStatus validateProject(Object data, String[] natureIds) {
        this.loadExtensions();
        for (IProjectWizardContributor contributor : this.contributors) {
            IStatus status;
            if (!ArrayUtil.isEmpty((Object[])natureIds) && !contributor.hasNatureId(natureIds) || !(status = contributor.validateProjectCreationPage(data)).matches(6)) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    private synchronized void loadExtensions() {
        block8: {
            if (this.contributors != null) break block8;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor("com.aptana.projects", EXTENSION_POINT_NAME);
            HashMap<String, IConfigurationElement> registryMap = new HashMap<String, IConfigurationElement>(elements.length);
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    String id;
                    IConfigurationElement element;
                    block9: {
                        element = iConfigurationElementArray[n2];
                        id = element.getAttribute(ATTRIBUTE_ID);
                        if (!registryMap.containsKey(id)) break block9;
                        IConfigurationElement currentElement = (IConfigurationElement)registryMap.get(id);
                        int currentPrioirty = 60;
                        int newPriority = 60;
                        try {
                            currentPrioirty = Integer.parseInt(currentElement.getAttribute(ATTRIBUTE_PRIORITY));
                            newPriority = Integer.parseInt(element.getAttribute(ATTRIBUTE_PRIORITY));
                        }
                        catch (NumberFormatException nfe) {
                            IdeLog.logError((Plugin)ProjectsPlugin.getDefault(), (Throwable)nfe);
                        }
                        if (newPriority < currentPrioirty) break block10;
                    }
                    registryMap.put(id, element);
                }
                ++n2;
            }
            this.contributors = new ArrayList<IProjectWizardContributor>(registryMap.size());
            for (IConfigurationElement element : registryMap.values()) {
                try {
                    IProjectWizardContributor contributorObject = (IProjectWizardContributor)element.createExecutableExtension(ATTRIBUTE_CLASS);
                    if (contributorObject == null) continue;
                    this.contributors.add(contributorObject);
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)ProjectsPlugin.getDefault(), (Throwable)e);
                }
            }
        }
    }

    public List<IProjectWizardContributor> getContributors(final String[] natureIds) {
        return CollectionsUtil.filter(this.contributors, (IFilter)new IFilter<IProjectWizardContributor>(){

            public boolean include(IProjectWizardContributor item) {
                return item.hasNatureId(natureIds);
            }
        });
    }

    public IStatus performProjectFinish(IProject project, IProgressMonitor monitor) {
        this.loadExtensions();
        Object[] natureIds = null;
        try {
            natureIds = project.getDescription().getNatureIds();
        }
        catch (CoreException e) {
            IdeLog.log((Plugin)ProjectsPlugin.getDefault(), (IStatus)e.getStatus());
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.contributors == null ? 0 : this.contributors.size()));
        for (IProjectWizardContributor contributor : this.contributors) {
            IStatus status;
            if (!ArrayUtil.isEmpty((Object[])natureIds) && !contributor.hasNatureId((String[])natureIds) || (status = contributor.performWizardFinish(project, (IProgressMonitor)sub.newChild(1))) == null || status.isOK()) continue;
            return status;
        }
        return Status.OK_STATUS;
    }
}

