require 'ruble/ui'

# The mapping below was generated using:
# ruby -e 'STDOUT << "HTML_TAGS = {\n" << `curl -s http://www.w3.org/TR/html4/index/elements.html`.scan(%r{<td title="Name"><a href="(.*?)">\n?(.*?)</a></td>}).map { |e| "  \"#{e[1]}\"".ljust(14) + " => \"#{e[0]}\"" }.join(",\n") << "\n}\n"'
HTML_TAGS = {
  "A"          => "../struct/links.html#edef-A",
  "ABBR"       => "../struct/text.html#edef-ABBR",
  "ACRONYM"    => "../struct/text.html#edef-ACRONYM",
  "ADDRESS"    => "../struct/global.html#edef-ADDRESS",
  "APPLET"     => "../struct/objects.html#edef-APPLET",
  "AREA"       => "../struct/objects.html#edef-AREA",
  "B"          => "../present/graphics.html#edef-B",
  "BASE"       => "../struct/links.html#edef-BASE",
  "BASEFONT"   => "../present/graphics.html#edef-BASEFONT",
  "BDO"        => "../struct/dirlang.html#edef-BDO",
  "BIG"        => "../present/graphics.html#edef-BIG",
  "BLOCKQUOTE" => "../struct/text.html#edef-BLOCKQUOTE",
  "BODY"       => "../struct/global.html#edef-BODY",
  "BR"         => "../struct/text.html#edef-BR",
  "BUTTON"     => "../interact/forms.html#edef-BUTTON",
  "CAPTION"    => "../struct/tables.html#edef-CAPTION",
  "CENTER"     => "../present/graphics.html#edef-CENTER",
  "CITE"       => "../struct/text.html#edef-CITE",
  "CODE"       => "../struct/text.html#edef-CODE",
  "COL"        => "../struct/tables.html#edef-COL",
  "COLGROUP"   => "../struct/tables.html#edef-COLGROUP",
  "DD"         => "../struct/lists.html#edef-DD",
  "DEL"        => "../struct/text.html#edef-del",
  "DFN"        => "../struct/text.html#edef-DFN",
  "DIR"        => "../struct/lists.html#edef-DIR",
  "DIV"        => "../struct/global.html#edef-DIV",
  "DL"         => "../struct/lists.html#edef-DL",
  "DT"         => "../struct/lists.html#edef-DT",
  "EM"         => "../struct/text.html#edef-EM",
  "FIELDSET"   => "../interact/forms.html#edef-FIELDSET",
  "FONT"       => "../present/graphics.html#edef-FONT",
  "FORM"       => "../interact/forms.html#edef-FORM",
  "FRAME"      => "../present/frames.html#edef-FRAME",
  "FRAMESET"   => "../present/frames.html#edef-FRAMESET",
  "H1"         => "../struct/global.html#edef-H1",
  "H2"         => "../struct/global.html#edef-H2",
  "H3"         => "../struct/global.html#edef-H3",
  "H4"         => "../struct/global.html#edef-H4",
  "H5"         => "../struct/global.html#edef-H5",
  "H6"         => "../struct/global.html#edef-H6",
  "HEAD"       => "../struct/global.html#edef-HEAD",
  "HR"         => "../present/graphics.html#edef-HR",
  "HTML"       => "../struct/global.html#edef-HTML",
  "I"          => "../present/graphics.html#edef-I",
  "IFRAME"     => "../present/frames.html#edef-IFRAME",
  "IMG"        => "../struct/objects.html#edef-IMG",
  "INPUT"      => "../interact/forms.html#edef-INPUT",
  "INS"        => "../struct/text.html#edef-ins",
  "ISINDEX"    => "../interact/forms.html#edef-ISINDEX",
  "KBD"        => "../struct/text.html#edef-KBD",
  "LABEL"      => "../interact/forms.html#edef-LABEL",
  "LEGEND"     => "../interact/forms.html#edef-LEGEND",
  "LI"         => "../struct/lists.html#edef-LI",
  "LINK"       => "../struct/links.html#edef-LINK",
  "MAP"        => "../struct/objects.html#edef-MAP",
  "MENU"       => "../struct/lists.html#edef-MENU",
  "META"       => "../struct/global.html#edef-META",
  "NOFRAMES"   => "../present/frames.html#edef-NOFRAMES",
  "NOSCRIPT"   => "../interact/scripts.html#edef-NOSCRIPT",
  "OBJECT"     => "../struct/objects.html#edef-OBJECT",
  "OL"         => "../struct/lists.html#edef-OL",
  "OPTGROUP"   => "../interact/forms.html#edef-OPTGROUP",
  "OPTION"     => "../interact/forms.html#edef-OPTION",
  "P"          => "../struct/text.html#edef-P",
  "PARAM"      => "../struct/objects.html#edef-PARAM",
  "PRE"        => "../struct/text.html#edef-PRE",
  "Q"          => "../struct/text.html#edef-Q",
  "S"          => "../present/graphics.html#edef-S",
  "SAMP"       => "../struct/text.html#edef-SAMP",
  "SCRIPT"     => "../interact/scripts.html#edef-SCRIPT",
  "SELECT"     => "../interact/forms.html#edef-SELECT",
  "SMALL"      => "../present/graphics.html#edef-SMALL",
  "SPAN"       => "../struct/global.html#edef-SPAN",
  "STRIKE"     => "../present/graphics.html#edef-STRIKE",
  "STRONG"     => "../struct/text.html#edef-STRONG",
  "STYLE"      => "../present/styles.html#edef-STYLE",
  "SUB"        => "../struct/text.html#edef-SUB",
  "SUP"        => "../struct/text.html#edef-SUP",
  "TABLE"      => "../struct/tables.html#edef-TABLE",
  "TBODY"      => "../struct/tables.html#edef-TBODY",
  "TD"         => "../struct/tables.html#edef-TD",
  "TEXTAREA"   => "../interact/forms.html#edef-TEXTAREA",
  "TFOOT"      => "../struct/tables.html#edef-TFOOT",
  "TH"         => "../struct/tables.html#edef-TH",
  "THEAD"      => "../struct/tables.html#edef-THEAD",
  "TITLE"      => "../struct/global.html#edef-TITLE",
  "TR"         => "../struct/tables.html#edef-TR",
  "TT"         => "../present/graphics.html#edef-TT",
  "U"          => "../present/graphics.html#edef-U",
  "UL"         => "../struct/lists.html#edef-UL",
  "VAR"        => "../struct/text.html#edef-VAR"
}

def request_tag_name(default_tag = "body")
  # FIXME This ui call doesn't actually take the button labels we try to set here
  options = { :title => 'Documentation for Tag', :prompt => 'What tag would you like to lookup?',
    :default => default_tag, :button1 => 'Lookup', :button2 => 'Cancel', :button3 => 'Show All Tags' }
  tag = Ruble::UI.request_string(options)
  if !tag.nil?
    HTML_TAGS[tag.to_s.upcase] || "elements.html"
  else
    nil
  end
end