/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.kernel;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.tid.TidAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public final class KernelTidAspect
extends LinuxTidAspect {
    public static final KernelTidAspect INSTANCE = new KernelTidAspect();
    private static final IProgressMonitor NULL_MONITOR = new NullProgressMonitor();

    private KernelTidAspect() {
    }

    @Override
    public @Nullable Integer resolve(ITmfEvent event) {
        try {
            return this.resolve(event, false, NULL_MONITOR);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public @Nullable Integer resolve(@NonNull ITmfEvent event, boolean block, IProgressMonitor monitor) throws InterruptedException {
        Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        if (cpu == null) {
            return null;
        }
        TidAnalysisModule analysis = (TidAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)event.getTrace(), TidAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel.tid");
        if (analysis == null) {
            return null;
        }
        long ts = event.getTimestamp().toNanos();
        while (block && !analysis.isQueryable(ts) && !monitor.isCanceled()) {
            Thread.sleep(100L);
        }
        return analysis.getThreadOnCpuAtTime(cpu, ts);
    }
}

