/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.launch;

import java.io.IOException;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.remote.ArduinoRemoteConnection;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.launch.TargetedLaunch;
import org.eclipse.remote.core.IRemoteConnection;

public class ArduinoLaunch
extends TargetedLaunch {
    private final ArduinoRemoteConnection remote;
    private boolean wasOpen;

    public ArduinoLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator, ILaunchTarget target) {
        super(launchConfiguration, mode, target, locator);
        IRemoteConnection connection = (IRemoteConnection)target.getAdapter(IRemoteConnection.class);
        this.remote = (ArduinoRemoteConnection)connection.getService(ArduinoRemoteConnection.class);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void start() {
        SerialPort port;
        this.wasOpen = this.remote.getRemoteConnection().isOpen();
        if (this.wasOpen && (port = SerialPort.get((String)this.remote.getPortName())) != null) {
            try {
                port.pause();
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        super.handleDebugEvents(events);
        if (this.isTerminated() && this.wasOpen) {
            SerialPort port = SerialPort.get((String)this.remote.getPortName());
            if (port != null) {
                try {
                    port.resume();
                }
                catch (IOException e) {
                    Activator.log(e);
                }
            }
            this.wasOpen = false;
        }
    }
}

