/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.core;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.rpm.core.RPMProject;
import org.eclipse.linuxtools.rpm.core.RPMProjectLayout;

public class RPMProjectCreator {
    private RPMProjectLayout layout;

    public RPMProjectCreator(RPMProjectLayout layout) {
        this.layout = layout;
    }

    public RPMProjectCreator() {
        this(RPMProjectLayout.RPMBUILD);
    }

    public IProject create(String projectName, IPath projectPath, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        String parsedIPathString = null;
        if (!Platform.getLocation().equals((Object)projectPath)) {
            parsedIPathString = projectPath.toString().replaceFirst(":/", "://");
            try {
                description.setLocationURI(new URI(parsedIPathString));
            }
            catch (URISyntaxException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e.getMessage(), (Throwable)e));
            }
        }
        description.setNatureIds(new String[]{"org.eclipse.linuxtools.rpm.core.rpmnature"});
        project.create(description, monitor);
        monitor.worked(10);
        project.open(monitor);
        new RPMProject(project, this.layout);
        return project;
    }
}

