/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.internal.docker.core.ContainerFileProxy;
import org.eclipse.linuxtools.internal.docker.ui.ContainerTreeGroup;
import org.eclipse.linuxtools.internal.docker.ui.Messages;
import org.eclipse.linuxtools.internal.docker.ui.MinimizedFileSystemElement;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerComparator;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class ContainerDirectorySelectionDialog
extends SelectionDialog {
    private FileSystemElement root;
    private IImportStructureProvider structureProvider;
    ContainerTreeGroup selectionGroup;
    private boolean expandAllOnOpen = false;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 500;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    static final String SELECT_ALL_TITLE = "SelectionDialog_selectLabel";
    static final String DESELECT_ALL_TITLE = "SelectionDialog_deselectLabel";

    public ContainerDirectorySelectionDialog(Shell parentShell, FileSystemElement fileSystemElement, IImportStructureProvider structureProvider, String message) {
        super(parentShell);
        this.setTitle(Messages.getString("DirectorySelectionDialog_title"));
        this.root = fileSystemElement;
        this.structureProvider = structureProvider;
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage(Messages.getString("DirectorySelectionDialog_message"));
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    public void create() {
        super.create();
        this.initializeDialog();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        FileSystemElement input = new FileSystemElement("", null, true);
        input.addChild(this.root);
        this.root.setParent(input);
        this.selectionGroup = new ContainerTreeGroup(composite, input, this.getFolderProvider(), this.getDynamicFolderProvider(), (ILabelProvider)new WorkbenchLabelProvider(), 0, 500, 250);
        ISelectionChangedListener listener = event -> this.getOkButton().setEnabled(event.getSelection() != null && !event.getSelection().isEmpty());
        WorkbenchViewerComparator comparator = new WorkbenchViewerComparator();
        this.selectionGroup.setTreeComparator((ViewerComparator)comparator);
        this.selectionGroup.addSelectionChangedListener(listener);
        return composite;
    }

    public boolean getExpandAllOnOpen() {
        return this.expandAllOnOpen;
    }

    private ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof FileSystemElement) {
                    return ((FileSystemElement)o).getFolders().getChildren(o);
                }
                return new Object[0];
            }
        };
    }

    private ITreeContentProvider getDynamicFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    return ((MinimizedFileSystemElement)((Object)o)).getFolders(ContainerDirectorySelectionDialog.this.structureProvider).getChildren(o);
                }
                if (o instanceof FileSystemElement) {
                    return ((FileSystemElement)o).getFolders().getChildren(o);
                }
                return new Object[0];
            }
        };
    }

    private void initializeDialog() {
        if (this.getInitialElementSelections().isEmpty()) {
            this.getOkButton().setEnabled(false);
        }
        this.selectionGroup.aboutToOpen();
    }

    protected void okPressed() {
        Object result = this.selectionGroup.getCurrentSelection();
        if (result != null) {
            MinimizedFileSystemElement selected = (MinimizedFileSystemElement)((Object)result);
            ArrayList<ContainerFileProxy> list = new ArrayList<ContainerFileProxy>();
            list.add((ContainerFileProxy)selected.getFileSystemObject());
            this.setResult(list);
        }
        super.okPressed();
    }

    public void setExpandAllOnOpen(boolean expandAll) {
        this.expandAllOnOpen = expandAll;
    }
}

