/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class CopyValueAction
extends Action {
    private Clipboard clipboard;
    private TreeViewer treeViewer;

    public CopyValueAction(TreeViewer tableViewer, Clipboard clipboard) {
        super(DVMessages.getString("CopyAction.text"));
        this.setToolTipText(DVMessages.getString("CopyAction.tooltip"));
        this.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.treeViewer = tableViewer;
        this.clipboard = clipboard;
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (!selection.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean needEOL = false;
            for (Object item : selection) {
                if (needEOL) {
                    sb.append(System.getProperty("line.separator"));
                } else {
                    needEOL = true;
                }
                Object[] text = (Object[])item;
                sb.append((String)text[1]);
            }
            this.clipboard.setContents((Object[])new String[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }
}

