/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.ui.views.SpecialColumnLabelProvider;
import org.eclipse.swt.widgets.TableColumn;

public class DockerImagesComparator
extends ViewerComparator {
    private final TableViewer tableViewer;
    private int sortColumnIndex;
    private int sortDirection;

    public DockerImagesComparator(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    public void setColumn(TableColumn sortColumn) {
        TableColumn[] tableColumns = this.tableViewer.getTable().getColumns();
        int newSortColumnIndex = 0;
        int i = 0;
        while (i < tableColumns.length) {
            if (this.tableViewer.getTable().getColumns()[i] == sortColumn) {
                newSortColumnIndex = i;
                break;
            }
            ++i;
        }
        this.sortDirection = this.sortColumnIndex != newSortColumnIndex ? 128 : (this.sortDirection == 128 ? 1024 : 128);
        this.sortColumnIndex = newSortColumnIndex;
        this.tableViewer.getTable().setSortColumn(sortColumn);
        this.tableViewer.getTable().setSortDirection(this.sortDirection);
    }

    public int getDirection() {
        return this.sortDirection;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (!(e1 instanceof IDockerImage) || !(e2 instanceof IDockerImage)) {
            return 0;
        }
        int tmp = this.compareByColumn((IDockerImage)e1, (IDockerImage)e2);
        return tmp * this.sortDirection;
    }

    private int compareByColumn(IDockerImage image1, IDockerImage image2) {
        String image2ColumnValue;
        String image1ColumnValue;
        ColumnLabelProvider sortColumnLabelProvider = (ColumnLabelProvider)this.tableViewer.getLabelProvider(this.sortColumnIndex);
        if (sortColumnLabelProvider instanceof SpecialColumnLabelProvider) {
            image1ColumnValue = ((SpecialColumnLabelProvider)sortColumnLabelProvider).getCompareText(image1);
            image2ColumnValue = ((SpecialColumnLabelProvider)sortColumnLabelProvider).getCompareText(image2);
        } else {
            image1ColumnValue = sortColumnLabelProvider.getText((Object)image1);
            image2ColumnValue = sortColumnLabelProvider.getText((Object)image2);
        }
        if (this.sortDirection == 128) {
            return image1ColumnValue.compareToIgnoreCase(image2ColumnValue);
        }
        return image1ColumnValue.compareToIgnoreCase(image2ColumnValue) * -1;
    }
}

