/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.dataprovider;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.ITmfGraphVisitor;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.CriticalPathModule;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.TmfGraphStatistics;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.TmfGraphVisitor;
import org.eclipse.tracecompass.internal.analysis.graph.core.dataprovider.CriticalPathEntry;
import org.eclipse.tracecompass.internal.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.IRegexQuery;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.TimeGraphStateQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CriticalPathDataProvider
extends AbstractTmfTraceDataProvider
implements ITimeGraphDataProvider<CriticalPathEntry> {
    public static final @NonNull String ID = "org.eclipse.tracecompass.analysis.graph.core.dataprovider.CriticalPathDataProvider";
    private static final AtomicLong ATOMIC_LONG = new AtomicLong();
    private @NonNull CriticalPathModule fCriticalPathModule;
    private final Map<String, Long> fHostIdToEntryId = new HashMap<String, Long>();
    private final BiMap<IGraphWorker, Long> fWorkerToEntryId = HashBiMap.create();
    private final LoadingCache<IGraphWorker, CriticalPathVisitor> fHorizontalVisitorCache = CacheBuilder.newBuilder().maximumSize(10L).build((CacheLoader)new CacheLoader<IGraphWorker, CriticalPathVisitor>(){

        public CriticalPathVisitor load(IGraphWorker key) throws Exception {
            TmfGraph criticalPath = CriticalPathDataProvider.this.fCriticalPathModule.getCriticalPath();
            return new CriticalPathVisitor(criticalPath, key);
        }
    });
    private List<ITimeGraphArrow> fLinks;

    public CriticalPathDataProvider(@NonNull ITmfTrace trace, @NonNull CriticalPathModule criticalPathProvider) {
        super(trace);
        this.fCriticalPathModule = criticalPathProvider;
    }

    public synchronized @NonNull TmfModelResponse<@NonNull List<@NonNull CriticalPathEntry>> fetchTree(@NonNull TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        TmfGraph graph = this.fCriticalPathModule.getCriticalPath();
        if (graph == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
        }
        IGraphWorker current = this.getCurrent();
        if (current == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        CriticalPathVisitor visitor = (CriticalPathVisitor)this.fHorizontalVisitorCache.getUnchecked((Object)current);
        return new TmfModelResponse(visitor.getEntries(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private @Nullable IGraphWorker getCurrent() {
        Object obj = this.fCriticalPathModule.getParameter("workerid");
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof IGraphWorker)) {
            throw new IllegalStateException("Wrong type for critical path module parameter workerid expected IGraphWorker got " + obj.getClass().getSimpleName());
        }
        return (IGraphWorker)obj;
    }

    public @NonNull String getId() {
        return ID;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphRowModel>> fetchRowModel(@NonNull SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        IGraphWorker graphWorker = this.getCurrent();
        if (graphWorker == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        CriticalPathVisitor visitor = (CriticalPathVisitor)this.fHorizontalVisitorCache.getIfPresent((Object)graphWorker);
        if (visitor == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        HashMap<@NonNull K, @NonNull @NonNull @NonNull @NonNull V> predicates = new HashMap();
        if (filter instanceof TimeGraphStateQueryFilter) {
            TimeGraphStateQueryFilter timeEventFilter = (TimeGraphStateQueryFilter)filter;
            predicates.putAll(this.computeRegexPredicate((IRegexQuery)timeEventFilter));
        }
        ArrayList<@NonNull TimeGraphRowModel> rowModels = new ArrayList<TimeGraphRowModel>();
        for (Long id : filter.getSelectedItems()) {
            Collection states = (Collection)visitor.fStates.asMap().get(id);
            if (states == null) continue;
            ArrayList filteredStates = new ArrayList();
            for (ITimeGraphState state : states) {
                if (!CriticalPathDataProvider.overlaps(state.getStartTime(), state.getDuration(), filter.getTimesRequested())) continue;
                state.setActiveProperties(0);
                this.addToStateList(filteredStates, state, id, predicates, monitor);
            }
            rowModels.add(new TimeGraphRowModel(id.longValue(), filteredStates));
        }
        return new TmfModelResponse(rowModels, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private static final boolean overlaps(long start, long duration, long[] times) {
        int pos = Arrays.binarySearch(times, start);
        if (pos >= 0) {
            return true;
        }
        int ins = -pos - 1;
        if (ins >= times.length) {
            return false;
        }
        return times[ins] <= start + duration;
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(this.getLinkList(filter.getStart(), filter.getEnd()), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(@NonNull SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        IGraphWorker worker = (IGraphWorker)this.fWorkerToEntryId.inverse().get(filter.getSelectedItems().iterator().next());
        if (worker == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        Map<@NonNull String, @NonNull String> info = worker.getWorkerInformation(filter.getStart());
        return new TmfModelResponse(info, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private @Nullable List<@NonNull ITimeGraphArrow> getLinkList(long startTime, long endTime) {
        IGraphWorker current = this.getCurrent();
        List<ITimeGraphArrow> graphLinks = this.fLinks;
        if (current == null) {
            if (graphLinks != null) {
                return graphLinks;
            }
            return Collections.emptyList();
        }
        CriticalPathVisitor visitor = (CriticalPathVisitor)this.fHorizontalVisitorCache.getIfPresent((Object)current);
        if (visitor == null) {
            return Collections.emptyList();
        }
        this.fLinks = graphLinks = visitor.getGraphLinks();
        return CriticalPathDataProvider.getLinksInRange(graphLinks, startTime, endTime);
    }

    private static List<@NonNull ITimeGraphArrow> getLinksInRange(List<ITimeGraphArrow> allLinks, long startTime, long endTime) {
        ArrayList<@NonNull ITimeGraphArrow> linksInRange = new ArrayList<ITimeGraphArrow>();
        for (ITimeGraphArrow link : allLinks) {
            if (link.getStartTime() > endTime || link.getStartTime() + link.getDuration() < startTime) continue;
            linksInRange.add(link);
        }
        return linksInRange;
    }

    private static int getMatchingState(TmfEdge.EdgeType type) {
        switch (type) {
            case RUNNING: {
                return 0;
            }
            case INTERRUPTED: {
                return 1;
            }
            case PREEMPTED: {
                return 2;
            }
            case TIMER: {
                return 3;
            }
            case BLOCK_DEVICE: {
                return 4;
            }
            case USER_INPUT: {
                return 5;
            }
            case NETWORK: {
                return 6;
            }
            case IPI: {
                return 7;
            }
            case EPS: 
            case UNKNOWN: 
            case DEFAULT: 
            case BLOCKED: {
                break;
            }
        }
        return 8;
    }

    private final class CriticalPathVisitor
    extends TmfGraphVisitor {
        private final TmfGraph fGraph;
        private final Map<String, CriticalPathEntry> fHostEntries = new HashMap<String, CriticalPathEntry>();
        private final Map<IGraphWorker, CriticalPathEntry> fWorkers = new LinkedHashMap<IGraphWorker, CriticalPathEntry>();
        private final TmfGraphStatistics fStatistics = new TmfGraphStatistics();
        private final TreeMultimap<Long, ITimeGraphState> fStates = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparingLong(ITimeGraphState::getStartTime));
        private long fStart;
        private long fEnd;
        private List<@NonNull CriticalPathEntry> fCached;
        private @Nullable List<ITimeGraphArrow> fGraphLinks;

        private CriticalPathVisitor(TmfGraph graph, IGraphWorker worker) {
            this.fGraph = graph;
            this.fStart = CriticalPathDataProvider.this.getTrace().getStartTime().toNanos();
            this.fEnd = CriticalPathDataProvider.this.getTrace().getEndTime().toNanos();
            TmfVertex head = graph.getHead();
            if (head != null) {
                this.fStart = Long.min(this.fStart, head.getTs());
                for (IGraphWorker w : graph.getWorkers()) {
                    TmfVertex tail = graph.getTail(w);
                    if (tail == null) continue;
                    this.fEnd = Long.max(this.fEnd, tail.getTs());
                }
            }
            this.fStatistics.computeGraphStatistics(graph, worker);
        }

        @Override
        public void visitHead(TmfVertex node) {
            IGraphWorker owner = this.fGraph.getParentOf(node);
            if (owner == null) {
                return;
            }
            if (this.fWorkers.containsKey(owner)) {
                return;
            }
            TmfVertex first = this.fGraph.getHead(owner);
            TmfVertex last = this.fGraph.getTail(owner);
            if (first == null || last == null) {
                return;
            }
            this.fStart = Long.min(CriticalPathDataProvider.this.getTrace().getStartTime().toNanos(), first.getTs());
            this.fEnd = Long.max(CriticalPathDataProvider.this.getTrace().getEndTime().toNanos(), last.getTs());
            Long sum = this.fStatistics.getSum(owner);
            Double percent = this.fStatistics.getPercent(owner);
            String host = owner.getHostId();
            long parentId = CriticalPathDataProvider.this.fHostIdToEntryId.computeIfAbsent(host, h -> ATOMIC_LONG.getAndIncrement());
            this.fHostEntries.computeIfAbsent(host, h -> new CriticalPathEntry(parentId, -1L, host, this.fStart, this.fEnd, sum, percent));
            long entryId = (Long)CriticalPathDataProvider.this.fWorkerToEntryId.computeIfAbsent((Object)owner, w -> ATOMIC_LONG.getAndIncrement());
            CriticalPathEntry entry = new CriticalPathEntry(entryId, parentId, owner, this.fStart, this.fEnd, sum, percent);
            this.fWorkers.put(owner, entry);
        }

        @Override
        public void visit(TmfEdge link, boolean horizontal) {
            if (horizontal) {
                IGraphWorker parent = this.fGraph.getParentOf(link.getVertexFrom());
                Long id = (Long)CriticalPathDataProvider.this.fWorkerToEntryId.get((Object)parent);
                if (id != null) {
                    String linkQualifier = link.getLinkQualifier();
                    TimeGraphState ev = linkQualifier == null ? new TimeGraphState(link.getVertexFrom().getTs(), link.getDuration(), CriticalPathDataProvider.getMatchingState(link.getType())) : new TimeGraphState(link.getVertexFrom().getTs(), link.getDuration(), CriticalPathDataProvider.getMatchingState(link.getType()), linkQualifier);
                    this.fStates.put((Object)id, (Object)ev);
                }
            } else {
                IGraphWorker parentFrom = this.fGraph.getParentOf(link.getVertexFrom());
                IGraphWorker parentTo = this.fGraph.getParentOf(link.getVertexTo());
                CriticalPathEntry entryFrom = this.fWorkers.get(parentFrom);
                CriticalPathEntry entryTo = this.fWorkers.get(parentTo);
                List<ITimeGraphArrow> graphLinks = this.fGraphLinks;
                if (graphLinks != null && entryFrom != null && entryTo != null) {
                    TimeGraphArrow lk = new TimeGraphArrow(entryFrom.getId(), entryTo.getId(), link.getVertexFrom().getTs(), link.getVertexTo().getTs() - link.getVertexFrom().getTs(), CriticalPathDataProvider.getMatchingState(link.getType()));
                    graphLinks.add((ITimeGraphArrow)lk);
                }
            }
        }

        public @NonNull List<@NonNull CriticalPathEntry> getEntries() {
            if (this.fCached != null) {
                return this.fCached;
            }
            this.fGraph.scanLineTraverse(this.fGraph.getHead(), (ITmfGraphVisitor)this);
            ArrayList<@NonNull CriticalPathEntry> list = new ArrayList<CriticalPathEntry>(this.fHostEntries.values());
            list.addAll(this.fWorkers.values());
            this.fCached = list;
            return list;
        }

        public synchronized List<ITimeGraphArrow> getGraphLinks() {
            if (this.fGraphLinks == null) {
                this.fGraphLinks = new ArrayList<ITimeGraphArrow>();
                this.fGraph.scanLineTraverse(this.fGraph.getHead(), (ITmfGraphVisitor)this);
            }
            return this.fGraphLinks;
        }
    }
}

