/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport.sshd;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpClientFactory;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.subsystem.sftp.SftpException;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.FtpChannel;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.sshd.SessionCloseListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshdSession
implements RemoteSession {
    private static final Logger LOG = LoggerFactory.getLogger(SshdSession.class);
    private final CopyOnWriteArrayList<SessionCloseListener> listeners = new CopyOnWriteArrayList();
    private final URIish uri;
    private SshClient client;
    private ClientSession session;

    SshdSession(URIish uri, Supplier<SshClient> clientFactory) {
        this.uri = uri;
        this.client = clientFactory.get();
    }

    void connect(Duration timeout) throws IOException {
        if (!this.client.isStarted()) {
            this.client.start();
        }
        try {
            String username = this.uri.getUser();
            String host = this.uri.getHost();
            int port = this.uri.getPort();
            long t = timeout.toMillis();
            this.session = t <= 0L ? ((ConnectFuture)this.client.connect(username, host, port).verify()).getSession() : ((ConnectFuture)this.client.connect(username, host, port).verify(timeout.toMillis())).getSession();
            this.session.addSessionListener(new SessionListener(){

                public void sessionClosed(Session s) {
                    SshdSession.this.notifyCloseListeners();
                }
            });
            this.session.auth().verify(this.session.getAuthTimeout());
        }
        catch (IOException e) {
            this.disconnect(e);
            throw e;
        }
    }

    public void addCloseListener(@NonNull SessionCloseListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeCloseListener(@NonNull SessionCloseListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyCloseListeners() {
        for (SessionCloseListener l : this.listeners) {
            try {
                l.sessionClosed(this);
            }
            catch (RuntimeException e) {
                LOG.warn(SshdText.get().closeListenerFailed, (Throwable)e);
            }
        }
    }

    public Process exec(String commandName, int timeout) throws IOException {
        ChannelExec exec = this.session.createExecChannel(commandName);
        long timeoutMillis = TimeUnit.SECONDS.toMillis(timeout);
        try {
            if (timeout <= 0) {
                exec.open().verify();
            } else {
                long start = System.nanoTime();
                exec.open().verify(timeoutMillis);
                timeoutMillis -= TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            }
        }
        catch (IOException e) {
            exec.close(true);
            throw e;
        }
        catch (RuntimeException e) {
            exec.close(true);
            throw e;
        }
        if (timeout > 0 && timeoutMillis <= 0L) {
            exec.close(true);
            throw new InterruptedIOException(MessageFormat.format(SshdText.get().sshCommandTimeout, commandName, timeout));
        }
        return new SshdExecProcess(exec, commandName, timeoutMillis);
    }

    @NonNull
    public FtpChannel getFtpChannel() {
        return new SshdFtpChannel();
    }

    public void disconnect() {
        this.disconnect(null);
    }

    private void disconnect(Throwable reason) {
        try {
            try {
                if (this.session != null) {
                    this.session.close();
                    this.session = null;
                }
            }
            catch (IOException e) {
                if (reason != null) {
                    reason.addSuppressed(e);
                } else {
                    LOG.error(SshdText.get().sessionCloseFailed, (Throwable)e);
                }
                this.client.stop();
                this.client = null;
            }
        }
        finally {
            this.client.stop();
            this.client = null;
        }
    }

    @FunctionalInterface
    private static interface FtpOperation<T> {
        public T call() throws IOException;
    }

    private static class SshdExecProcess
    extends Process {
        private final ChannelExec channel;
        private final long timeoutMillis;
        private final String commandName;

        public SshdExecProcess(ChannelExec channel, String commandName, long timeoutMillis) {
            this.channel = channel;
            this.timeoutMillis = timeoutMillis > 0L ? timeoutMillis : -1L;
            this.commandName = commandName;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.channel.getInvertedIn();
        }

        @Override
        public InputStream getInputStream() {
            return this.channel.getInvertedOut();
        }

        @Override
        public InputStream getErrorStream() {
            return this.channel.getInvertedErr();
        }

        @Override
        public int waitFor() throws InterruptedException {
            if (this.waitFor(this.timeoutMillis, TimeUnit.MILLISECONDS)) {
                return this.exitValue();
            }
            return -1;
        }

        @Override
        public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
            long millis = timeout >= 0L ? unit.toMillis(timeout) : -1L;
            return this.channel.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), millis).contains(ClientChannelEvent.CLOSED);
        }

        @Override
        public int exitValue() {
            Integer exitCode = this.channel.getExitStatus();
            if (exitCode == null) {
                throw new IllegalThreadStateException(MessageFormat.format(SshdText.get().sshProcessStillRunning, this.commandName));
            }
            return exitCode;
        }

        @Override
        public void destroy() {
            if (this.channel.isOpen()) {
                this.channel.close(true);
            }
        }
    }

    private class SshdFtpChannel
    implements FtpChannel {
        private SftpClient ftp;
        private String cwd = "";

        private SshdFtpChannel() {
        }

        public void connect(int timeout, TimeUnit unit) throws IOException {
            if (timeout <= 0) {
                SshdSession.this.session.getProperties().put("sftp-channel-open-timeout", Long.MAX_VALUE);
            } else {
                SshdSession.this.session.getProperties().put("sftp-channel-open-timeout", unit.toMillis(timeout));
            }
            this.ftp = SftpClientFactory.instance().createSftpClient(SshdSession.this.session);
            try {
                this.cd(this.cwd);
            }
            catch (IOException e) {
                this.ftp.close();
            }
        }

        public void disconnect() {
            try {
                this.ftp.close();
            }
            catch (IOException e) {
                LOG.error(SshdText.get().ftpCloseFailed, (Throwable)e);
            }
        }

        public boolean isConnected() {
            return SshdSession.this.session.isAuthenticated() && this.ftp.isOpen();
        }

        private String absolute(String path) {
            if (path.isEmpty()) {
                return this.cwd;
            }
            if (path.charAt(0) != '/') {
                if (this.cwd.charAt(this.cwd.length() - 1) == '/') {
                    return String.valueOf(this.cwd) + path;
                }
                return String.valueOf(this.cwd) + '/' + path;
            }
            return path;
        }

        private <T> T map(FtpOperation<T> op) throws IOException {
            try {
                return op.call();
            }
            catch (IOException e) {
                if (e instanceof SftpException) {
                    throw new FtpChannel.FtpException(e.getLocalizedMessage(), ((SftpException)e).getStatus(), (Throwable)e);
                }
                throw e;
            }
        }

        public void cd(String path) throws IOException {
            this.cwd = this.map(() -> this.ftp.canonicalPath(this.absolute(path)));
            if (this.cwd.isEmpty()) {
                this.cwd = String.valueOf(this.cwd) + '/';
            }
        }

        public String pwd() throws IOException {
            return this.cwd;
        }

        public Collection<FtpChannel.DirEntry> ls(String path) throws IOException {
            return this.map(() -> {
                ArrayList<2> result = new ArrayList<2>();
                Throwable throwable = null;
                Object var4_5 = null;
                try (SftpClient.CloseableHandle handle = this.ftp.openDir(this.absolute(path));){
                    AtomicReference<Boolean> atEnd = new AtomicReference<Boolean>(Boolean.FALSE);
                    while (!atEnd.get().booleanValue()) {
                        List chunk = this.ftp.readDir((SftpClient.Handle)handle, atEnd);
                        if (chunk == null) {
                            break;
                        }
                        for (final SftpClient.DirEntry remote : chunk) {
                            result.add(new FtpChannel.DirEntry(){

                                public String getFilename() {
                                    return remote.getFilename();
                                }

                                public long getModifiedTime() {
                                    return remote.getAttributes().getModifyTime().toMillis();
                                }

                                public boolean isDirectory() {
                                    return remote.getAttributes().isDirectory();
                                }
                            });
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return result;
            });
        }

        public void rmdir(String path) throws IOException {
            this.map(() -> {
                this.ftp.rmdir(this.absolute(path));
                return null;
            });
        }

        public void mkdir(String path) throws IOException {
            this.map(() -> {
                this.ftp.mkdir(this.absolute(path));
                return null;
            });
        }

        public InputStream get(String path) throws IOException {
            return this.map(() -> this.ftp.read(this.absolute(path)));
        }

        public OutputStream put(String path) throws IOException {
            return this.map(() -> this.ftp.write(this.absolute(path)));
        }

        public void rm(String path) throws IOException {
            this.map(() -> {
                this.ftp.remove(this.absolute(path));
                return null;
            });
        }

        public void rename(String from, String to) throws IOException {
            this.map(() -> {
                block2: {
                    String src = this.absolute(from);
                    String dest = this.absolute(to);
                    try {
                        this.ftp.rename(src, dest, new SftpClient.CopyMode[]{SftpClient.CopyMode.Atomic, SftpClient.CopyMode.Overwrite});
                    }
                    catch (UnsupportedOperationException e) {
                        if (src.equals(dest)) break block2;
                        this.delete(dest);
                        this.ftp.rename(src, dest);
                    }
                }
                return null;
            });
        }
    }
}

